import java.util.Random;
import sdl4gcj.Sys;
import sdl4gcj.video.*;
import sdl4gcj.event.*;
import sdl4gcj.input.*;

public class PaletteTest
{
	public static int SCREEN_BPP = 8;

	public static Palette createGrayscalePaletteFrom(Palette palette)
	{
		Palette newPalette = new Palette(palette.getSize());
		for (int i = palette.getSize()-1;i >= 0;i--)
		{
			Color color = palette.getColorAt(i);
			int luminance = (int)(0.3 * color.r + 0.59 * color.g + 0.11 * color.b);
			color.r = color.g = color.b = luminance;
			newPalette.setColorAt(i, color);
		}
		
		return newPalette;
	}

	public static Palette createValuePaletteFrom(Palette palette)
	{
		Palette newPalette = new Palette(palette.getSize());
		for (int i = palette.getSize()-1;i >= 0;i--)
		{
			Color color = palette.getColorAt(i);
			int v = color.r;
			if (color.g > v) v = color.g;
			if (color.b > v) v = color.b;
			color.r = color.g = color.b = v;
			newPalette.setColorAt(i, color);
		}
		
		return newPalette;
	}


	public static Palette createSaturationPaletteFrom(Palette palette)
	{
		Palette newPalette = new Palette(palette.getSize());
		for (int i = palette.getSize()-1;i >= 0;i--)
		{
			Color color = palette.getColorAt(i);
			int max = color.r;
			if (color.g > max) max = color.g;
			if (color.b > max) max = color.b;
			int min = color.r;
			if (color.g < min) min = color.g;
			if (color.b < min) min = color.b;
			color.r = color.g = color.b = (max - min) * 0xff / max;
			newPalette.setColorAt(i, color);
		}
		
		return newPalette;
	}

	public static Palette createInversedPaletteFrom(Palette palette)
	{
		Palette newPalette = new Palette(palette.getSize());
		for (int i = palette.getSize()-1;i >= 0;i--)
		{
			Color color = palette.getColorAt(i);
			color.r = 0xff - color.r;
			color.g = 0xff - color.g;
			color.b = 0xff - color.b;
			newPalette.setColorAt(i, color);
		}
		
		return newPalette;
	}

	public static void main(String[] args)
	{
		if (Sys.init(Sys.SDL_INIT_VIDEO) != 0)
		{
			System.out.println("Init() fail");
			System.exit(0);
		}

		SDLOptionParser optParser = new SDLOptionParser(
			640, 480, SCREEN_BPP, Surface.SDL_SWSURFACE);
		optParser.parse(args);

		try
		{
			Screen screen = Screen.setVideoMode(
				optParser.getScreenWidth(), optParser.getScreenHeight(),
				SCREEN_BPP, optParser.getVideoFlags());

			Surface logo = Surface.loadBMP("images/logo.bmp");

			screen.setPalette(logo.getPalette());
			screen.repeatSurface(logo);
			screen.flip();

			logo.displayFormat();

			Palette[] palettes = new Palette[5];
			int index = 0;
			palettes[index++] = screen.getPalette();
			palettes[index++] = createInversedPaletteFrom(palettes[0]);
			palettes[index++] = createGrayscalePaletteFrom(palettes[0]);
			palettes[index++] = createSaturationPaletteFrom(palettes[0]);
			palettes[index++] = createValuePaletteFrom(palettes[0]);

			boolean done = false;
			EventManager event = new EventManager();
			while (!done)
			{
				long startTicks = Sys.getTicks();
				event.waitEvent();
				switch (event.type)
				{
					case SDLEvent.SDL_KEYDOWN :
						if (event.keydown.sym == Keyboard.SDLK_ESCAPE ||
							event.keydown.sym == Keyboard.SDLK_q )
						{
							done = true;
						}
						else if (event.keydown.sym >= Keyboard.SDLK_1 &&
							event.keydown.sym <= Keyboard.SDLK_5)
						{
							int i = event.keydown.sym - Keyboard.SDLK_1;
							screen.setPalette(palettes[i]);
						}
						break;
					case SDLEvent.SDL_QUIT:
						done = true;
						break;
					default:
						break;
				}
				screen.flip();
			}

		}
		catch (Exception e)
		{
			e.printStackTrace();
		}
		finally
		{
			Sys.quit();
		}
	}
}
