#include "sdl4gcj/image/Image.h"

#include "sdl4gcj/video/Surface.h"
#include "sdl4gcj/Version.h"
#include "sdl4gcj/SDLException.h"

#include <gcj/cni.h>
#include <java/lang/String.h>
#include <stdlib.h>
#include <string.h>
#include <SDL.h>
#include <SDL_image.h>


using namespace sdl4gcj::image;
using sdl4gcj::Version;
using sdl4gcj::video::Surface;

Version*
Image::compiledVersion()
{
	JvInitClass(&Image::class$);

	SDL_version nativeVersion;
	SDL_IMAGE_VERSION(&nativeVersion);

	Version* compiledVersion = new Version(
		nativeVersion.major,
		nativeVersion.minor,
		nativeVersion.patch);

	return compiledVersion;
}

Version*
Image::linkedVersion()
{
	JvInitClass(&Image::class$);

	const SDL_version* nativeVersion = IMG_Linked_Version();

	Version* linkedVersion = new Version(
		nativeVersion->major,
		nativeVersion->minor,
		nativeVersion->patch);

	return linkedVersion;
}


Surface *
Image::load(::java::lang::String* filePath)
{
	JvInitClass(&Image::class$);
	Surface* result = NULL;

	jbyteArray byteArray = filePath->getBytes();
	int length = byteArray->length;
	jbyte* bytes = elements(byteArray);
	char buffer[length+1];

	memcpy(buffer, bytes, length);
	buffer[length] = '\0';

	SDL_Surface* image = IMG_Load(buffer);
	if (image != NULL)
	{
		result = new Surface();
		result->implementation = (::gnu::gcj::RawData*)image;
	}

	return result;
}

Surface *
Image::load(JArray<jbyte>* byteArray, jint offset, jint length)
{
	JvInitClass(&Image::class$);
	Surface* result = NULL;
	jbyte* bytes = elements(byteArray) + offset;

	SDL_Surface* image = IMG_Load_RW(SDL_RWFromMem(bytes, length), 1);
	if (image != NULL)
	{
		result = new Surface();
		result->implementation = (::gnu::gcj::RawData*)image;
	}

	return result;
}

