package sdl4gcj.image;

import sdl4gcj.Version;
import sdl4gcj.video.Surface;

import java.io.File;
import java.io.InputStream;
import java.io.IOException;

public class Image 
{
	// instance variables
	/**
	* Get version of compiled library.
	* @return version of compiled library 
	**/
	public static native Version compiledVersion();

	/**
	* Get version of linked library .
	* @return version of linked library
	**/
	public static native Version linkedVersion();

	public static native Surface load(String filePath);
	public static Surface load(File file)
	{
		return load(file.getAbsolutePath());
	}

	public native static Surface load(byte[] bytes, int offset, int length);

	/**
	* same as load(bytes, 0, bytes.length);
	**/
	public static Surface load(byte[] bytes)
	{
		return load(bytes, 0, bytes.length);
	}

	public static Surface load(InputStream inputStream)
	{
		Surface result = null;
		byte[] bytes = new byte[4096];
		int index = 0;
		int data = -1;
		
		try
		{
			while ((data = inputStream.read()) != -1)
			{
				if (index >= bytes.length)
					bytes = new byte[bytes.length*2];
				bytes[index++] = (byte)data;
			}
			result = load(bytes, 0, index);
		}
		catch (IOException ioe)
		{
			ioe.printStackTrace();
		}

		return result;
	}
}

