#include "sdl4gcj/cdrom/CD.h"
#include "sdl4gcj/cdrom/CDTrack.h"
#include "sdl4gcj/SDLException.h"
#include "java/lang/StringBuffer.h"

#include <gcj/cni.h>
#include <SDL.h>

using namespace sdl4gcj::cdrom;
using namespace java::lang;

// function
static
::sdl4gcj::SDLException*
createNotOpenedException(CD* cd)
{
	StringBuffer* buffer = new StringBuffer();
	buffer->append(JvNewStringLatin1("CD drive(index = "));
	buffer->append(cd->getIndex());
	buffer->append(JvNewStringLatin1(",name = "));
	buffer->append(cd->getName());
	buffer->append(JvNewStringLatin1(" is not opened : "));
	
	return new sdl4gcj::SDLException(buffer->toString());
}

// class methods
jint 
CD::getNumDrives ()
{
	JvInitClass(&CD::class$);
	return SDL_CDNumDrives();
}


// instance method
::java::lang::String *
CD::getName ()
{
	::java::lang::String *name = NULL;
	const char* nativeName = NULL;

	nativeName = SDL_CDName(this->getIndex());
	if (nativeName != NULL)
	{
		int bytesLength = strlen(nativeName);
		jbyteArray byteArray = JvNewByteArray(bytesLength+1);
		jbyte* bytes = elements(byteArray);
		strcpy((char*)bytes, nativeName);
		name = new String(byteArray);
	}

	return name;
}

jboolean 
CD::isOpened ()
{
	return (this->implementation != NULL);
}

void 
CD::open ()
{
	if (!this->isOpened())
	{
		SDL_CD* nativeCD;
		nativeCD = SDL_CDOpen(this->getIndex());
		this->implementation = (::gnu::gcj::RawData*)nativeCD;
	}
}

void 
CD::close ()
{
	if (this->isOpened())
	{
		SDL_CD* nativeCD = (SDL_CD*)this->implementation;
		SDL_CDClose(nativeCD);
		this->implementation = NULL;
	}
}

jint 
CD::getStatus ()
{
	SDL_CD* nativeCD = (SDL_CD*)this->implementation;
	if (nativeCD == NULL) throw createNotOpenedException(this);

	jint result = SDL_CDStatus(nativeCD);

	return result;
}

void 
CD::play (jint start_frame, jint frame_length)
{
	SDL_CD* nativeCD = (SDL_CD*)this->implementation;
	if (nativeCD == NULL) throw createNotOpenedException(this);

	jint result = SDL_CDPlay(nativeCD, start_frame, frame_length);
	if (result == -1) throw new SDLException();
}

void 
CD::playTracks (jint start_track, jint start_frame, jint ntracks, jint nframes)
{
	SDL_CD* nativeCD = (SDL_CD*)this->implementation;
	if (nativeCD == NULL) throw createNotOpenedException(this);

	jint result = SDL_CDPlayTracks(nativeCD, start_track, start_frame, ntracks, nframes);
	if (result == -1) throw new SDLException();
}

void 
CD::pause ()
{
	SDL_CD* nativeCD = (SDL_CD*)this->implementation;
	if (nativeCD == NULL) throw createNotOpenedException(this);

	jint result = SDL_CDPause(nativeCD);
	if (result == -1) throw new SDLException();
}

void 
CD::resume ()
{
	SDL_CD* nativeCD = (SDL_CD*)this->implementation;
	if (nativeCD == NULL) throw createNotOpenedException(this);

	jint result = SDL_CDResume(nativeCD);
	if (result == -1) throw new SDLException();
}

void 
CD::stop ()
{
	SDL_CD* nativeCD = (SDL_CD*)this->implementation;
	if (nativeCD == NULL) throw createNotOpenedException(this);

	jint result = SDL_CDStop(nativeCD);
	if (result == -1) throw new SDLException();
}

void 
CD::eject ()
{
	SDL_CD* nativeCD = (SDL_CD*)this->implementation;
	if (nativeCD == NULL) throw createNotOpenedException(this);

	jint result = SDL_CDEject(nativeCD);
	if (result == -1) throw new SDLException();
}

jint 
CD::getNumTracks ()
{
	SDL_CD* nativeCD = (SDL_CD*)this->implementation;
	if (nativeCD == NULL) throw createNotOpenedException(this);

	jint result = nativeCD->numtracks;

	return result;
}

jint 
CD::getCurrentTrack ()
{
	SDL_CD* nativeCD = (SDL_CD*)this->implementation;
	if (nativeCD == NULL) throw createNotOpenedException(this);

	jint result = nativeCD->cur_track;

	return result;
}

jint 
CD::getCurrentFrame ()
{
	SDL_CD* nativeCD = (SDL_CD*)this->implementation;
	if (nativeCD == NULL) throw createNotOpenedException(this);

	jint result = nativeCD->cur_frame;

	return result;
}

JArray <CDTrack *>*
CD::getTracks ()
{
	SDL_CD* nativeCD = (SDL_CD*)this->implementation;
	if (nativeCD == NULL) throw createNotOpenedException(this);

	int numTracks = this->getNumTracks();
	JArray < CDTrack * >* trackArray = (JArray <CDTrack *>*)JvNewObjectArray(numTracks, (&CDTrack::class$), NULL);
	CDTrack** tracks = elements(trackArray);
	for (int i = numTracks-1;i >= 0;i--)
	{
		tracks[i] = new CDTrack(
			nativeCD->track[i].id,
			nativeCD->track[i].type,
			nativeCD->track[i].length,
			nativeCD->track[i].offset);
	}

	return trackArray;
}
