#!/bin/bash -f
#
# パスワード設定スクリプト(rootユーザー用)
#
# Developed by Yasuhiro Fujitsuki 2010/3
#
# 返り値：
# 0 = 成功
# 1 = 失敗
# 9 = ユーザー作成を実行せず
# 99 = Usage 表示/オプション設定ミス
#

###################################
# 返り値定義 / 条件を変える場合、この部分を変更する
SUCCESS=0
FAILED=1
PASSED=9
USAGE=99
###################################
# 環境変数
# 実行ファイル
GREP=/bin/grep
PASSWD=/usr/bin/passwd
WC=/usr/bin/wc
WC_L="${WC} -l"

# コンフィグファイル 
ETC_PASSWD=/etc/passwd
###################################


# 引数確認
# 引数が指定数無い場合は usage 表示を行い、終了
if [ $# -ne 2 ]; then
  echo 引数指定がされていません。
  echo 
  echo usage \> $0 [User Name] [Password] 
  echo
  echo "[User Name] ... ユーザーアカウント"
  echo "[Password]  ... パスワード"
  exit $USAGE
fi

# 引数の読み込み
USER_NAME=$1
NEW_PASSWORD=$2


# 結果用変数定義
RESULT=$SUCCESS

# ユーザーの存在確認
if [ `${GREP} ^${USER_NAME}: $ETC_PASSWD | ${WC_L} ` -eq 0 ]; then
  echo \#\#\# ユーザー ${USER_NAME} が存在しません。
  RESULT=$PASSED
else 
  # パスワード設定
  echo \#\#\# ユーザー ${USER_NAME} のパスワードを変更します。
  echo \# echo -e "$NEW_PASSWORD\n$NEW_PASSWORD" \| $PASSWD $USER_NAME
  echo -e "$NEW_PASSWORD\n$NEW_PASSWORD" | $PASSWD $USER_NAME
  RES=$?
  if [ $RES -eq $SUCCESS ]; then
    echo \#\#\# パスワードを変更しました。
    RESULT=$SUCCESS
  else
    echo \#\#\# パスワード変更に失敗しました。
    echo \#\#\# エラーコード \( cmd=$PASSWD, code=$RES \)
    RESULT=$FAILED
  fi
fi

exit $RESULT

