#!/bin/bash -f
#
# /etc/hosts レコードを利用したネットワーク検査
# ・ping での疎通確認
# ・tracert の実行
#
# Developed by Yasuhiro Fujitsuki 2010/3
#
# 返り値：
# 0 = 成功
# 1 = 失敗
# 9 = ユーザー作成を実行せず
# 99 = Usage 表示/オプション設定ミス
#

###################################
# 返り値定義 / 条件を変える場合、この部分を変更する
SUCCESS=0
FAILED=1
PASSED=9
USAGE=99
###################################
# 環境変数
# 実行ファイル
GREP=/bin/grep
WC=/usr/bin/wc 
WC_L="${WC} -l"
TRACERT=/bin/tracert
PING=/bin/ping

###################################


# 引数確認
# 引数が指定数無い場合は usage 表示を行い、終了
if [ $# -eq 0 ]; then
  echo 引数指定がされていません。
  echo 
  echo usage \> $0 [Target]
  echo
  echo "[Target]   ... /etc/hostsレコード"
  exit $USAGE
fi

echo $*
echo $1
echo $2
echo $?

