#!/bin/bash -f
#
# /etc/hosts レコードを利用したネットワーク検査
# ・ping での疎通確認
# ・tracert の実行
#
# Developed by Yasuhiro Fujitsuki 2010/3
#
# 返り値：
# 0 = 成功
# 1 = 失敗
# 9 = ユーザー作成を実行せず
# 99 = Usage 表示/オプション設定ミス
#

###################################
# 返り値定義 / 条件を変える場合、この部分を変更する
SUCCESS=0
FAILED=1
PASSED=9
USAGE=99
###################################
# 環境変数
# 実行ファイル
GREP=/bin/grep
WC=/usr/bin/wc 
WC_L="${WC} -l"
TRACERT=/bin/tracert
PING=/bin/ping

###################################


# 引数確認
# 引数が指定数無い場合は usage 表示を行い、終了
if [ $# -eq 0 ]; then
  echo 引数指定がされていません。
  echo 
  echo usage \> $0 [Hostname \| IP Address] ...
  echo
  echo "[Hostname]     ... ホスト名"
  echo "[IP Address]   ... IPアドレス"
  exit $USAGE
fi


RESULT=$SUCCESS
declare -i num=1

##################################################
# 初期情報表示
##################################################

echo
echo \#\#\# ネットワーク疎通テストを行います。
echo
echo \#\#\# 引数： $*

while [ $num -le $# ];
do
  eval echo '\#\#\#' 検査対象[$num]  : '$'$num
  num=$num+1
done


##################################################
# 検査
##################################################

num=1

while [ $num -le $# ];
do
  # 引数の取得
  eval TARGET='$'$num

  ##### ping test
  # 情報表示
  echo
  echo \#\#\# $TARGET の ping 疎通確認を行います。
  echo
  echo \# $PING -c 3 $TARGET
  $PING -c 3 $TARGET

  TEST_RESULT=$?

  if [ $TEST_RESULT -ne 0 ]; then 
    echo
    echo \#\#\# $TARGET への ping 疎通失敗
    echo \#\#\# エラーコード : $TEST_RESULT
    echo
    RESULT=$FAILED 
  fi


  ##### tracert test
  # 情報表示
  echo
  echo \#\#\# $TARGET の traceroute 確認を行います。
  echo
  echo \# $TRACERT $TARGET
  $TRACERT $TARGET

  TEST_RESULT=$?

  if [ $TEST_RESULT -ne 0 ]; then 
    echo
    echo \#\#\# $TARGET への traceroute 失敗
    echo \#\#\# エラーコード : $TEST_RESULT
    echo
    RESULT=$FAILED 
  fi

  num=$num+1
done

echo
echo \#\#\#
echo \#\#\# ネットワーク検査を終了します。
echo \#\#\# 終了コード : $RESULT
echo \#\#\#
echo


exit $RESULT



