/*
 * Decompiled with CFR 0.152.
 */
package jp.thaniwa.scriptdirector.utils;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.AbstractList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.thaniwa.scriptdirector.modules.DataFile;
import jp.thaniwa.scriptdirector.modules.Scenario;
import jp.thaniwa.scriptdirector.modules.Scene;
import jp.thaniwa.scriptdirector.modules.SceneGroup;
import jp.thaniwa.scriptdirector.utils.ScenarioExecutor;

public class ScenarioReader {
    public static Scenario read(String filename) {
        Scenario scenario = null;
        try {
            FileInputStream fStream = new FileInputStream(filename);
            InputStreamReader isReader = new InputStreamReader((InputStream)fStream, "JISAutoDetect");
            BufferedReader reader = new BufferedReader(isReader);
            scenario = ScenarioReader.read(reader);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return scenario;
    }

    private static Scenario read(BufferedReader reader) throws IOException {
        String line;
        Scenario scenario = new Scenario();
        SceneGroup sceneGroup = null;
        Scene previousScene = null;
        while ((line = reader.readLine()) != null) {
            Pattern pattern = Pattern.compile("^\\d+,");
            Matcher matcher = pattern.matcher(line);
            if (line.startsWith("D")) {
                DataFile dataFile = new DataFile(line);
                AbstractList<DataFile> list = scenario.getDataFileList();
                if (list != null && list.size() > 0) {
                    boolean flag = true;
                    for (DataFile d : list) {
                        if (d.getNumber() != dataFile.getNumber()) continue;
                        System.err.println("\u30c7\u30fc\u30bf\u30d5\u30a1\u30a4\u30eb\u8a8d\u8b58\u756a\u53f7\u304c\u91cd\u8907\u3057\u3066\u3044\u307e\u3059\u3002" + line);
                        flag = false;
                        break;
                    }
                    if (!flag) continue;
                    scenario.addDataFile(dataFile);
                    continue;
                }
                scenario.addDataFile(dataFile);
                continue;
            }
            if (!matcher.find()) continue;
            Scene scene = new Scene(line);
            if (previousScene == null || previousScene.getNumber() != scene.getNumber()) {
                sceneGroup = new SceneGroup();
                scenario.addSceneGroup(sceneGroup);
            }
            sceneGroup.addScene(scene);
            previousScene = scene;
        }
        return scenario;
    }

    public static void main(String[] args) {
        Scenario scenario = null;
        if (args != null && args.length > 0) {
            System.out.println("Input File : " + args[0]);
            scenario = ScenarioReader.read(args[0]);
        } else {
            scenario = ScenarioReader.read("C:\\Users\\yasuhiro\\Documents\\test.txt");
        }
        scenario.print();
        System.out.println("scenario step : " + scenario.getAllStepNumer());
        System.out.println("Scenario confirm : " + scenario.confirm());
        ScenarioExecutor exec = new ScenarioExecutor(scenario);
    }
}

