/*
 * Decompiled with CFR 0.152.
 */
package jp.thaniwa.scriptdirector.utils;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import jp.thaniwa.scriptdirector.modules.Data;
import jp.thaniwa.scriptdirector.modules.DataFile;
import jp.thaniwa.scriptdirector.modules.Scenario;
import jp.thaniwa.scriptdirector.modules.Scene;
import jp.thaniwa.scriptdirector.modules.SceneGroup;
import jp.thaniwa.scriptdirector.utils.RuntimeExecutor;

public class ScenarioExecutor {
    private Scenario scenario;
    private Iterator<SceneGroup> sceneGroupIterator;
    private Iterator<Scene> sceneIterator;
    private Iterator<Data> dataIterator;
    private SceneGroup sceneGroup;
    private Scene scene;
    private Data data;

    public ScenarioExecutor(Scenario scenario) {
        this.scenario = scenario;
        this.getNextSceneGroup();
    }

    public void executeAll() {
        while (this.getNextScene()) {
            System.out.println(this.scene.getComment());
            if (this.data == null) {
                System.out.println(this.scene.getCommand().getLine());
            } else {
                System.out.println(this.scene.getCommand().getExecLine(this.data.getList()));
            }
            System.out.println((Object)((Object)this.scene.getSuccessType()) + "," + (Object)((Object)this.scene.getFailedType()) + "," + (Object)((Object)this.scene.getOtherType()));
        }
    }

    public int executeNext() {
        int result = -1;
        RuntimeExecutor executor = RuntimeExecutor.getExecutor();
        if (this.getNextScene()) {
            result = this.data == null ? executor.execute(this.scene.getCommand().getArgs()) : executor.execute(this.scene.getCommand().getExecArgs(this.data.getList()));
        }
        return result;
    }

    public String getExecutedLine() {
        Iterator<String> i;
        String result = null;
        AbstractList<String> list = null;
        list = this.data == null ? this.scene.getCommand().getArgs() : this.scene.getCommand().getAnalyedArgs();
        if (list != null && (i = list.iterator()).hasNext()) {
            result = i.next();
            while (i.hasNext()) {
                result = result + " " + i.next();
            }
        }
        return result;
    }

    public String getExecutedComment() {
        return this.scene.getComment();
    }

    public void setResult(int result) {
        if (this.data != null) {
            this.scene.addExecComment(this.data.getList().get(0));
        }
        this.scene.addResult(result);
    }

    public AbstractList<String> getResultCSV(boolean intval) {
        ArrayList<String> result = new ArrayList<String>();
        String string = null;
        if (this.scenario != null) {
            Iterator<SceneGroup> sgIterator = this.scenario.getSceneGroupIterator();
            while (sgIterator.hasNext()) {
                SceneGroup sGroup = sgIterator.next();
                int checker = 0;
                Iterator<Scene> sIterator = sGroup.getSceneIterator();
                while (sIterator.hasNext()) {
                    Iterator<Object> iterator;
                    Scene s = sIterator.next();
                    if (s.getResultHistory() == null) continue;
                    if (s.getExecCommentHistory() == null) {
                        Integer integer = s.getResultHistory().get(0);
                        string = s.getComment() + "," + this.outputValue(integer, intval);
                        ((AbstractList)result).add(string);
                        continue;
                    }
                    if (checker == 0) {
                        string = "";
                        iterator = s.getExecCommentHistory().iterator();
                        while (iterator.hasNext()) {
                            string = string + "," + (String)iterator.next();
                        }
                        ((AbstractList)result).add(string);
                        ++checker;
                    }
                    string = s.getComment();
                    iterator = s.getResultHistory().iterator();
                    while (iterator.hasNext()) {
                        string = string + "," + this.outputValue((Integer)iterator.next(), intval);
                    }
                    ((AbstractList)result).add(string);
                }
            }
        }
        return result;
    }

    private String outputValue(Integer result, boolean intval) {
        String string = null;
        if (!intval) {
            switch (result) {
                case 0: {
                    string = "o";
                    break;
                }
                case 1: {
                    string = "x";
                    break;
                }
                case 9: {
                    string = "-";
                    break;
                }
                case 99: {
                    string = "-";
                    break;
                }
                default: {
                    string = "x";
                    break;
                }
            }
        } else {
            string = result.toString();
        }
        return string;
    }

    public AbstractList<String> getStdOut() {
        return RuntimeExecutor.getExecutor().getStdOut();
    }

    public AbstractList<String> getStdErr() {
        return RuntimeExecutor.getExecutor().getStdErr();
    }

    public Scene.Type getAfterExecuteAction(int execResult) {
        Scene.Type result = null;
        if (this.scene != null) {
            result = this.scene.getAfterExecType(execResult);
        }
        return result;
    }

    private void getNextData() {
        int number = this.scene.getNumber();
        DataFile dataFile = this.scenario.getDataFile(number);
        if (dataFile != null) {
            this.dataIterator = dataFile.getDataIterator();
            if (this.dataIterator != null && this.dataIterator.hasNext()) {
                this.data = this.dataIterator.next();
            }
        } else {
            this.dataIterator = null;
        }
    }

    private boolean getNextScene() {
        if (this.sceneGroup != null) {
            if (this.sceneIterator == null) {
                this.sceneIterator = this.sceneGroup.getSceneIterator();
                if (this.sceneIterator.hasNext()) {
                    this.scene = this.sceneIterator.next();
                    this.getNextData();
                } else {
                    this.scene = null;
                }
            } else if (this.sceneIterator.hasNext()) {
                this.scene = this.sceneIterator.next();
            } else if (this.dataIterator != null && this.dataIterator.hasNext()) {
                this.data = this.dataIterator.next();
                this.sceneIterator = this.sceneGroup.getSceneIterator();
                this.scene = this.sceneIterator.hasNext() ? this.sceneIterator.next() : null;
            } else {
                this.getNextSceneGroup();
                this.sceneIterator = null;
                this.dataIterator = null;
                this.data = null;
                this.getNextScene();
            }
        } else {
            this.scene = null;
        }
        boolean result = true;
        if (this.scene == null) {
            result = false;
        }
        return result;
    }

    private void getNextSceneGroup() {
        if (this.scenario != null) {
            if (this.sceneGroupIterator == null) {
                this.sceneGroupIterator = this.scenario.getSceneGroupIterator();
                if (this.sceneGroupIterator != null && this.sceneGroupIterator.hasNext()) {
                    this.sceneGroup = this.sceneGroupIterator.next();
                }
            } else {
                this.sceneGroup = this.sceneGroupIterator.hasNext() ? this.sceneGroupIterator.next() : null;
            }
        }
    }
}

