/*
 * Decompiled with CFR 0.152.
 */
package jp.thaniwa.scriptdirector.modules;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.thaniwa.scriptdirector.modules.Command;

public class Scene {
    private int number;
    private Command command;
    private Type successType;
    private Type failedType;
    private Type otherType;
    private String comment;
    private AbstractList<String> execCommentHistory;
    private AbstractList<Integer> resultHistory;

    public Scene(String line) {
        this.analyze(line);
    }

    private void analyze(String line) {
        Pattern pattern = Pattern.compile("^\\d+,");
        Matcher matcher = pattern.matcher(line);
        if (matcher.find()) {
            int i;
            String numString = matcher.group();
            this.number = new Integer(numString.substring(0, numString.length() - 1));
            String sub = matcher.replaceFirst("");
            int sNumber = sub.indexOf(",");
            String typeString = sub.substring(0, sNumber);
            this.successType = this.getType(typeString);
            if (this.successType == null) {
                this.successType = Type.Continue;
            }
            sub = sub.substring(sNumber + 1);
            sNumber = sub.indexOf(",");
            typeString = sub.substring(0, sNumber);
            this.failedType = this.getType(typeString);
            if (this.failedType == null) {
                this.failedType = this.successType;
            }
            sub = sub.substring(sNumber + 1);
            sNumber = sub.indexOf(",");
            typeString = sub.substring(0, sNumber);
            this.otherType = this.getType(typeString);
            if (this.otherType == null) {
                this.otherType = this.successType;
            }
            if ((i = (sub = sub.substring(sNumber + 1)).indexOf(",")) != -1) {
                this.command = new Command(sub.substring(0, i));
                this.comment = sub.substring(i + 1);
            } else {
                System.err.println("\u30b3\u30de\u30f3\u30c9\u3001\u30b3\u30e1\u30f3\u30c8\u5b9a\u7fa9\u304c\u4e0d\u6b63\u3067\u3059\u3002 :" + line);
            }
        } else {
            System.err.println("\u30b7\u30fc\u30f3\u306e\u5b9a\u7fa9\u884c\u306e\u5f62\u5f0f\u304c\u4e0d\u6b63\u3067\u3059\u3002 :" + line);
        }
    }

    public void addExecComment(String execComment) {
        if (this.execCommentHistory == null) {
            this.execCommentHistory = new ArrayList<String>();
        }
        this.execCommentHistory.add(execComment);
    }

    public void addResult(int result) {
        if (this.resultHistory == null) {
            this.resultHistory = new ArrayList<Integer>();
        }
        this.resultHistory.add(result);
    }

    public AbstractList<String> getExecCommentHistory() {
        return this.execCommentHistory;
    }

    public AbstractList<Integer> getResultHistory() {
        return this.resultHistory;
    }

    private Type getType(String type) {
        Type result = null;
        if (type.startsWith("C")) {
            result = Type.Continue;
        } else if (type.startsWith("P")) {
            result = Type.Pause;
        } else if (type.startsWith("R")) {
            result = Type.Retry;
        } else if (type.startsWith("S")) {
            result = Type.Stop;
        }
        return result;
    }

    public void setNumber(int number) {
        this.number = number;
    }

    public int getNumber() {
        return this.number;
    }

    public void setCommand(Command command) {
        this.command = command;
    }

    public Command getCommand() {
        return this.command;
    }

    public Type getAfterExecType(int execResult) {
        Type result = null;
        switch (execResult) {
            case 0: {
                result = this.successType;
                break;
            }
            case 1: {
                result = this.failedType;
                break;
            }
            case 9: {
                result = this.otherType;
                break;
            }
            case 99: {
                result = this.otherType;
                break;
            }
            default: {
                result = this.failedType;
            }
        }
        return result;
    }

    public Type getSuccessType() {
        return this.successType;
    }

    public Type getFailedType() {
        return this.failedType;
    }

    public Type getOtherType() {
        return this.otherType;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getComment() {
        return this.comment;
    }

    public void print() {
        System.out.println("\u30b7\u30fc\u30f3\u6982\u8981 : " + this.comment + " \u30d5\u30a1\u30a4\u30eb\u7a2e\u5225 : " + this.number);
        System.out.println("\u5b9f\u884c\u30b3\u30de\u30f3\u30c9 : " + this.command.getLine());
        System.out.println("\u6210\u529f\u6642\u5b9f\u884c\u30bf\u30a4\u30d7 : " + (Object)((Object)this.successType));
        System.out.println("\u5931\u6557\u6642\u5b9f\u884c\u30bf\u30a4\u30d7 : " + (Object)((Object)this.failedType));
        System.out.println("\u305d\u306e\u4ed6\u5b9f\u884c\u30bf\u30a4\u30d7 : " + (Object)((Object)this.otherType));
    }

    public static enum Type {
        Continue,
        Pause,
        Retry,
        Stop;

    }
}

