/*
 * Decompiled with CFR 0.152.
 */
package jp.thaniwa.scriptdirector.modules;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Command {
    private String line;
    private String analyzeLine;
    private AbstractList<String> args;
    private AbstractList<String> analyzeArgs;

    public Command(String string) {
        this.setLine(string);
        this.analyzeLine(string);
    }

    public String getAnalyzeLine() {
        return this.analyzeLine;
    }

    public void setLine(String line) {
        this.line = line;
        if (line.indexOf("\\ ") > 0) {
            line = line.replaceAll("\\\\ ", " ");
        }
        if (line.indexOf("\\\\") > 0) {
            line = line.replaceAll("\\\\\\\\", "\\\\");
        }
    }

    public String getLine() {
        return this.line;
    }

    private void analyzeLine(String line) {
        String[] analyzeString = line.split(" ");
        this.args = new ArrayList<String>();
        boolean back_slash = false;
        String resultString = "";
        for (int i = 0; i < analyzeString.length; ++i) {
            if (back_slash) {
                resultString = resultString + " " + analyzeString[i];
                back_slash = false;
            } else {
                resultString = analyzeString[i];
            }
            if (analyzeString[i].endsWith("\\") && !analyzeString[i].endsWith("\\\\")) {
                back_slash = true;
                continue;
            }
            if (resultString.indexOf("\\ ") > 0) {
                resultString = resultString.replaceAll("\\\\ ", " ");
            }
            if (resultString.indexOf("\\\\") > 0) {
                resultString = resultString.replaceAll("\\\\\\\\", "\\\\");
            }
            this.args.add(resultString);
        }
    }

    public AbstractList<String> getArgs() {
        return this.args;
    }

    public AbstractList<String> getAnalyedArgs() {
        return this.analyzeArgs;
    }

    public boolean confirm(AbstractList<String> list) {
        boolean result = true;
        String execCommand = this.getExecLine(list);
        Pattern pattern = Pattern.compile("%[1-9][0-9]*");
        Matcher matcher = pattern.matcher(execCommand);
        if (matcher.find()) {
            result = false;
        }
        return result;
    }

    public AbstractList<String> getExecArgs(AbstractList<String> list) {
        this.analyzeArgs = new ArrayList<String>();
        for (String arg : this.args) {
            if (list == null) continue;
            Pattern pattern = Pattern.compile("%[1-9][0-9]*");
            Matcher matcher = pattern.matcher(arg);
            while (matcher.find()) {
                String cutString = matcher.group();
                int number = new Integer(cutString.substring(1));
                Pattern repPattern = Pattern.compile(cutString);
                Matcher repMatcher = repPattern.matcher(arg);
                try {
                    String repString = list.get(number - 1);
                    arg = repMatcher.replaceAll(repString);
                }
                catch (Exception e) {
                    System.err.println("\u30b3\u30de\u30f3\u30c9\u5909\u63db\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002");
                    System.err.println(this.getClass().getName());
                    System.err.println(arg);
                    e.printStackTrace();
                }
            }
            this.analyzeArgs.add(arg);
        }
        return this.analyzeArgs;
    }

    public String getExecLine(AbstractList<String> list) {
        this.getExecArgs(list);
        String analyzeString = "";
        Iterator<String> i = this.analyzeArgs.iterator();
        while (i.hasNext()) {
            if (analyzeString.length() == 0) {
                analyzeString = i.next();
                continue;
            }
            analyzeString = analyzeString + " " + i.next();
        }
        this.analyzeLine = analyzeString;
        return this.analyzeLine;
    }

    public static void main(String[] args) {
        Command c = new Command("command %1 \"%2 %3\" %4:%5 %1");
        Command c2 = new Command("c:\\\\programing\\ files\\editor\\editor.exe c:\\users\\documents\\sample\\ file.txt");
        Vector<String> vector = new Vector<String>();
        vector.add("number1");
        vector.add("line 2");
        vector.add("3-comment");
        vector.add("44444");
        vector.add("555");
        System.out.println(c.getExecLine(vector));
    }
}

