#!/bin/bash -f
#
# su によるユーザーログイン確認
# ユーザーが正しく作成されたかどうかの確認を行う
# root ユーザーで行うことを前提とする
# * パスワード認証を行わないため
#
# Developed by Yasuhiro Fujitsuki 2010/3
#
# 返り値：
# 0 = ログインテスト成功
# 1 = ログインテスト失敗
# 9 = 実行せず/expectが存在しないため、実行を省略
# 99 = Usage 表示/オプション設定ミス
#

###################################
# 返り値定義 / 条件を変える場合、この部分を変更する
SUCCESS=0
FAILED=1
PASSED=9
USAGE=99
###################################
# 環境変数
# 実行ファイル 
SU=/bin/su
###################################


# 引数確認
# 引数が指定数無い場合は usage 表示を行い、終了
if [ $# -ne 1 ]; then
  echo 引数指定がされていません。
  echo 
  echo usage \> $0 [user] 
  echo
  echo [user] ... ユーザーID
  exit $USAGE
fi

# ユーザー情報の設定
USER=$1


# SU によるログインテスト 
echo \#\#\# su によるログインテストを実施します。
echo \#\#\# ユーザー名： $USER, 実行コマンド whoami 
echo
echo \# su - $USER -c whoami

su - $USER -c whoami

#コマンド実行結果の取得
RESULT=$?


echo

# 最終出力
if [ $RESULT -eq $SUCCESS ]; then
  echo \#\#\# su ログインテスト成功
  exit $SUCCESS
else
  echo \#\#\# su ログインテスト失敗
  exit $FAILED
fi

exit

