#!/bin/bash -f
#
# rpm を利用したパッケージのインストール
#
# Developed by Yasuhiro Fujitsuki 2010/3
#
# 返り値：
# 0 = 成功
# 1 = 失敗
# 9 = ユーザー作成を実行せず
# 99 = Usage 表示/オプション設定ミス
#

###################################
# 返り値定義 / 条件を変える場合、この部分を変更する
SUCCESS=0
FAILED=1
PASSED=9
USAGE=99
###################################
# 環境変数
# 実行ファイル
LS="/bin/ls"
SED="/bin/sed"
RPM_INSTALL="/bin/rpm -ihv"
RPM_EXIST_CHECK="/bin/rpm -q"
RPM_GET_PKGNAME="/bin/rpm -qp"

###################################

# 引数確認
# 引数が指定数無い場合は usage 表示を行い、終了

if [ $# -eq 0 ]; then
  echo 
  echo usage \> $0 [RPMs]
  echo
  echo "[RPMs] ... インストール対象パッケージファイル"
  echo "           パッケージは複数指定することが可能"
  echo "           ディレクトリにスペースがある場合、下記のように \\ を使用すること"
  echo "           /media/RHEL_5.2\ i386\ DVD/Server/zlib-1.2.3-3.i386.rpm"
  echo
  exit $USAGE
fi


# 変数宣言

declare -i num=1

# rpm ファイルの存在確認
RESULT=$SUCCESS

# インストール時の処理用文字列
FILE_LIST=""

while [ $num -le $# ];
do
  echo
  eval FILE='$'$num 

  if [ -e "$FILE" ]; then
    echo \#\#\# $FILE が見付かりました。
  else
    echo \#\#\# $FILE が見付かりませんでした。
    RESULT=$FAILED
  fi
  num=$num+1

  FILE=`echo "$FILE" | $SED -e "s/\ /\\\\\ /g"`
  FILE_LIST=${FILE_LIST}" "${FILE}
done


# ファイルが見付からない場合は作業中止
if [ $RESULT -eq $FAILED ]; then
    echo 
    echo \#\#\# 作業を中断します。
    echo 
    exit $FAILED
fi

# rpm パッケージのインストール
echo
echo \#\#\# rpm パッケージをインストールします。
echo 
echo \# $RPM_INSTALL "$FILE_LIST"

$RPM_INSTALL "$FILE_LIST"


# インストールされたことを確認

echo
echo \#\#\# パッケージのインストールされたことを確認します。
echo 

num=1

RESULT=$SUCCESS

while [ $num -le $# ];
do
  eval FILE='$'$num
  FILE=`echo "$FILE" | $SED -e "s/\ /\\\\\ /g"`

  echo
  echo \#\#\# $FILE のパッケージ名を取得します。
  echo
  echo \# $RPM_GET_PKGNAME "$FILE"

  $RPM_GET_PKGNAME "$FILE"
  PKG_NAME=`$RPM_GET_PKGNAME "$FILE"`

  echo
  echo \#\#\# パッケージがインストールされていることを確認します。
  echo
  echo \# $RPM_EXIST_CHECK $PKG_NAME

  $RPM_EXIST_CHECK $PKG_NAME

  echo
  echo

  if [ $? -ne 0 ]; then
    RESULT=$FAILED
  fi

  num=num+1

done


if [ $RESULT -eq $FAILED ]; then
  echo
  echo \#\#\# パッケージのインストールに失敗しました。
  echo
else
  echo
  echo \#\#\# $* のインストールを終了します。
  echo
fi

exit $RESULT


