/*
 * Decompiled with CFR 0.152.
 */
package jp.thaniwa.scriptdirector;

import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import jp.thaniwa.scriptdirector.ScriptDirector;
import jp.thaniwa.scriptdirector.ScriptDirectorGui;
import jp.thaniwa.scriptdirector.ScriptDirectorGuiAboutBox;
import jp.thaniwa.scriptdirector.ScriptDirectorInterface;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.TaskMonitor;

public class ScriptDirectorGuiView
extends FrameView
implements ScriptDirectorInterface {
    ScriptDirector scriptDirector;
    Thread scriptDirectorThread;
    private String separator = System.getProperty("line.separator");
    private int stepNumber = 0;
    private int allStepNumber = 0;
    private JButton csvFileButton;
    private JTextField csvFileField;
    private JLabel cvsFileLabel;
    private JPanel executePanel;
    private JProgressBar executeProgressBar;
    private JTextArea executeTextArea;
    private JScrollPane executeTextAreaScrollPane;
    private JLabel executedCommentLabel;
    private JDialog fileCannotFoundDialog;
    private JButton fileCannotFoundDialogCloseButton;
    private JTextField fileCannotFoundFileNameTextField;
    private JTextField fileCannotFoundMessageTextFiled;
    private JButton fileChooseNextButton;
    private JPanel fileChooserPanel;
    private JFileChooser jFileChooser;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JButton logFileButton;
    private JTextField logFileField;
    private JLabel logFileLabel;
    private JPanel mainPanel;
    private JMenuBar menuBar;
    private JButton pauseButton;
    private JLabel percentCommentLabel;
    private JProgressBar progressBar;
    private JButton scenarioFileButton;
    private JTextField scenarioFileField;
    private JLabel scenarioFileLabel;
    private JLabel statusAnimationLabel;
    private JLabel statusMessageLabel;
    private JPanel statusPanel;
    private final Timer messageTimer;
    private final Timer busyIconTimer;
    private final Icon idleIcon;
    private final Icon[] busyIcons = new Icon[15];
    private int busyIconIndex = 0;
    private JDialog aboutBox;

    @Override
    public void println(String string) {
        this.executeTextArea.append(string + this.separator);
        this.executeTextArea.setCaretPosition(this.executeTextArea.getDocument().getLength());
    }

    @Override
    public void updateExecuteInformation(String overview, String command) {
        ++this.stepNumber;
        this.executedCommentLabel.setText(overview);
        this.percentCommentLabel.setText(this.stepNumber + "/" + this.allStepNumber);
        this.executeProgressBar.setValue(100 * this.stepNumber / this.allStepNumber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() {
        this.pauseButton.setText("\u518d\u958b");
        this.pauseButton.setEnabled(true);
        try {
            Thread thread = this.scriptDirectorThread;
            synchronized (thread) {
                this.scriptDirectorThread.wait();
            }
        }
        catch (InterruptedException ie) {
            ie.printStackTrace();
        }
    }

    @Override
    public void exit(int exitNumber) {
    }

    public ScriptDirectorGuiView(SingleFrameApplication app) {
        super(app);
        this.initComponents();
        ResourceMap resourceMap = this.getResourceMap();
        int messageTimeout = resourceMap.getInteger("StatusBar.messageTimeout");
        this.messageTimer = new Timer(messageTimeout, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptDirectorGuiView.this.statusMessageLabel.setText("");
            }
        });
        this.messageTimer.setRepeats(false);
        int busyAnimationRate = resourceMap.getInteger("StatusBar.busyAnimationRate");
        for (int i = 0; i < this.busyIcons.length; ++i) {
            this.busyIcons[i] = resourceMap.getIcon("StatusBar.busyIcons[" + i + "]");
        }
        this.busyIconTimer = new Timer(busyAnimationRate, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ScriptDirectorGuiView.this.busyIconIndex = (ScriptDirectorGuiView.this.busyIconIndex + 1) % ScriptDirectorGuiView.this.busyIcons.length;
                ScriptDirectorGuiView.this.statusAnimationLabel.setIcon(ScriptDirectorGuiView.this.busyIcons[ScriptDirectorGuiView.this.busyIconIndex]);
            }
        });
        this.idleIcon = resourceMap.getIcon("StatusBar.idleIcon");
        this.statusAnimationLabel.setIcon(this.idleIcon);
        this.progressBar.setVisible(false);
        TaskMonitor taskMonitor = new TaskMonitor(this.getApplication().getContext());
        taskMonitor.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("started".equals(propertyName)) {
                    if (!ScriptDirectorGuiView.this.busyIconTimer.isRunning()) {
                        ScriptDirectorGuiView.this.statusAnimationLabel.setIcon(ScriptDirectorGuiView.this.busyIcons[0]);
                        ScriptDirectorGuiView.this.busyIconIndex = 0;
                        ScriptDirectorGuiView.this.busyIconTimer.start();
                    }
                    ScriptDirectorGuiView.this.progressBar.setVisible(true);
                    ScriptDirectorGuiView.this.progressBar.setIndeterminate(true);
                } else if ("done".equals(propertyName)) {
                    ScriptDirectorGuiView.this.busyIconTimer.stop();
                    ScriptDirectorGuiView.this.statusAnimationLabel.setIcon(ScriptDirectorGuiView.this.idleIcon);
                    ScriptDirectorGuiView.this.progressBar.setVisible(false);
                    ScriptDirectorGuiView.this.progressBar.setValue(0);
                } else if ("message".equals(propertyName)) {
                    String text = (String)evt.getNewValue();
                    ScriptDirectorGuiView.this.statusMessageLabel.setText(text == null ? "" : text);
                    ScriptDirectorGuiView.this.messageTimer.restart();
                } else if ("progress".equals(propertyName)) {
                    int value = (Integer)evt.getNewValue();
                    ScriptDirectorGuiView.this.progressBar.setVisible(true);
                    ScriptDirectorGuiView.this.progressBar.setIndeterminate(false);
                    ScriptDirectorGuiView.this.progressBar.setValue(value);
                }
            }
        });
    }

    @Action
    public void showAboutBox() {
        if (this.aboutBox == null) {
            JFrame mainFrame = ScriptDirectorGui.getApplication().getMainFrame();
            this.aboutBox = new ScriptDirectorGuiAboutBox(mainFrame);
            this.aboutBox.setLocationRelativeTo(mainFrame);
        }
        ScriptDirectorGui.getApplication().show(this.aboutBox);
    }

    private void initComponents() {
        this.menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu();
        JMenuItem exitMenuItem = new JMenuItem();
        JMenu helpMenu = new JMenu();
        JMenuItem aboutMenuItem = new JMenuItem();
        this.statusPanel = new JPanel();
        JSeparator statusPanelSeparator = new JSeparator();
        this.statusMessageLabel = new JLabel();
        this.statusAnimationLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.mainPanel = new JPanel();
        this.fileChooserPanel = new JPanel();
        this.scenarioFileField = new JTextField();
        this.logFileField = new JTextField();
        this.csvFileField = new JTextField();
        this.scenarioFileButton = new JButton();
        this.logFileButton = new JButton();
        this.scenarioFileLabel = new JLabel();
        this.logFileLabel = new JLabel();
        this.cvsFileLabel = new JLabel();
        this.fileChooseNextButton = new JButton();
        this.csvFileButton = new JButton();
        this.jFileChooser = new JFileChooser();
        this.fileCannotFoundDialog = new JDialog();
        this.fileCannotFoundDialogCloseButton = new JButton();
        this.fileCannotFoundMessageTextFiled = new JTextField();
        this.fileCannotFoundFileNameTextField = new JTextField();
        this.executePanel = new JPanel();
        this.executeTextAreaScrollPane = new JScrollPane();
        this.executeTextArea = new JTextArea();
        this.executeProgressBar = new JProgressBar();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.pauseButton = new JButton();
        this.executedCommentLabel = new JLabel();
        this.percentCommentLabel = new JLabel();
        this.menuBar.setName("menuBar");
        ResourceMap resourceMap = Application.getInstance(ScriptDirectorGui.class).getContext().getResourceMap(ScriptDirectorGuiView.class);
        fileMenu.setText(resourceMap.getString("fileMenu.text", new Object[0]));
        fileMenu.setName("fileMenu");
        ApplicationActionMap actionMap = Application.getInstance(ScriptDirectorGui.class).getContext().getActionMap(ScriptDirectorGuiView.class, this);
        exitMenuItem.setAction(actionMap.get("quit"));
        exitMenuItem.setName("exitMenuItem");
        fileMenu.add(exitMenuItem);
        this.menuBar.add(fileMenu);
        helpMenu.setText(resourceMap.getString("helpMenu.text", new Object[0]));
        helpMenu.setName("helpMenu");
        aboutMenuItem.setAction(actionMap.get("showAboutBox"));
        aboutMenuItem.setName("aboutMenuItem");
        helpMenu.add(aboutMenuItem);
        this.menuBar.add(helpMenu);
        this.statusPanel.setName("statusPanel");
        statusPanelSeparator.setName("statusPanelSeparator");
        this.statusMessageLabel.setName("statusMessageLabel");
        this.statusAnimationLabel.setHorizontalAlignment(2);
        this.statusAnimationLabel.setName("statusAnimationLabel");
        this.progressBar.setName("progressBar");
        GroupLayout statusPanelLayout = new GroupLayout(this.statusPanel);
        this.statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(statusPanelSeparator, -1, 702, Short.MAX_VALUE).addGroup(statusPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.statusMessageLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 527, Short.MAX_VALUE).addComponent(this.progressBar, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusAnimationLabel).addContainerGap()));
        statusPanelLayout.setVerticalGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(statusPanelLayout.createSequentialGroup().addComponent(statusPanelSeparator, -2, 2, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(statusPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.statusMessageLabel).addComponent(this.statusAnimationLabel).addComponent(this.progressBar, -2, -1, -2)).addGap(3, 3, 3)));
        this.mainPanel.setName("mainPanel");
        this.mainPanel.setPreferredSize(new Dimension(640, 480));
        this.fileChooserPanel.setName("fileChooserPanel");
        this.scenarioFileField.setFont(resourceMap.getFont("scenarioFileField.font"));
        this.scenarioFileField.setText(resourceMap.getString("scenarioFileField.text", new Object[0]));
        this.scenarioFileField.setName("scenarioFileField");
        this.logFileField.setFont(resourceMap.getFont("logFileField.font"));
        this.logFileField.setText(resourceMap.getString("logFileField.text", new Object[0]));
        this.logFileField.setName("logFileField");
        this.csvFileField.setFont(resourceMap.getFont("csvFileField.font"));
        this.csvFileField.setText(resourceMap.getString("csvFileField.text", new Object[0]));
        this.csvFileField.setName("csvFileField");
        this.scenarioFileButton.setAction(actionMap.get("displayScenarioFileChooser"));
        this.scenarioFileButton.setText(resourceMap.getString("scenarioFileButton.text", new Object[0]));
        this.scenarioFileButton.setName("scenarioFileButton");
        this.logFileButton.setAction(actionMap.get("displayLogFileChooser"));
        this.logFileButton.setText(resourceMap.getString("logFileButton.text", new Object[0]));
        this.logFileButton.setName("logFileButton");
        this.scenarioFileLabel.setFont(resourceMap.getFont("scenarioFileLabel.font"));
        this.scenarioFileLabel.setText(resourceMap.getString("scenarioFileLabel.text", new Object[0]));
        this.scenarioFileLabel.setName("scenarioFileLabel");
        this.logFileLabel.setFont(resourceMap.getFont("logFileLabel.font"));
        this.logFileLabel.setText(resourceMap.getString("logFileLabel.text", new Object[0]));
        this.logFileLabel.setName("logFileLabel");
        this.cvsFileLabel.setFont(resourceMap.getFont("cvsFileLabel.font"));
        this.cvsFileLabel.setText(resourceMap.getString("cvsFileLabel.text", new Object[0]));
        this.cvsFileLabel.setName("cvsFileLabel");
        this.fileChooseNextButton.setAction(actionMap.get("pushFileChooserNextButton"));
        this.fileChooseNextButton.setText(resourceMap.getString("fileChooseNextButton.text", new Object[0]));
        this.fileChooseNextButton.setName("fileChooseNextButton");
        this.csvFileButton.setAction(actionMap.get("displayCsvFileChooser"));
        this.csvFileButton.setText(resourceMap.getString("csvFileButton.text", new Object[0]));
        this.csvFileButton.setName("csvFileButton");
        GroupLayout fileChooserPanelLayout = new GroupLayout(this.fileChooserPanel);
        this.fileChooserPanel.setLayout(fileChooserPanelLayout);
        fileChooserPanelLayout.setHorizontalGroup(fileChooserPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fileChooserPanelLayout.createSequentialGroup().addContainerGap().addGroup(fileChooserPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fileChooserPanelLayout.createSequentialGroup().addGroup(fileChooserPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.csvFileField, -1, 403, Short.MAX_VALUE).addComponent(this.logFileField, -1, 403, Short.MAX_VALUE).addComponent(this.scenarioFileField, -1, 403, Short.MAX_VALUE).addComponent(this.scenarioFileLabel, -2, 184, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(fileChooserPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.csvFileButton, -1, -1, Short.MAX_VALUE).addComponent(this.logFileButton, -1, -1, Short.MAX_VALUE).addComponent(this.scenarioFileButton, -1, 112, Short.MAX_VALUE))).addComponent(this.fileChooseNextButton, GroupLayout.Alignment.TRAILING, -2, 116, -2).addComponent(this.logFileLabel, -2, 174, -2).addComponent(this.cvsFileLabel, -2, 182, -2)).addGap(71, 71, 71)));
        fileChooserPanelLayout.setVerticalGroup(fileChooserPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fileChooserPanelLayout.createSequentialGroup().addGap(44, 44, 44).addComponent(this.scenarioFileLabel, -2, 24, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(fileChooserPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.scenarioFileField, -1, 32, Short.MAX_VALUE).addComponent(this.scenarioFileButton, -2, 31, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.logFileLabel, -2, 24, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(fileChooserPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.logFileField, -2, 32, -2).addComponent(this.logFileButton, -2, 32, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cvsFileLabel, -2, 24, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(fileChooserPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.csvFileField).addComponent(this.csvFileButton, -1, 31, Short.MAX_VALUE)).addGap(97, 97, 97).addComponent(this.fileChooseNextButton, -2, 33, -2).addGap(126, 126, 126)));
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 702, Short.MAX_VALUE).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addGap(0, 48, Short.MAX_VALUE).addComponent(this.fileChooserPanel, -2, -1, -2).addGap(0, 49, Short.MAX_VALUE))));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 498, Short.MAX_VALUE).addGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.fileChooserPanel, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE))));
        this.jFileChooser.setName("jFileChooser");
        this.fileCannotFoundDialog.setTitle(resourceMap.getString("fileCannotFoundDialog.title", new Object[0]));
        this.fileCannotFoundDialog.setName("fileCannotFoundDialog");
        this.fileCannotFoundDialogCloseButton.setAction(actionMap.get("performFileCannotFountDialogCloseButton"));
        this.fileCannotFoundDialogCloseButton.setText(resourceMap.getString("fileCannotFoundDialogCloseButton.text", new Object[0]));
        this.fileCannotFoundDialogCloseButton.setName("fileCannotFoundDialogCloseButton");
        this.fileCannotFoundMessageTextFiled.setEditable(false);
        this.fileCannotFoundMessageTextFiled.setFont(resourceMap.getFont("fileCannotFoundMessageTextFiled.font"));
        this.fileCannotFoundMessageTextFiled.setText(resourceMap.getString("fileCannotFoundMessageTextFiled.text", new Object[0]));
        this.fileCannotFoundMessageTextFiled.setBorder(null);
        this.fileCannotFoundMessageTextFiled.setDisabledTextColor(resourceMap.getColor("fileCannotFoundMessageTextFiled.disabledTextColor"));
        this.fileCannotFoundMessageTextFiled.setName("fileCannotFoundMessageTextFiled");
        this.fileCannotFoundFileNameTextField.setEditable(false);
        this.fileCannotFoundFileNameTextField.setFont(resourceMap.getFont("fileCannotFoundFileNameTextField.font"));
        this.fileCannotFoundFileNameTextField.setText(resourceMap.getString("fileCannotFoundFileNameTextField.text", new Object[0]));
        this.fileCannotFoundFileNameTextField.setBorder(null);
        this.fileCannotFoundFileNameTextField.setDisabledTextColor(resourceMap.getColor("fileCannotFoundFileNameTextField.disabledTextColor"));
        this.fileCannotFoundFileNameTextField.setName("fileCannotFoundFileNameTextField");
        GroupLayout fileCannotFoundDialogLayout = new GroupLayout(this.fileCannotFoundDialog.getContentPane());
        this.fileCannotFoundDialog.getContentPane().setLayout(fileCannotFoundDialogLayout);
        fileCannotFoundDialogLayout.setHorizontalGroup(fileCannotFoundDialogLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fileCannotFoundDialogLayout.createSequentialGroup().addGroup(fileCannotFoundDialogLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fileCannotFoundDialogLayout.createSequentialGroup().addGap(150, 150, 150).addComponent(this.fileCannotFoundDialogCloseButton, -2, 90, -2)).addGroup(fileCannotFoundDialogLayout.createSequentialGroup().addGap(49, 49, 49).addGroup(fileCannotFoundDialogLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.fileCannotFoundFileNameTextField).addComponent(this.fileCannotFoundMessageTextFiled, -1, 291, Short.MAX_VALUE)))).addContainerGap(60, Short.MAX_VALUE)));
        fileCannotFoundDialogLayout.setVerticalGroup(fileCannotFoundDialogLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, fileCannotFoundDialogLayout.createSequentialGroup().addGap(32, 32, 32).addComponent(this.fileCannotFoundMessageTextFiled, -2, 35, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fileCannotFoundFileNameTextField, -2, 35, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 40, Short.MAX_VALUE).addComponent(this.fileCannotFoundDialogCloseButton, -2, 34, -2).addGap(21, 21, 21)));
        this.executePanel.setEnabled(false);
        this.executePanel.setName("executePanel");
        this.executePanel.setPreferredSize(new Dimension(640, 480));
        this.executeTextAreaScrollPane.setName("executeTextAreaScrollPane");
        this.executeTextArea.setColumns(20);
        this.executeTextArea.setFont(resourceMap.getFont("executeTextArea.font"));
        this.executeTextArea.setRows(5);
        this.executeTextArea.setName("executeTextArea");
        this.executeTextAreaScrollPane.setViewportView(this.executeTextArea);
        this.executeProgressBar.setFont(resourceMap.getFont("executeProgressBar.font"));
        this.executeProgressBar.setCursor(new Cursor(0));
        this.executeProgressBar.setDoubleBuffered(true);
        this.executeProgressBar.setName("executeProgressBar");
        this.executeProgressBar.setStringPainted(true);
        this.jLabel1.setFont(resourceMap.getFont("jLabel1.font"));
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        this.jLabel2.setFont(resourceMap.getFont("jLabel2.font"));
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        this.pauseButton.setAction(actionMap.get("performPauseButton"));
        this.pauseButton.setFont(resourceMap.getFont("pauseButton.font"));
        this.pauseButton.setText(resourceMap.getString("pauseButton.text", new Object[0]));
        this.pauseButton.setName("pauseButton");
        this.executedCommentLabel.setFont(resourceMap.getFont("executedCommentLabel.font"));
        this.executedCommentLabel.setText(resourceMap.getString("executedCommentLabel.text", new Object[0]));
        this.executedCommentLabel.setName("executedCommentLabel");
        this.percentCommentLabel.setFont(resourceMap.getFont("percentCommentLabel.font"));
        this.percentCommentLabel.setText(resourceMap.getString("percentCommentLabel.text", new Object[0]));
        this.percentCommentLabel.setName("percentCommentLabel");
        GroupLayout executePanelLayout = new GroupLayout(this.executePanel);
        this.executePanel.setLayout(executePanelLayout);
        executePanelLayout.setHorizontalGroup(executePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(executePanelLayout.createSequentialGroup().addGroup(executePanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.LEADING, executePanelLayout.createSequentialGroup().addGap(41, 41, 41).addComponent(this.executeProgressBar, -1, 557, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, executePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(executePanelLayout.createSequentialGroup().addGap(34, 34, 34).addComponent(this.executeTextAreaScrollPane, -2, 564, -2)).addGroup(executePanelLayout.createSequentialGroup().addGap(22, 22, 22).addGroup(executePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(executePanelLayout.createSequentialGroup().addComponent(this.jLabel1, -2, 63, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.executedCommentLabel, -2, 403, -2).addGap(18, 18, 18).addComponent(this.percentCommentLabel, -1, -1, Short.MAX_VALUE)).addGroup(executePanelLayout.createSequentialGroup().addComponent(this.jLabel2, -2, 126, -2).addGap(341, 341, 341).addComponent(this.pauseButton, -2, 109, -2)))))).addContainerGap(42, Short.MAX_VALUE)));
        executePanelLayout.setVerticalGroup(executePanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(executePanelLayout.createSequentialGroup().addGap(47, 47, 47).addGroup(executePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1, -2, 22, -2).addComponent(this.executedCommentLabel, -2, 18, -2).addComponent(this.percentCommentLabel, -2, 18, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.executeProgressBar, -2, 22, -2).addGap(18, 18, 18).addGroup(executePanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2, -2, 27, -2).addComponent(this.pauseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.executeTextAreaScrollPane, -2, 295, -2).addContainerGap(29, Short.MAX_VALUE)));
        this.setComponent(this.mainPanel);
        this.setMenuBar(this.menuBar);
        this.setStatusBar(this.statusPanel);
    }

    private void displayFileChooser(JTextField jTextField) {
        int result = this.jFileChooser.showOpenDialog(this.executePanel);
        if (result == 0) {
            File file = this.jFileChooser.getSelectedFile();
            jTextField.setText(file.getPath());
        }
    }

    @Action
    public void displayScenarioFileChooser() {
        this.displayFileChooser(this.scenarioFileField);
    }

    @Action
    public void displayLogFileChooser() {
        this.displayFileChooser(this.logFileField);
    }

    @Action
    public void displayCsvFileChooser() {
        this.displayFileChooser(this.csvFileField);
    }

    @Action
    public void pushFileChooserNextButton() {
        String scenarioString = this.scenarioFileField.getText();
        String logString = this.logFileField.getText();
        String csvString = this.csvFileField.getText();
        System.out.println(scenarioString.length());
        System.out.println("[" + scenarioString + "]");
        if (scenarioString != null && scenarioString.length() > 0) {
            File scenarioFile = new File(scenarioString);
            if (!scenarioFile.canRead()) {
                this.fileCannotFoundMessageTextFiled.setText("\u30b7\u30ca\u30ea\u30aa\u30d5\u30a1\u30a4\u30eb\u304c\u898b\u3064\u304b\u308a\u307e\u305b\u3093\u3002");
                this.fileCannotFoundFileNameTextField.setText(scenarioString);
                this.fileCannotFoundDialog.pack();
                this.fileCannotFoundDialog.setLocationRelativeTo(this.scenarioFileField);
                this.fileCannotFoundDialog.setModal(true);
                this.fileCannotFoundDialog.setVisible(true);
            } else {
                this.changeToScenarioExecutePanel();
                this.scriptDirector = new ScriptDirector(this, scenarioString, logString, csvString);
                this.allStepNumber = this.scriptDirector.getAllStepNumber();
                this.stepNumber = 0;
            }
        } else {
            this.fileCannotFoundMessageTextFiled.setText("\u30b7\u30ca\u30ea\u30aa\u30d5\u30a1\u30a4\u30eb\u304c\u5b9a\u7fa9\u3055\u308c\u3066\u3044\u307e\u305b\u3093\u3002");
            this.fileCannotFoundDialog.pack();
            this.fileCannotFoundDialog.setLocationRelativeTo(this.scenarioFileField);
            this.fileCannotFoundDialog.setModal(true);
            this.fileCannotFoundDialog.setVisible(true);
        }
    }

    private void changeToScenarioExecutePanel() {
        GroupLayout mainPanelLayout = (GroupLayout)this.mainPanel.getLayout();
        mainPanelLayout.replace(this.fileChooserPanel, this.executePanel);
    }

    @Action
    public void performFileCannotFountDialogCloseButton() {
        this.fileCannotFoundDialog.setVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Action
    public void performPauseButton() {
        if (this.stepNumber == 0) {
            this.pauseButton.setEnabled(false);
            this.scriptDirectorThread = new Thread(this.scriptDirector);
            this.scriptDirectorThread.start();
        } else {
            this.pauseButton.setEnabled(false);
            Thread thread = this.scriptDirectorThread;
            synchronized (thread) {
                this.scriptDirectorThread.notify();
            }
        }
    }
}

