%{
#include"sdg_head.h"
#include"sdg_val.h"
#include"sdg_x.h"
#include"sdg_graphic.h"
#include"sdg_script.h"

static unsigned long line_num = 1; /*Կ*/

void yyerror(char *str);

#define WSTACK_MAX 64
static sdg_widget_t *wstack[WSTACK_MAX]; /*åȤΥå*/
static sdg_u32 wstack_num = 0;
#define widget_push(x) (wstack_num<WSTACK_MAX ? wstack[wstack_num++]=(x) \
		: yyerror("Stack full."))
#define widget_pop (wstack_num>0 ? wstack[--wstack_num] : NULL)
#define widget_remove {wstack_num--;}

/*§黻*/
sdg_val_t val_op(sdg_val_t v1,char c,sdg_val_t v2);

void val_print(sdg_val_t v);
sdg_val_t window_create(sdg_val_t title,sdg_val_t x,sdg_val_t y,
	sdg_val_t width,sdg_val_t height);

void set_color(sdg_val_t r,sdg_val_t g,sdg_val_t b);
void draw_point(sdg_val_t x,sdg_val_t y);
void draw_line(sdg_val_t x1,sdg_val_t y1,sdg_val_t x2,sdg_val_t y2);
void draw_rect(sdg_val_t x,sdg_val_t y,sdg_val_t width,sdg_val_t height);
void fill_rect(sdg_val_t x,sdg_val_t y,sdg_val_t width,sdg_val_t height);
%}

%union{
	sdg_val_t val;
	char name[256];
}

%token NUMBER ENTER NAME STRING
%token PRINT_TAG WINDOW_TAG
%token COLOR_TAG DRAW_POINT DRAW_LINE DRAW_RECT FILL_RECT

%right '='
%left '+' '-'
%left '*' '/'
%left NEG

%type <val>STRING
%type <val>NUMBER
%type <val>val_expr
%type <val>string
%type <val>number
%type <name>NAME

%%

file: /* null */
	| file line
	;
	
line: ENTER {line_num++;}
	| expression ENTER {line_num++;}
	;

expressions: /* null */
	| expressions line
	;

expression: val_expr {;}
	| tag_expr {;}
	;

val_expr: NUMBER {$$ = $1;}
	| val_expr '+' val_expr {$$ = val_op($1,'+',$3);}
	| val_expr '-' val_expr {$$ = val_op($1,'-',$3);}
	| val_expr '*' val_expr {$$ = val_op($1,'*',$3);}
	| val_expr '/' val_expr {$$ = val_op($1,'/',$3);}
	| '-' val_expr %prec NEG {
		$$ = val_op(sdg_val_create(NUM,(long)-1),'*',$2);}
	| '(' val_expr ')' {$$ = $2;}
	| NAME '=' val_expr {if(sdg_val_insert($1,$3) == 0)
		$$ = sdg_val_create(NO_DATA,0); else $$ = $3;}
	| '$' NAME {$$ = sdg_val_search($2);}
	| STRING {$$ = $1;}
	;

tag_expr: PRINT_TAG val_expr {val_print($2);}
	| window_tag '{' expressions '}' { widget_remove; }
	| COLOR_TAG number ',' number ',' number {
		set_color($2,$4,$6);}
	| DRAW_POINT number ',' number { draw_point($2,$4); }
	| DRAW_LINE number ',' number ',' number ',' number {
		draw_line($2,$4,$6,$8);}
	| DRAW_RECT number ',' number ',' number ',' number {
		draw_rect($2,$4,$6,$8);}
	| FILL_RECT number ',' number ',' number ',' number {
		fill_rect($2,$4,$6,$8);}
	;

window_tag: WINDOW_TAG NAME ',' string ',' number ',' number ',' number ',' number {
		sdg_val_t v;
		v = window_create($4,$6,$8,$10,$12);
		if(sdg_val_insert($2,v) == 0) yyerror("Can't create window");
	}
	;

string: val_expr {if($1.type == STR) $$ = $1; else yyerror("Invalid string.");}
	;

number: val_expr {if($1.type == NUM) $$ = $1; else yyerror("Invalid number.");}
	;

%%

void yyerror(char *str)
{
	script_flag = 0;
	fprintf(stderr,"error:%ld:%s\n",line_num,str);
	return;
}

/*v1 c v2 .cˤ[+ - * /]Ϥ*/
sdg_val_t val_op(sdg_val_t v1,char c,sdg_val_t v2)
{
	sdg_val_t v;
	if(v1.type == NUM && v2.type == NUM){
		v.type = NUM;
		switch(c){
			case '+':
				v.val.num = v1.val.num + v2.val.num;
				break;
			case '-':
				v.val.num = v1.val.num - v2.val.num;
				break;
			case '*':
				v.val.num = v1.val.num * v2.val.num;
				break;
			case '/':
				if(v2.val.num == 0){
					yyerror("zero divop.");
					v.type = NO_DATA;
					v.val.num = 0;
					break;
				}
				v.val.num = v1.val.num / v2.val.num;
				break;
			default:
				yyerror("invalid operation.");
				v.type = NO_DATA;
				v.val.num = 0;
				break;
		}
	}
	return v;
}

/*ѿͤɽ*/
void val_print(sdg_val_t v)
{
	if(v.type == NUM)
		printf("$%ld = %ld\n",line_num,v.val.num);
	else if(v.type == STR)
		printf("$%ld = \"%s\"\n",line_num,v.val.str);
	else
		printf("$%ld = null\n",line_num);
	return;
}

/*ɥκ(ƥץȤѿ)*/
sdg_val_t window_create(sdg_val_t title,sdg_val_t x,sdg_val_t y,
	sdg_val_t width,sdg_val_t height)
{
	sdg_widget_t *w;
	
	w = sdg_window_create(title.val.str,x.val.num,y.val.num,
		width.val.num,height.val.num);
	widget_push(w);
	return sdg_val_create(WID,(long)w);
}

/*Υå*/
void set_color(sdg_val_t r,sdg_val_t g,sdg_val_t b)
{
	sdg_color_t c;
	
	sdg_color_get(&c,r.val.num,g.val.num,b.val.num);
	sdg_pen_foreground(global_pen,&c);
	return;
}

/**/
void draw_point(sdg_val_t x,sdg_val_t y)
{
	sdg_widget_t *w;
	
	if((w=widget_pop)==NULL)
		return;
	
	sdg_draw_point(w,global_pen,x.val.num,y.val.num);
	widget_push(w);
	return;
}

/**/
void draw_line(sdg_val_t x1,sdg_val_t y1,sdg_val_t x2,sdg_val_t y2)
{
	sdg_widget_t *w;
	
	if((w=widget_pop)==NULL)
		return;
	
	sdg_draw_line(w,global_pen,x1.val.num,y1.val.num,x2.val.num,y2.val.num);
	widget_push(w);
	return;
}

/*ͳѤ*/
void draw_rect(sdg_val_t x,sdg_val_t y,sdg_val_t width,sdg_val_t height)
{
	sdg_widget_t *w;
	
	if((w=widget_pop)==NULL)
		return;
	
	sdg_draw_rect(w,global_pen,x.val.num,y.val.num,
		width.val.num,height.val.num);
	widget_push(w);
	return;
}

/*ɤĤ֤ͳ*/
void fill_rect(sdg_val_t x,sdg_val_t y,sdg_val_t width,sdg_val_t height)
{
	sdg_widget_t *w;
	
	if((w=widget_pop)==NULL)
		return;
	
	sdg_fill_rect(w,global_pen,x.val.num,y.val.num,
		width.val.num,height.val.num);
	widget_push(w);
	return;
}

