#ifndef _SDG_WIDGET_H_
#define _SDG_WIDGET_H_

#include"sdg_head.h"
#include"sdg_error.h"
#include"sdg_libc.h"

/**/

typedef enum{
	NOT_SET,
	WINDOW,
	SUBWINDOW,
}sdg_type_t;

/*åȶ̥ǡ*/
typedef struct{
	sdg_type_t type; /*åȤμ*/
	Window window;
	sdg_u16 width,height;
	sdg_u32 event_mask; /*٥ȥޥ*/
}sdg_union_t;

/*ɥ*/
typedef struct{
	sdg_union_t data;
	char *name; /*ȥСʸ*/
}sdg_window_t;

/*ҥɥ*/
typedef struct{
	sdg_union_t data;
	sdg_window_t *parent; /*ƥɥ*/
}sdg_subwindow_t;

/*ɤʥåȤǤ⤳Ȥ*/
typedef union{
	sdg_union_t data;
	sdg_window_t window;
	sdg_subwindow_t subwindow;
}sdg_widget_t;

typedef struct{
	sdg_u8 r,g,b;
	sdg_u32 pixel;
}sdg_color_t;

#define WIDGET_NUM 256
/*åȤΥꥹ*/
extern sdg_widget_t *widget_list[WIDGET_NUM];

/*åȤΥѡĴؿ*/
void sdg_widget_init(void);
sdg_widget_t *sdg_window_create(char *name,sdg_u16 x,sdg_u16 y,
	sdg_u16 width,sdg_u16 height);
void sdg_window_destroy(sdg_widget_t* window);
sdg_widget_t *sdg_subwindow_create(sdg_widget_t *parent,sdg_u16 x,
	sdg_u16 y,sdg_u16 width,sdg_u16 height);
void sdg_subwindow_destroy(sdg_widget_t *subwindow);
void sdg_widget_map(sdg_widget_t* widget);
void sdg_widget_unmap(sdg_widget_t* widget);
void sdg_color_get(sdg_color_t *color,sdg_u8 r,sdg_u8 g,sdg_u8 b);
void sdg_widget_quit(void);

#endif