#include"sdg_x.h"

sdg_color_t back_ground,border_color;
Colormap colormap;

static void insert_widget(sdg_widget_t *widget);
static void remove_widget(sdg_widget_t *widget);

/*åȤΥѡĴؿ*/

/**/
void sdg_widget_init(void)
{
	display = XOpenDisplay(NULL);
	if(display == NULL)
		sdg_error_set(DISPLAY_ERROR,"Can't open display.");
	
	root = DefaultRootWindow(display);
	colormap = DefaultColormap(display,0);
	memset(widget_list,(int)NULL,sizeof(sdg_widget_t *)*WIDGET_NUM);
	sdg_color_get(&back_ground,255,255,255);
	sdg_color_get(&border_color,0,0,0);
	return;
}

/*ɥκ*/
sdg_widget_t *sdg_window_create(char *name,sdg_u16 x,sdg_u16 y,
	sdg_u16 width,sdg_u16 height)
{
	sdg_window_t *window; 
	
	/*ΰ*/
	window = sdg_malloc(sizeof(sdg_window_t));
	/*ɥκ*/
	window->data.window = XCreateSimpleWindow(display,root,x,y,
		width,height,5,border_color.pixel,back_ground.pixel);
	window->data.width = width;
	window->data.height = height;
	/*ȥ*/
	window->name = sdg_strdup(name);
	XStoreName(display,window->data.window,name);
	/*Ͽ*/
	insert_widget((sdg_widget_t *)window);
	/*ɽ*/
	sdg_widget_map((sdg_widget_t *)window);
	/*typeꤹ*/
	window->data.type = WINDOW;
	
	return (sdg_widget_t *)window;
}

/*ɥ*/
void sdg_window_destroy(sdg_widget_t* window)
{
	XDestroyWindow(display,window->data.window);
	remove_widget((sdg_widget_t *)window);
	sdg_free(window->window.name);
	sdg_free(window);
	return;	
}

/*ҥɥκ*/
sdg_widget_t *sdg_subwindow_create(sdg_widget_t *parent,sdg_u16 x,
	sdg_u16 y,sdg_u16 width,sdg_u16 height)
{
	sdg_subwindow_t *subwindow;
	
	/*ΰ*/
	subwindow = sdg_malloc(sizeof(sdg_subwindow_t));
	/*ɥκ(sdg_window_createȾ㤦)*/
	subwindow->data.window = XCreateSimpleWindow(display,
		parent->data.window,x,y,width,height,5,border_color.pixel,
		back_ground.pixel);
	subwindow->data.width = width;
	subwindow->data.height = height;
	
	insert_widget((sdg_widget_t *)subwindow);
	sdg_widget_map((sdg_widget_t *)subwindow);
	subwindow->data.type = SUBWINDOW;
	
	return (sdg_widget_t *)subwindow;
}

/*ҥɥ*/
void sdg_subwindow_destroy(sdg_widget_t *subwindow)
{
	XDestroyWindow(display,subwindow->data.window);
	remove_widget((sdg_widget_t *)subwindow);
	sdg_free(subwindow);
	return;
}

/*åȤɽ*/
void sdg_widget_map(sdg_widget_t* widget)
{
	XEvent ev;
	
	XSelectInput(display,widget->data.window,ExposureMask);
	XMapWindow(display,widget->data.window);
	XMapSubwindows(display,widget->data.window);
	do{
		XNextEvent(display,&ev);
	}while(ev.type != Expose);
	return;
}

/*åȤɽˤ*/
void sdg_widget_unmap(sdg_widget_t* widget)
{
	XUnmapSubwindows(display,widget->data.window);
	XUnmapWindow(display,widget->data.window);
	return;
}

/**/
void sdg_color_get(sdg_color_t *color,sdg_u8 r,sdg_u8 g,sdg_u8 b)
{
	XColor xcolor;

	color->r = r;
	color->g = g;
	color->b = b;
	xcolor.red = r*256;
	xcolor.green = g*256;
	xcolor.blue = b*256;
	xcolor.flags = DoRed | DoGreen | DoBlue;
	XAllocColor(display,colormap,&xcolor);
	color->pixel = xcolor.pixel;
	return;
}

/*λ*/
void sdg_widget_quit(void)
{
	XCloseDisplay(display);
	return;
}

sdg_widget_t *widget_list[WIDGET_NUM];
static sdg_u16 widget_num = 0;
/*åȤϿ*/
static void insert_widget(sdg_widget_t *widget)
{
	if(widget_num >= WIDGET_NUM)
		sdg_error_set(WIDGET_MAX_ERROR,
			"Too many widget.");
	widget_list[widget_num++] = widget;
	return;
}

/*åȤꥹȤ*/
static void remove_widget(sdg_widget_t *widget)
{
	int i;
	
	for(i=0; widget_list[i] != widget; i++)
		if(i >= (WIDGET_NUM-1)){
			sdg_warning_set("Widget not found (%p).",widget);
			return;
		}
	widget_list[i++] = NULL;
	for(; i<WIDGET_NUM; i++){
		widget_list[i-1] = widget_list[i];
		widget_list[i] = NULL;
	}
	return;
}