#include"sdg_val.h"

/*ѿΥǡѿ̾*/
struct node{
	char *name;
	sdg_val_t val;
};

#define NODE_MAX 1024
static struct node node_list[NODE_MAX]; /*ѿꥹ*/
static unsigned int node_num = 0; /*ѿο*/

/*ѿϿѴؿ*/

/*valꥹȤϿ롣1,Ԥ0֤*/
int sdg_val_insert(char *name,sdg_val_t val)
{
	char *s;
	
	if(!(node_num < NODE_MAX)){ /*ѿ¿*/
		fprintf(stderr,"Too many variable.\n");
		return 0;
	}
	if((s=strdup(name)) == NULL){
		fprintf(stderr,"Can't strdup(\"%s\").\n",name);
		return 0;
	}
	/*Ͽ*/
	node_list[node_num].name = s;
	node_list[node_num].val = val;
	node_num++;
	return 1;
}

/*nameѿ̾ѿꥹȤ*/
void sdg_val_remove(char *name)
{
	int i;
	
	for(i=0; i<node_num; i++)
		if(strcmp(node_list[i].name,name) == 0){ /*ȯ*/
			free(node_list[i].name);
			/*ѿǺ򤦤*/
			node_list[i] = node_list[node_num-1]; 
			node_num--;
			return;
		}
	return; /*ȯǤʤä*/
}

/*nameѿ̾ѿõ*/
sdg_val_t sdg_val_search(char *name)
{
	int i;
	sdg_val_t null_val; /*ȯǤʤä֤*/
	
	null_val.type = NO_DATA;
	null_val.val.num = 0;
	for(i=0; i<node_num; i++)
		if(strcmp(node_list[i].name,name) == 0)
			return node_list[i].val;
	return null_val;
}

/*ǡκ*/
sdg_val_t sdg_val_create(int type,long num)
{
	sdg_val_t v;
	
	v.type = type;
	switch(type){
		case NUM:
			v.val.num = num;
			break;
		case STR:
			v.val.str = sdg_strdup((char *)num);
			break;
		case WID:
			if((void *)num == NULL)
				v.type = NO_DATA;
			v.val.wid = (sdg_widget_t *)num;
			break;
		default:
			v.type = NO_DATA;
			break;
	}
	return v;
}