#include"sdg_error.h"
#include"sdg_libc.h"

/*ʬǤĥΰ*/
#define SDG_MALLOC_SIZE 1024
typedef struct _header{
	size_t size;
	void *data;
}Header;

static void* malloc_memory[SDG_MALLOC_SIZE];
static const Header *top = &malloc_memory[0];
static const Header *end = &malloc_memory[SDG_MALLOC_SIZE-1];

/*malloc_memorysizeʬΥ꡼ݡ
­ʤСmallocƤ*/
void *sdg_malloc(size_t size)
{
	Header *p;

	for(p=top; p->size != 0; p=p->data+size);
	if((void*)end-(&p->data) < 0){ /*ʬΰǤ­ʤ*/
		void *ptr;
		if((ptr=malloc(size)) == NULL)
			sdg_error_set(SDG_MALLOC_ERROR,
				"sdg_malloc can't malloc %d size.",
				size);
		return ptr;
	}
	p->size = size;
	return (void *)&p->data;
}

/*
void *sdg_calloc(size_t size,size_t num);
void *sdg_realloc(void *ptr,size_t size);
*/

/*sdg_*allocǳƤ*/
void sdg_free(void *ptr)
{
	Header *h;
	
	if(!(ptr<top && ptr>end)){
		free(ptr);
		return;
	}
	h = ptr - sizeof(Header);
	h->size = 0;
	return;
}