%{
#include"sdg_head.h"
#include<stdlib.h>
#include<ctype.h>
#include"sdg_val.h"
#include"sdg_yacc.tab.h"

void yyerror(char *); /*顼*/

static char str[256];
static int str_len = 0;

static void getword(char *src,char *dst,size_t s);
%}

%option noyywrap

%x STRI

%%

[ \t]		/*  */
"\n"		{return ENTER;}

print		{return PRINT_TAG;}
window		{return WINDOW_TAG;}
color		{return COLOR_TAG;}
draw_point	{return DRAW_POINT;}
draw_line	{return DRAW_LINE;}
draw_rect	{return DRAW_RECT;}
fill_rect	{return FILL_RECT;}

[0-9]+		{yylval.val.val.num = atol(yytext);
		yylval.val.type = NUM; return NUMBER;}
[A-Za-z_]+|[A-Za-z_][A-Za-z_0-9]+ {
		getword(yytext,yylval.name,sizeof yylval.name); return NAME;}
\"		{str_len = 0; BEGIN(STRI);}
<STRI>[\t\n]	/*  */
<STRI>\"	{str[str_len] = '\0'; 
		yylval.val = sdg_val_create(STR,(long)str);
		BEGIN(INITIAL); return STRING;}
<STRI>.		{if(str_len >= (sizeof str)-1){ /*Сե*/
			yyerror("String overflow.");
			BEGIN(INITIAL);
		}
		str[str_len++] = yytext[0];}
.		{return yytext[0];}

%%

/*̾ȴ*/
static void getword(char *src,char *dst,size_t s)
{
	char *end = dst + s;

	while(isspace(*src)) src++;
	while((isalnum(*src) || *src == '_') && dst < end)
		*dst++ = *src++;
	*dst = '\0';
	return;
}