#include"sdg_event.h"

/*٥ȴؿ*/

/*windowֹΥåȤõ*/
static sdg_widget_t *search_widget(Window window)
{
	int i;
	
	for(i=0; i<WIDGET_NUM; i++)
		if(widget_list[i]->data.window == window) /*ȯ*/
			return widget_list[i];
	return NULL; /*դʤä*/
}

/*XEventsdg_event_tѴ*/
static void xevent_to_sdg_event(XEvent *xe,sdg_event_t *sdge)
{
	sdg_widget_t *widget;
	
	widget = search_widget(xe->xany.window); /*åȤõ*/
	if(widget == NULL){
		sdge->type = NO_EVENT;
		return;
	}
	sdge->any.target = widget;
	switch(xe->type){
		case ButtonPress: /*ܥϢ*/
		case ButtonRelease:
			if(xe->type == ButtonPress)
				sdge->type = BUTTON_PRESS;
			else
				sdge->type = BUTTON_RELEASE;
			sdge->button.x = xe->xbutton.x;
			sdge->button.y = xe->xbutton.y;
			sdge->button.button = xe->xbutton.button;
			break;
			
		case KeyPress: /*ܡɴϢ*/
		case KeyRelease:
			if(xe->type == KeyPress)
				sdge->type = KEY_PRESS;
			else
				sdge->type = KEY_RELEASE;
			sdge->key.mask = xe->xkey.state;
			sdge->key.keycode = XLookupKeysym(&xe->xkey, 0);
			break;
			
		case Expose: /*Ϣ*/
			sdge->type = EXPOSE;
			sdge->expose.x = xe->xexpose.x;
			sdge->expose.y = xe->xexpose.y;
			sdge->expose.width = xe->xexpose.width;
			sdge->expose.height = xe->xexpose.height;
			break;
			
		default: /*¾*/
			sdg_warning_set("Undefined event(%d).",xe->type);
			break;
	}
	return;
}

/*٥Ȥꤹ*/
void sdg_event_set(sdg_widget_t *widget,sdg_u32 mask)
{
	XSelectInput(display,widget->data.window,mask);
	widget->data.event_mask |= mask;
	return;
}

/*٥ȤޤԤ*/
void sdg_event_wait(sdg_event_t *event)
{
	XEvent e;
	
	XNextEvent(display,&e);
	xevent_to_sdg_event(&e,event);
	return;
}

/*widgetƤΥ٥ȤƤСTRUE,Ƥʤä顢FALSE֤*/
sdg_boolean_t sdg_event_get(sdg_widget_t *widget,sdg_event_t *event)
{
	XEvent e;
	Bool flag;
	
	flag = XCheckWindowEvent(display,widget->data.window,
		widget->data.event_mask,&e);
	if(flag == True)
		xevent_to_sdg_event(&e,event);
	else
		return FALSE;
	return TRUE;
}