/* * * Sdg_Yacc.y * * *
 * ʸϴؿ
 * * * * * * * * * * */
%{

%}

%name Sdg_Parser
%define LSP_NEEDED
%define ERROR_BODY =0
%define LEX_BODY =0
%define MEMBERS void SetVarList(Sdg_List *v);
%define STYPE __Sdg_Variable

%header{
#include"Sdg_Error.h"
#include"Sdg_Script.h"
#include"Sdg_Variable.h"
#include<iostream>
#include <string>
using namespace std;

static Sdg_List *var_list;

struct __Sdg_Variable{
	Sdg_Variable var;
};

#undef YY_DECL
#define YY_DECL int Sdg_Lexer::yylex(YY_Sdg_Parser_STYPE *val)

#ifndef FLEXFIX
#define FLEXFIX YY_Sdg_Parser_STYPE *val
#define FLEXFIX2 val
#endif
%}

%token <var>IDENTIFY
%token <var>DATA
%token EOL ARROW
%right '='
%left '+' '-'
%left '*' '/'
%right UMINUS '$'
%type <var>expr
%start input

%%

input: /*null*/
	| input line {}
	;

line:	expr EOL { cout << "result=" << $1 << endl;}
	| EOL
	;

expr:	expr '+' expr { $$ = $1 + $3;}
	| expr '-' expr { $$ = $1 - $3;}
	| expr '*' expr { $$ = $1 * $3;}
	| expr '/' expr { $$ = $1 / $3;}
	| '(' expr ')' { $$ = $2;}
	| DATA { $$ = $1;}
	| '-' expr %prec UMINUS {$$ = $2 * (-1);}
	| IDENTIFY { Sdg_Variable *v = var_list->Search($1.String());
		if(v == NULL)yyerror("Not found");
		else $$ = *v; }
	| IDENTIFY '=' expr {var_list->Add($1.String(),$3); $$ = $3;}
	;
%%

void Sdg_Parser::SetVarList(Sdg_List *v)
{
	var_list = v;
}
