/* * * Sdg_Lex.l * * *
 * ϴؿ
 * * * * * * * * * * */
%{
#ifndef FLEXFIX
#define FLEXFIX YY_Sdg_Parser_STYPE *val
#define FLEXFIX2 val
#endif
#include"Sdg_Lex.h"
#include<cctype>

using namespace std;

Sdg_String GetVarName(const char *str);
int yywrap();
static char str_data[512];
static unsigned int str_num;
%}
%option c++
%option yyclass="Sdg_Lexer"
%option yylineno

space [ \t]+
digit [0-9]
integer [1-9]{digit}*
letter [_A-Za-z]
let_and_dig {letter}|{digit}
identify {letter}{let_and_dig}*

%x COMMENT
%x STRING_MODE

%%

{space}		{/*null*/}

"#"		{//
		BEGIN(COMMENT);
		}
<COMMENT>[^\n]*
<COMMENT>\n	{BEGIN(INITIAL);}

"\""		{//ʸ
		str_num = 0;
		BEGIN(STRING_MODE);
		}
<STRING_MODE>"\""	{str_data[str_num] = '\0';
			val->var = Sdg_String(str_data);
			BEGIN(INITIAL);
			return Sdg_Parser::DATA;
			}
<STRING_MODE>"\\".	{if(str_num < sizeof str_data) str_data[str_num++] = *(yytext+1);
			else LexerError("String overflow.");
			}
<STRING_MODE>.	{if(str_num < sizeof str_data) str_data[str_num++] = *yytext;
			else LexerError("String overflow.");
			}

{integer}	{//
		val->var = atol(yytext);
		return Sdg_Parser::DATA;
		}
{integer}"."{digit}+ { //¿
			 val->var = atof(yytext);
			return Sdg_Parser::DATA;
		}

{identify}	{//ѿ̾
			val->var = GetVarName(yytext);
			return Sdg_Parser::IDENTIFY;
		}

"\n"		{return Sdg_Parser::EOL;}
"->"		{return Sdg_Parser::ARROW;}
<<EOF>>		{yyterminate();}
.		{return yytext[0];}


%%

//ѿ̾ȴ
Sdg_String GetVarName(const char *str)
{
	char s[256];
	int i = 0;

	while(isalnum(str[i]) || str[i] == '_'){
		s[i] = str[i];
		if(++i >= sizeof s) break;
	}
	s[i] = '\0';
	return Sdg_String(s);
}


int yywrap()
{
        return(1);
}
