/* * * Sdg_Error.cpp * * *
 * 顼饹μ
 * * * * * * * * * * * * */

#include"Sdg_Error.h"
#include<cstdio>
#include<cstdarg>
#include<cstdlib>

using namespace std;

/*----- ɽؿ -----*/
/* * * 顼 * * */
void Sdg_Error(const char *msg,...)
{
	va_list ap;

	va_start(ap,msg);
	Sdg_Error(msg,ap);
	va_end(ap);
}

void Sdg_Error(const char *msg,va_list ap)
{
	fprintf(stderr,"ERROR:");
	vfprintf(stderr,msg,ap);
	putc('\n',stderr);
	exit(1);
}

/* * * ٹ * * */
void Sdg_Warning(const char *msg,...)
{
	va_list ap;

	va_start(ap,msg);
	Sdg_Warning(msg,ap);
	va_end(ap);
}

void Sdg_Warning(const char *msg,va_list ap)
{
	fprintf(stderr,"Warning:");
	vfprintf(stderr,msg,ap);
	putc('\n',stderr);
}

/* * * ν * * */
static FILE *_debug_out = stdout;
FILE *Sdg_Debug_Set(FILE *debug_out)
{
	FILE *fp = _debug_out;
	_debug_out = debug_out; 
	return fp;
}

/* * * ν * * */
void Sdg_Debug(const char *msg,...)
{
	va_list ap;

	va_start(ap,msg);
	Sdg_Debug(msg,ap);
	va_end(ap);
}

void Sdg_Debug(const char *msg,va_list ap)
{
	fprintf(_debug_out,"DEBUG:");
	vfprintf(_debug_out,msg,ap);
	putc('\n',_debug_out);
}

#include"Sdg_Base.h"

/*----- Sdg_Base -----*/
Sdg_Base::Sdg_Base(const string &class_name):_class_name(class_name)
{
}
Sdg_Base::~Sdg_Base()
{
}

