/* * * Sdg_Script.cpp * * *
 * ץȤν
 * * * * * * * * * * * * */

#include"Sdg_Script.h"
#include<cstring>
#include<fstream>
#include"FlexLexer.h"
#include"Sdg_Lex.h"
#include"Sdg_Yacc.h"

using namespace std;

/* * * ѥ * * */
class Sdg_Compiler : public Sdg_Parser, public Sdg_Error{
 public:
	Sdg_Compiler(istream &input): lexer(input){ SetVarList(&var_list); yyparse(); }
	virtual ~Sdg_Compiler(){ }

	void yyerror(char *msg){ Error("%d:%s\n",lexer.lineno(),msg); }
	int yylex(){ return lexer.yylex(&yylval); }
	//ѿ
	void Add(const Sdg_String &s,Sdg_Variable &v){ var_list.Add(s,v); }
	Sdg_Variable *Search(const Sdg_String &s){ return var_list.Search(s); }
 private:
	Sdg_List var_list; 
 	Sdg_Lexer lexer;
};
 
/* * * ץȽ饹 * * */
/*-----  -----*/
Sdg_Script::Sdg_Script(const char *file_name)
{
	/*եɤ߹*/
	ifstream i(file_name);
	/*ץȤɤ߹*/
	compiler = new Sdg_Compiler(i);
}

/*-----  -----*/
Sdg_Script::~Sdg_Script()
{
	delete compiler;
}

#include"Sdg_Variable.h"
/* * * ѿμ * * */
/*-----  -----*/
Sdg_Variable &Sdg_Variable::operator=(const Sdg_Variable &data)
{
	if(this == &data)return *this;
	if(Type() == STRING) delete _str;
	type = data.Type();
	switch(type){
	case NO_DATA:
		break;
	case NUMBER:
		_num = data.Number();
		break;
	case STRING:
		_str = new Sdg_String(data.String());
		break;
	default:
		Error("Invalid variable is used.");
		break;
	}
	return *this;
}

/*----- ­ -----*/
Sdg_Variable operator+(const Sdg_Variable &v1,const Sdg_Variable &v2)
{
	//ξΥǡз׻
	if(v1.Type() != v2.Type()){
		//v1.Error("Invalid operation +.");
		return Sdg_Variable();
	}else{
		switch(v1.Type()){
		case NUMBER:
			return Sdg_Variable(v1.Number() + v2.Number());
		case STRING:
			return Sdg_Variable(v1.String() + v2.String());
		default:
			//v1.Error("Invalid variables operation +.");
			return Sdg_Variable();
		}
	}
	return Sdg_Variable();
}

/*----- η׻ -----*/
/* opˤäƷ׻Ѥ*/
static Sdg_Number NumberOperator(const Sdg_Variable &v1,const Sdg_Variable &v2,char op)
{
	if(v1.Type() != v2.Type()){
		//v1.Error("Invalid operation %c.",op);
		return 0;
	}else if(v1.Type() != NUMBER){
		//v1.Error("Operation %c is Number only.",op);
		return 0;
	}
	switch(op){
	case '-':
		return v1.Number() - v2.Number();
	case '*':
		return v1.Number() * v2.Number();
	case '/':
		return v1.Number() / v2.Number();
	default: //ꤨʤ
		return 0;
	}
}

/*-----  -----*/
Sdg_Variable operator-(const Sdg_Variable &v1,const Sdg_Variable &v2)
{
	return Sdg_Variable(NumberOperator(v1,v2,'-'));
}

/*-----  -----*/
Sdg_Variable operator*(const Sdg_Variable &v1,const Sdg_Variable &v2)
{
	return Sdg_Variable(NumberOperator(v1,v2,'*'));
}

/*----- 任 -----*/
Sdg_Variable operator/(const Sdg_Variable &v1,const Sdg_Variable &v2)
{
	return Sdg_Variable(NumberOperator(v1,v2,'/'));
}

/*----- ɽ -----*/
std::ostream &operator<<(std::ostream &os,const Sdg_Variable &v)
{
	switch(v.Type()){
	case NO_DATA:
		os << "<NULL>";
		break;
	case NUMBER:
		os << v.Number();
		break;
	case STRING:
		os << v.String();
		break;
	default:
		//v.Error("Invalid variable output.");
		os << "<ERR>";
		break;
	}
	return os;
}

/* * * ѿ * * */
/*----- Ƥѿξõ ------*/
static void DeleteAll(_Sdg_Tree *t)
{
	if(t == NULL) return;
	DeleteAll(t->left);
	DeleteAll(t->right);
	//õ
	delete t;
	return;
}

Sdg_List::~Sdg_List()
{
	DeleteAll(root);
}

/*------ ꥹȤ˿ɲä ------*/
void Sdg_List::Add(const Sdg_String &v_name,Sdg_Variable &v)
{
	_Sdg_Tree **t = &root;
	_Sdg_Tree *new_node;

	while(*t != NULL){
		//Ʊ̾ä񤭤
		if(v_name == (*t)->name){
			(*t)->var = v;
			return;
		}else if(v_name < (*t)->name) t = &(*t)->left;
		else t = &(*t)->right;
	}

	new_node = new _Sdg_Tree(v_name,v);
	*t = new_node;
	return;
}

/*------ ̾Ǹ(դʤNULL) -----*/
Sdg_Variable *Sdg_List::Search(const Sdg_String &v_name)
{
	_Sdg_Tree *t;

	t = root;
	while(t != NULL){
		//դä
		if(t->name == v_name)
			return &t->var;
		//ޤõ
		else if(t->name < v_name) t = t->left;
		else t = t->right;
	}
	//դʤä
	return NULL;
}
