/* * * Sdg_Error.cpp * * *
 * 顼饹μ
 * * * * * * * * * * * * */

#include"Sdg_Error.h"
#include<cstdio>
#include<cstdarg>

using namespace std;

static FILE *global_log = stderr;

/*-----  -----*/
Sdg_Error::Sdg_Error():status(NO_ERROR),log_file(global_log)
{
}

Sdg_Error::Sdg_Error(const char *logfile):status(NO_ERROR)
{
	log_file = fopen(logfile,"w");
	if(log_file == NULL){
		Error("Can't open logfile \"%s\".",global_log);
		log_file = global_log;
		return;
	}

	Log("Script de GUI Log start");
}

/*----- եؽ -----*/
inline void PrintMessage(const char *head,FILE *fp,
		const char *msg,va_list ap)
{
	fprintf(fp,head);
	vfprintf(fp,msg,ap);
	putc('\n',fp);
}

/*----- 顼ν -----*/
void Sdg_Error::Error(const char *msg,...)
{
	va_list ap;

	va_start(ap,msg);
	PrintMessage("Script de GUI Error:\n\t",global_log,msg,ap);
	va_end(ap);
}

/*----- ٹν -----*/
void Sdg_Error::Warning(const char *msg,...)
{
	va_list ap;

	va_start(ap,msg);
	PrintMessage("Script de GUI Warning:\n\t",global_log,msg,ap);
	va_end(ap);
}

/*----- ν -----*/
void Sdg_Error::Log(const char *msg,...)
{
	va_list ap;

	va_start(ap,msg);
	PrintMessage("Script de GUI Log:\n\t",log_file,msg,ap);
	va_end(ap);
}

/*----- ǥХå -----*/
void Sdg_Error::Debug(const char *msg,...)
{
	va_list ap;

	va_start(ap,msg);
	PrintMessage("Script de GUI Debug:\n\t",log_file,msg,ap);
	va_end(ap);
}

/*----- Τνѹ -----*/
void Sdg_Error::ChangeFile(const char *file_name)
{
	FILE *fp;

	fp = fopen(file_name,"w");
	if(fp == NULL){
		Error("Can't open file \"%s\"",file_name);
		return;
	}

	//⤷ɸʳä饯
	if(global_log != stderr && global_log != stdout
			&& global_log != stdin)
		fclose(global_log);
	global_log = fp;
}

#include"Sdg_Base.h"

/*----- Sdg_Base -----*/
Sdg_Base::Sdg_Base()
{
}
Sdg_Base::~Sdg_Base()
{
}

