#include "stdafx.h"
#include "test_funcs.h"
#include <scpl/auto_ary.h>
#include "CountStruct.h"

using namespace scpl;

typedef auto_ary<CountStruct> CSAP;

void taa_1(){
	CSAP a(new CountStruct[10]);
	CSAP b(new CountStruct[10]);
	CSAP c(new CountStruct[10]);
	CSAP d;

	SUT_ASSERT(!a.empty());
	SUT_ASSERT(!b.empty());
	SUT_ASSERT(!c.empty());
	SUT_ASSERT( d.empty());
	SUT_ASSERT_EQUALS(Int,CountStruct::getCount(),30);
	d = a;
	SUT_ASSERT(!d.empty());
	SUT_ASSERT_EQUALS(Int,CountStruct::getCount(),30);
	d = a;
	SUT_ASSERT(!d.empty());
	SUT_ASSERT_EQUALS(Int,CountStruct::getCount(),30);
	b = c;
	SUT_ASSERT(!b.empty());
	SUT_ASSERT_EQUALS(Int,CountStruct::getCount(),20);
	SUT_ASSERT(d == a);
	SUT_ASSERT(b == c);
	SUT_ASSERT(a != c);
	d = NULL;
	SUT_ASSERT(d.empty());
	SUT_ASSERT_EQUALS(Int,CountStruct::getCount(),20);
	SUT_ASSERT(d != a);
	b = NULL;
	SUT_ASSERT(b.empty());
	SUT_ASSERT_EQUALS(Int,CountStruct::getCount(),20);
	SUT_ASSERT(b != c);
	SUT_ASSERT(b == d);
	const CSAP* s = &a;
	CountStruct* cs = ~a;
	SUT_ASSERT_EQUALS(Int,a[5].i,cs[5].i);
	const CSAP& x = c;
	SUT_ASSERT_EQUALS(Int,c[5].i,x[5].i);
}

void test_auto_ary(){
	taa_1();
	SUT_ASSERT_EQUALS(Int,CountStruct::getCount(),0);
}