#include "stdafx.h"
#include "test_funcs.h"
#include <scpl/String.h>
#include <locale.h>

using namespace scpl;

void test_equal(cstr atext,cwstr wtext){
	AString abuf;
	WString	wbuf;
	AString afrom(atext);
	WString wfrom(wtext);
	a_to_w(afrom,wbuf);
	w_to_a(wfrom,abuf);
//	printf("A(%s) - (%s)\n",abuf,atext);
//	printf("W(%S) - (%S)\n",wbuf,wtext);
	SUT_ASSERT(abuf.equals(atext));
	SUT_ASSERT(wbuf.equals(wtext));
}

#define TEST_EQUAL(text) test_equal(text,L##text)
#define flow_(F) try{F;}catch(scpl::sut::sut_assert s){printf("(In Line:%5i)\n",__LINE__);throw s;}

void test_String(){
	setlocale(LC_ALL,"jpn");
	flow_(TEST_EQUAL("test text."));
	flow_(TEST_EQUAL("eXgeLXg"));
	flow_(TEST_EQUAL("@D"));
	flow_(TEST_EQUAL("eXg"));
	flow_(TEST_EQUAL(""));
}