#include "stdafx.h"
#include "test_funcs.h"
#include <scpl/File.h>

using namespace scpl;

void td_aw(){
	FileWriter fw;
	fpos_t pos;

	SUT_CHECK(!fw.opened());

	SUT_ASSERT(fw.open("test.txt"));
	SUT_CHECK(fw.opened());

	fw.putChar('1');
	fw.putChar('3');
	fw.putChar('\n');

	fw.putWChar(L'4');
	fw.putWChar(L'5');
	fw.putWChar(L'\n');

	fw.putStr("an");
	fw.putStr("si",true);
	fw.putWStr(L"uni");
	fw.putWStr(L"code",true);

	SUT_ASSERT(fw.getpos(&pos));
	SUT_CHECK_EQUALS(I64,pos,23);
}
void td_ar(){
	FileReader fr;
	char abuf[16];
	wchar_t wbuf[16];
	fpos_t pos;

	SUT_CHECK(!fr.opened());

	SUT_ASSERT(fr.open("test.txt"));
	SUT_CHECK(fr.opened());

	SUT_ASSERT_EQUALS(Int,fr.getChar(),'1');
	SUT_ASSERT_EQUALS(Int,fr.getChar(),'3');
	SUT_ASSERT_EQUALS(Int,fr.getChar(),'\n');

	SUT_ASSERT_EQUALS(Int,fr.getWChar(),L'4');
	SUT_ASSERT_EQUALS(Int,fr.getWChar(),L'5');
	SUT_ASSERT_EQUALS(Int,fr.getWChar(),L'\n');

	SUT_ASSERT(fr.getStr(abuf));
	SUT_ASSERT_EQUALS(Int,strcmp(abuf,"ansi"),0);
	SUT_ASSERT(fr.getWStr(wbuf,true));
	SUT_ASSERT_EQUALS(Int,wcscmp(wbuf,L"unicode\n"),0);

	SUT_ASSERT(fr.getpos(&pos));
	SUT_CHECK_EQUALS(I64,pos,23);
	SUT_ASSERT_EQUALS(Int,fr.getChar(),EOF);
	SUT_ASSERT(fr.eof());
}
void td_ab(){
	FileBoth fb;
	char abuf[16];
	wchar_t wbuf[16];
	fpos_t pos;

	SUT_ASSERT(fb.open("test.txt"));
	SUT_CHECK(fb.opened());

	fb.putChar('1');
	fb.putChar('3');
	fb.putChar('\n');

	fb.putWChar(L'4');
	fb.putWChar(L'5');
	fb.putWChar(L'\n');

	fb.putStr("an");
	fb.putStr("si",true);
	fb.putWStr(L"uni");
	fb.putWStr(L"code",true);

	SUT_ASSERT(fb.getpos(&pos));
	SUT_CHECK_EQUALS(I64,pos,23);
	SUT_ASSERT(fb.seek(0,File::FS_SET));

	SUT_CHECK(fb.opened());

	SUT_ASSERT_EQUALS(Int,fb.getChar(),'1');
	SUT_ASSERT_EQUALS(Int,fb.getChar(),'3');
	SUT_ASSERT_EQUALS(Int,fb.getChar(),'\n');

	SUT_ASSERT_EQUALS(Int,fb.getWChar(),L'4');
	SUT_ASSERT_EQUALS(Int,fb.getWChar(),L'5');
	SUT_ASSERT_EQUALS(Int,fb.getWChar(),L'\n');

	SUT_ASSERT(fb.getStr(abuf));
	SUT_ASSERT_EQUALS(Int,strcmp(abuf,"ansi"),0);
	SUT_ASSERT(fb.getWStr(wbuf,true));
	SUT_ASSERT_EQUALS(Int,wcscmp(wbuf,L"unicode\n"),0);

	SUT_ASSERT(fb.getpos(&pos));
	SUT_CHECK_EQUALS(I64,pos,23);
	SUT_ASSERT_EQUALS(Int,fb.getWChar(),WEOF);
	SUT_ASSERT(fb.eof());
}

void td_uw(){
	FileWriter fw;
	fpos_t pos;

	SUT_CHECK(!fw.opened());

	SUT_ASSERT(fw.open(L"test.txt"));
	SUT_CHECK(fw.opened());

	fw.putChar('1');
	fw.putChar('3');
	fw.putChar('\n');

	fw.putWChar(L'4');
	fw.putWChar(L'5');
	fw.putWChar(L'\n');

	fw.putStr("an");
	fw.putStr("si",true);
	fw.putWStr(L"uni");
	fw.putWStr(L"code",true);

	SUT_ASSERT(fw.getpos(&pos));
	SUT_CHECK_EQUALS(I64,pos,23);
}
void td_ur(){
	FileReader fr;
	char abuf[16];
	wchar_t wbuf[16];
	fpos_t pos;

	SUT_CHECK(!fr.opened());

	SUT_ASSERT(fr.open(L"test.txt"));
	SUT_CHECK(fr.opened());

	SUT_ASSERT_EQUALS(Int,fr.getChar(),'1');
	SUT_ASSERT_EQUALS(Int,fr.getChar(),'3');
	SUT_ASSERT_EQUALS(Int,fr.getChar(),'\n');

	SUT_ASSERT_EQUALS(Int,fr.getWChar(),L'4');
	SUT_ASSERT_EQUALS(Int,fr.getWChar(),L'5');
	SUT_ASSERT_EQUALS(Int,fr.getWChar(),L'\n');

	SUT_ASSERT(fr.getStr(abuf));
	SUT_ASSERT_EQUALS(Int,strcmp(abuf,"ansi"),0);
	SUT_ASSERT(fr.getWStr(wbuf,true));
	SUT_ASSERT_EQUALS(Int,wcscmp(wbuf,L"unicode\n"),0);

	SUT_ASSERT(fr.getpos(&pos));
	SUT_CHECK_EQUALS(I64,pos,23);
	SUT_ASSERT_EQUALS(Int,fr.getChar(),EOF);
	SUT_ASSERT(fr.eof());
}
void td_ub(){
	FileBoth fb;
	char abuf[16];
	wchar_t wbuf[16];
	fpos_t pos;

	SUT_ASSERT(fb.open(L"test.txt"));
	SUT_CHECK(fb.opened());

	fb.putChar('1');
	fb.putChar('3');
	fb.putChar('\n');

	fb.putWChar(L'4');
	fb.putWChar(L'5');
	fb.putWChar(L'\n');

	fb.putStr("an");
	fb.putStr("si",true);
	fb.putWStr(L"uni");
	fb.putWStr(L"code",true);

	SUT_ASSERT(fb.getpos(&pos));
	SUT_CHECK_EQUALS(I64,pos,23);
	SUT_ASSERT(fb.seek(0,File::FS_SET));

	SUT_CHECK(fb.opened());

	SUT_ASSERT_EQUALS(Int,fb.getChar(),'1');
	SUT_ASSERT_EQUALS(Int,fb.getChar(),'3');
	SUT_ASSERT_EQUALS(Int,fb.getChar(),'\n');

	SUT_ASSERT_EQUALS(Int,fb.getWChar(),L'4');
	SUT_ASSERT_EQUALS(Int,fb.getWChar(),L'5');
	SUT_ASSERT_EQUALS(Int,fb.getWChar(),L'\n');

	SUT_ASSERT(fb.getStr(abuf));
	SUT_ASSERT_EQUALS(Int,strcmp(abuf,"ansi"),0);
	SUT_ASSERT(fb.getWStr(wbuf,true));
	SUT_ASSERT_EQUALS(Int,wcscmp(wbuf,L"unicode\n"),0);

	SUT_ASSERT(fb.getpos(&pos));
	SUT_CHECK_EQUALS(I64,pos,23);
	SUT_ASSERT_EQUALS(Int,fb.getWChar(),WEOF);
	SUT_ASSERT(fb.eof());
}

void test_File(){
	td_aw();
	td_ar();
	td_ab();
	td_uw();
	td_ur();
	td_ub();
}