#include "stdafx.h"
#include "test_funcs.h"
#include <scpl/Argument.h>

using namespace scpl;
using namespace scpl::argument;

inline void ta_besicA(){
	ArgVA* va;
	SUT_ASSERT(createArgumentA(&va,"test1 test2 test3"));
	SUT_ASSERT_EQUALS(Int,va->count(),3);
	SUT_CHECK(va->at(0).equals("test1"));
	SUT_CHECK(va->at(1).equals("test2"));
	SUT_CHECK(va->at(2).equals("test3"));
	delete va;

	SUT_ASSERT(createArgumentA(&va,"testA|testB|testC|testD|testE|testF|testG|testH|","|"));
	SUT_ASSERT_EQUALS(Int,va->count(),8);
	SUT_CHECK(va->at(0).equals("testA"));
	SUT_CHECK(va->at(1).equals("testB"));
	SUT_CHECK(va->at(2).equals("testC"));
	SUT_CHECK(va->at(3).equals("testD"));
	SUT_CHECK(va->at(4).equals("testE"));
	SUT_CHECK(va->at(5).equals("testF"));
	SUT_CHECK(va->at(6).equals("testG"));
	SUT_CHECK(va->at(7).equals("testH"));
	delete va;

	SUT_ASSERT(createArgumentA(&va,"testA testB testC testD \"testE testF testG\" testH "));
	SUT_ASSERT_EQUALS(Int,va->count(),6);
	SUT_CHECK(va->at(0).equals("testA"));
	SUT_CHECK(va->at(1).equals("testB"));
	SUT_CHECK(va->at(2).equals("testC"));
	SUT_CHECK(va->at(3).equals("testD"));
	SUT_CHECK(va->at(4).equals("testE testF testG"));
	SUT_CHECK(va->at(5).equals("testH"));
	delete va;
	SUT_ASSERT(!createArgumentA(&va,"testA testB","\""));

	SUT_ASSERT(createArgumentA(&va,"testA testB testC testD \"testE testF testG\" testH ",NULL,false));
	SUT_ASSERT_EQUALS(Int,va->count(),8);
	SUT_CHECK(va->at(0).equals("testA"));
	SUT_CHECK(va->at(1).equals("testB"));
	SUT_CHECK(va->at(2).equals("testC"));
	SUT_CHECK(va->at(3).equals("testD"));
	SUT_CHECK(va->at(4).equals("\"testE"));
	SUT_CHECK(va->at(5).equals("testF"));
	SUT_CHECK(va->at(6).equals("testG\""));
	SUT_CHECK(va->at(7).equals("testH"));
	delete va;
}
inline void ta_commandlineA(){
	ArgVA* va;

	SUT_ASSERT(createArgumentFromCommandLineA(&va,NONE));
	SUT_ASSERT_EQUALS(Int,va->count(),0);
	delete va;

	SUT_ASSERT(createArgumentFromCommandLineA(&va,CONSOLE));
	SUT_ASSERT_EQUALS(Int,va->count(),1);
	delete va;

	SUT_ASSERT(createArgumentFromCommandLineA(&va,EXENAME));
	SUT_ASSERT_EQUALS(Int,va->count(),1);
	delete va;

	SUT_ASSERT(createArgumentFromCommandLineA(&va,EXEPATH));
	SUT_ASSERT_EQUALS(Int,va->count(),1);
	delete va;

	SUT_ASSERT(createArgumentFromCommandLineA(&va,DIR));
	SUT_ASSERT_EQUALS(Int,va->count(),1);
	delete va;

	SUT_ASSERT(createArgumentFromCommandLineA(&va,EXEDIR));
	SUT_ASSERT_EQUALS(Int,va->count(),1);
	delete va;
}
inline void ta_commandlineToA(){
	int argc;
	str* argv;

	SUT_ASSERT(commandLineToArgvA(&argc,&argv,NONE));
	SUT_ASSERT_EQUALS(Int,argc,0);
	SUT_ASSERT_EQUALS(Ptr,argv,NULL);
	releaseArgvA(argc,argv);

	SUT_ASSERT(commandLineToArgvA(&argc,&argv,CONSOLE));
	SUT_ASSERT_EQUALS(Int,argc,1);
	SUT_ASSERT_NOTEQUALS(Ptr,argv,NULL);
	releaseArgvA(argc,argv);

	SUT_ASSERT(commandLineToArgvA(&argc,&argv,EXENAME));
	SUT_ASSERT_EQUALS(Int,argc,1);
	SUT_ASSERT_NOTEQUALS(Ptr,argv,NULL);
	releaseArgvA(argc,argv);

	SUT_ASSERT(commandLineToArgvA(&argc,&argv,EXEPATH));
	SUT_ASSERT_EQUALS(Int,argc,1);
	SUT_ASSERT_NOTEQUALS(Ptr,argv,NULL);
	releaseArgvA(argc,argv);

	SUT_ASSERT(commandLineToArgvA(&argc,&argv,DIR));
	SUT_ASSERT_EQUALS(Int,argc,1);
	SUT_ASSERT_NOTEQUALS(Ptr,argv,NULL);
	releaseArgvA(argc,argv);

	SUT_ASSERT(commandLineToArgvA(&argc,&argv,EXEDIR));
	SUT_ASSERT_EQUALS(Int,argc,1);
	SUT_ASSERT_NOTEQUALS(Ptr,argv,NULL);
	releaseArgvA(argc,argv);

}


inline void ta_besicW(){
	ArgVW* va;
	SUT_ASSERT(createArgumentW(&va,L"test1 test2 test3"));
	SUT_ASSERT_EQUALS(Int,va->count(),3);
	SUT_CHECK(va->at(0).equals(L"test1"));
	SUT_CHECK(va->at(1).equals(L"test2"));
	SUT_CHECK(va->at(2).equals(L"test3"));
	delete va;

	SUT_ASSERT(createArgumentW(&va,L"testA|testB|testC|testD|testE|testF|testG|testH|",L"|"));
	SUT_ASSERT_EQUALS(Int,va->count(),8);
	SUT_CHECK(va->at(0).equals(L"testA"));
	SUT_CHECK(va->at(1).equals(L"testB"));
	SUT_CHECK(va->at(2).equals(L"testC"));
	SUT_CHECK(va->at(3).equals(L"testD"));
	SUT_CHECK(va->at(4).equals(L"testE"));
	SUT_CHECK(va->at(5).equals(L"testF"));
	SUT_CHECK(va->at(6).equals(L"testG"));
	SUT_CHECK(va->at(7).equals(L"testH"));
	delete va;

	SUT_ASSERT(createArgumentW(&va,L"testA testB testC testD \"testE testF testG\" testH "));
	SUT_ASSERT_EQUALS(Int,va->count(),6);
	SUT_CHECK(va->at(0).equals(L"testA"));
	SUT_CHECK(va->at(1).equals(L"testB"));
	SUT_CHECK(va->at(2).equals(L"testC"));
	SUT_CHECK(va->at(3).equals(L"testD"));
	SUT_CHECK(va->at(4).equals(L"testE testF testG"));
	SUT_CHECK(va->at(5).equals(L"testH"));
	delete va;
	SUT_ASSERT(!createArgumentW(&va,L"testA testB",L"\""));

	SUT_ASSERT(createArgumentW(&va,L"testA testB testC testD \"testE testF testG\" testH ",NULL,false));
	SUT_ASSERT_EQUALS(Int,va->count(),8);
	SUT_CHECK(va->at(0).equals(L"testA"));
	SUT_CHECK(va->at(1).equals(L"testB"));
	SUT_CHECK(va->at(2).equals(L"testC"));
	SUT_CHECK(va->at(3).equals(L"testD"));
	SUT_CHECK(va->at(4).equals(L"\"testE"));
	SUT_CHECK(va->at(5).equals(L"testF"));
	SUT_CHECK(va->at(6).equals(L"testG\""));
	SUT_CHECK(va->at(7).equals(L"testH"));
	delete va;
}
inline void ta_commandlineW(){
	ArgVW* va;

	SUT_ASSERT(createArgumentFromCommandLineW(&va,NONE));
	SUT_ASSERT_EQUALS(Int,va->count(),0);
	delete va;

	SUT_ASSERT(createArgumentFromCommandLineW(&va,CONSOLE));
	SUT_ASSERT_EQUALS(Int,va->count(),1);
	delete va;

	SUT_ASSERT(createArgumentFromCommandLineW(&va,EXENAME));
	SUT_ASSERT_EQUALS(Int,va->count(),1);
	delete va;

	SUT_ASSERT(createArgumentFromCommandLineW(&va,EXEPATH));
	SUT_ASSERT_EQUALS(Int,va->count(),1);
	delete va;

	SUT_ASSERT(createArgumentFromCommandLineW(&va,DIR));
	SUT_ASSERT_EQUALS(Int,va->count(),1);
	delete va;

	SUT_ASSERT(createArgumentFromCommandLineW(&va,EXEDIR));
	SUT_ASSERT_EQUALS(Int,va->count(),1);
	delete va;
}
inline void ta_commandlineToW(){
	int argc;
	wstr* argv;

	SUT_ASSERT(commandLineToArgvW(&argc,&argv,NONE));
	SUT_ASSERT_EQUALS(Int,argc,0);
	SUT_ASSERT_EQUALS(Ptr,argv,NULL);
	releaseArgvW(argc,argv);

	SUT_ASSERT(commandLineToArgvW(&argc,&argv,CONSOLE));
	SUT_ASSERT_EQUALS(Int,argc,1);
	SUT_ASSERT_NOTEQUALS(Ptr,argv,NULL);
	releaseArgvW(argc,argv);

	SUT_ASSERT(commandLineToArgvW(&argc,&argv,EXENAME));
	SUT_ASSERT_EQUALS(Int,argc,1);
	SUT_ASSERT_NOTEQUALS(Ptr,argv,NULL);
	releaseArgvW(argc,argv);

	SUT_ASSERT(commandLineToArgvW(&argc,&argv,EXEPATH));
	SUT_ASSERT_EQUALS(Int,argc,1);
	SUT_ASSERT_NOTEQUALS(Ptr,argv,NULL);
	releaseArgvW(argc,argv);

	SUT_ASSERT(commandLineToArgvW(&argc,&argv,DIR));
	SUT_ASSERT_EQUALS(Int,argc,1);
	SUT_ASSERT_NOTEQUALS(Ptr,argv,NULL);
	releaseArgvW(argc,argv);

	SUT_ASSERT(commandLineToArgvW(&argc,&argv,EXEDIR));
	SUT_ASSERT_EQUALS(Int,argc,1);
	SUT_ASSERT_NOTEQUALS(Ptr,argv,NULL);
	releaseArgvW(argc,argv);

}

void test_Argument(){
	ta_besicA();
	ta_commandlineA();
	ta_commandlineToA();
	ta_besicW();
	ta_commandlineW();
	ta_commandlineToW();
}