// 
// DebugLog.cpp
// 
// Copylight(C) 2007 Mitsunagi

#include "Stdafx.h"
#include "../scpl/DebugLog.h"
#include "../scpl/File.h"
#include <stdarg.h>
#include <time.h>
#include <windows.h>

#if defined(_UNICODE)||defined(UNICODE)
#define tfsopen _wfsopen
#define tstrftime wcsftime
#define tfprintf fwprintf
#define tvfprintf vfwprintf
#define printTime printTimeA
#else
#define tfsopen _fsopen
#define tstrftime strftime
#define tfprintf fprintf
#define tvfprintf vfprintf
#define printTime printTimeW
#endif

namespace scpl{

	inline void printTimeA(FILE* fp){
		char buf[26];
		time_t t;
		time(&t);
		struct tm* _tm = gmtime(&t);
		strftime(buf,26,"%Y/%m/%d[%H:%M:%S] : ",_tm);
		fprintf(fp,buf);
	}
	inline void printTimeW(FILE* fp){
		wchar buf[26];
		time_t t;
		time(&t);
		struct tm* _tm = gmtime(&t);
		wcsftime(buf,26,L"%Y/%m/%d[%H:%M:%S] : ",_tm);
		fwprintf(fp,buf);
	}
	DebugLog::DebugLog(ctstr outlog,ctstr errlog,uint type):_OutLog(NULL),_ErrLog(NULL){
		FILE* out = tfsopen(outlog,(type==DLT_NORMAL)?TC("wt"):TC("at"),File::SF_R);
		if(!out) throw;
		FILE* err = tfsopen(errlog,(type==DLT_NORMAL)?TC("wt"):TC("at"),File::SF_R);
		if(!err){
			fclose(out);
			throw;
		}
		_OutLog = out;
		_ErrLog = err;
	}
	DebugLog::~DebugLog(){
		if(_ErrLog){
			fclose(_OutLog);
			fclose(_ErrLog);
		}
	}

	void DebugLog::out(ctstr format,...){
		va_list va;
		printTime(_OutLog);
		va_start(va,format);
		tvfprintf(_OutLog,format,va);
		tfprintf(_OutLog,TC("\n"));
		va_end(va);
	}
	void DebugLog::err(ctstr format,...){
		va_list va;
		printTime(_ErrLog);
		va_start(va,format);
		tvfprintf(_ErrLog,format,va);
		tfprintf(_ErrLog,TC("\n"));
		va_end(va);
	}
	void DebugLog::console(cstr format,...){
		va_list va;
		printTimeA(stdout);
		va_start(va,format);
		vprintf(format,va);
		printf("\n");
		va_end(va);
	}
	void DebugLog::console_f(cstr format,...){
		va_list va;
		va_start(va,format);
		vprintf(format,va);
		va_end(va);
	}

} // namespace scpl