// 
// exception.h
// 
// Copyright(C) 2006-2007 Ó
#ifndef _exception_INCLUDED_
#define _exception_INCLUDED_
#include "scpl.h"
#include "template.h"
#ifdef __BORLANDC__
#include <exceptio.h>
#include <stdexcep.h>
#else
#include <stdexcept>
#endif

/**
	Cu̗OɊւwb_[t@CłB
**/

namespace scpl{

	/** ObZ[W **/
	static const cstr FILLED_CAPACITY	= "be filled to capacity";
	static const cstr DO_NOT_HAVE_DATA	= "It don't have data";
	static const cstr MUST_BE_L_AVOBE_R	= "An argument must be \"l < r\"";
	static const cstr NOT_FOUND			= "What was specified was not found";
	static const cstr OUT_OF_RANGE		= "It's over the eliminable range";
	static const cstr BAD_CAST			= "failed cast";

	/** O}N **/
#define THROW_FILLED_CAPACITY() throw std::runtime_error(FILLED_CAPACITY)
#define THROW_DO_NOT_HAVE_DATA() throw std::runtime_error(DO_NOT_HAVE_DATA)
#define THROW_MUST_BE_L_AVOBE_R() throw std::invalid_argument(MUST_BE_L_AVOBE_R)
#define THROW_NOT_FOUND() throw std::invalid_argument(NOT_FOUND)
#define THROW_OUT_OF_RANGE() throw std::out_of_range(OUT_OF_RANGE)
#define THROW_BAD_CAST() throw std::bad_cast(BAD_CAST)
#define THROW_BAD_ALLOC() throw std::bad_alloc()

	/* o͗O */
	class IOException : public std::runtime_error{
	public:
		explicit IOException(const std::string& _Message):std::runtime_error(_Message){}
	};
	/* I[vsO */
	class OpenException : public IOException{
	public:
		explicit OpenException(const std::string& _Message):IOException(_Message){}
	};
	/* EOFO */
	class EOFException : public IOException{
	public:
		explicit EOFException(const std::string& _Message):IOException(_Message){}
	};

	/**
		nꂽ NULL ̏ꍇ std::bad_alloc O𔭐܂B
		[arg]
		t	: `FbNB
		[return]
		t ̂܂ܕԂ܂B
		[exc]
		std::bad_alloc	: t  NULL B
	**/
	TMP inline T* newcheck(T* t){
		if(!t) THROW_BAD_ALLOC();
		return t;
	}
	/**
		e𒴂ꍇ std::runtime_error O𔭐
		`FbNs܂B
		[arg]
		size	: `FbN鐔B
		cap		: eB
		[exc]
		std::runtime_error	: w肵e邱ƂoȂB
	**/
	inline void capacitycheck(ulong size,ulong cap){
		if(size > cap) THROW_FILLED_CAPACITY();
	}

} // namespace scpl

#endif