// 
// color.h
// 
// Copyright(C) 2006-2007 Ó
#ifndef _color_INCLUDED_
#define _color_INCLUDED_
#include "scpl.h"
#include "utility.h"

/**
	FݒE擾EvZCC֐QłB
**/

namespace scpl{

	namespace color{

/**
	eF̃}XNłB
**/
#define CLRMSK_A 0xff000000L
#define CLRMSK_R 0x00ff0000L
#define CLRMSK_G 0x0000ff00L
#define CLRMSK_B 0x000000ffL

		/**
			ARGB lԂ܂B
			[arg]
			a	: At@B
			r	: R B
			g	: G B
			b	: B B
			[return]
			ꂽ ARGB B
		**/
		inline ulong toARGB(byte a,byte r,byte g,byte b){return (a<<24) | (r<<16) | (g<<8) | b;}
		/**
			RGB lԂ܂BAt@l̕ 0xff ɂȂ܂B
			[arg]
			r	: R B
			g	: G B
			b	: B B
			[return]
			ꂽ ARGB B
		**/
		inline ulong toRGB(byte r,byte g,byte b){return 0xff000000 | (r<<16) | (g<<8) | b;}
		/**
			ARGBF̒ԐFԂ܂B
			[arg]
			argb1	: ARGB B
			argb2	: ARGB B
			[return]
			 ARGB ̒ԐFB
		**/
		inline ulong centerARGB(ulong argb1,ulong argb2){
			return (center(argb1&CLRMSK_A,argb2&CLRMSK_A)&CLRMSK_A) |
				(center(argb1&CLRMSK_R,argb2&CLRMSK_R)&CLRMSK_R) |
				(center(argb1&CLRMSK_G,argb2&CLRMSK_G)&CLRMSK_G) |
				(center(argb1&CLRMSK_B,argb2&CLRMSK_B)&CLRMSK_B);
		}
		/**
			RGBF̒ԐFԂ܂BAt@l̕ a ɂȂ܂B
			[arg]
			rgb1	: RGB B
			rgb2	: RGB B
			a		: At@B
			[return]
			 RGB ̒ԐFiAt@ a jB
		**/
		inline ulong centerRGB(ulong rgb1,ulong rgb2,byte a=0xff){
			return (a<<24) |
				(center(rgb1&CLRMSK_R,rgb2&CLRMSK_R)&CLRMSK_R) |
				(center(rgb1&CLRMSK_G,rgb2&CLRMSK_G)&CLRMSK_G) |
				(center(rgb1&CLRMSK_B,rgb2&CLRMSK_B)&CLRMSK_B);
		}
		/**
			F𔽓]܂B
			[arg]
			argb	: ARGB B
			[return]
			e]ꂽ ARGB B
		**/
		inline ulong reverseARGB(ulong argb){return ~argb;}
		/**
			F𔽓]܂BAt@l͔]܂B
			[arg]
			argb	: ARGB B
			[return]
			RGB ]ꂽ ARGB B
		**/
		inline ulong reverseRGB(ulong argb){return argb ^ 0x00ffffff;}

	} // namespace color

} // namespace scpl
#endif
