// 
// Stack.h
// 
// Copyright(C) 2006-2007 Ó
#ifndef _Stack_INCLUDED_
#define _Stack_INCLUDED_
#include "Container.h"
#include "find.h"

namespace scpl{

	TMP class CStack;
	TMP class DStack;
	BUFTMP class CFStack;
	BUFTMP class DFStack;

	/**
		X^bNǗꒊۃNXłB
	**/
	TMP class IStack : public IContainer<T>{
	protected:
		virtual T* _data()const=0;
	public:
		TDEF();

		IStack():_UseCount(0){}

		virtual ~IStack(){}

		/**
			f[^LĂȂԂ܂B
			[return]
			f[^LĂȂꍇ true AłȂꍇ false Ԃ܂B
		**/
		virtual bool empty()const{return _UseCount == 0;}
		/**
			LĂf[^̐Ԃ܂B
			[return]
			LĂf[^̐B
		**/
		virtual ulong count()const{return _UseCount;}
		/**
			i[\̐Ԃ܂B
			[return]
			i[\B
		**/
		virtual ulong capacity()const=0;
		/**
			w肵f[^zRs[܂B
			[arg]
			p	: Rs[̃f[^zB
			c	: f[^̐B
			[exc]
			std::bad_alloc	: Rs[ɕKvȗ̈mۂłȂB
		**/
		virtual void copy(cptr data,ulong c)=0;

		/**
			f[^擾܂B
			[return]
			݂̃f[^B
			[exc]
			std::runtime_error	: f[^LĂȂB
		**/
		ind get()const{
			if(count() == 0) THROW_DO_NOT_HAVE_DATA();
			return *_GetPos;
		}

		/**
			f[^ǉ܂B
			[arg]
			data	: ǉf[^B
			[exc]
			std::runtime_error	: ǉł̈悪ȂB
		**/
		virtual void push(cind data)=0;

		/**
			f[^o܂B
			[exc]
			std::runtime_error	: f[^LĂȂB
		**/
		virtual void pop()=0;

		/**
			w肵f[^zƈv邩Ԃ܂B
			[arg]
			p	: rf[^zB
			c	: f[^̐B
			[return]
			vꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool equals(cptr p,ulong c)const{
			if(p != _data()){
				if(c != count()) return false;
				cptr it=_data(),end=_data()+count();
				for(;it<end;++it,++p){
					if(*it != *p) return false;
				}
			}
			return true;
		}

	protected:
		ptr		_GetPos;
		ulong	_UseCount;

	};
	
	/**
		ϒX^bN̒ۃNXłB
	**/
	TMP class IStack_Buffer : public IStack<T>{
	protected:
		virtual ptr _data()const{return _List.begin();}
	public:
		IStack_Buffer(ulong c=0):_List(c){_GetPos = _List.begin();}

		virtual ~IStack_Buffer(){}

		/**
			cmۉ\̈ݒ肵܂B
			[arg]
			cap	: ݒ肷cmۉ\̈̐B
			[exc]
			std::bad_alloc	: w肵̈mۂłȂB
		**/
		void adjust(ulong c=0){_List.aResize(count()+c);}

		/**
			f[^ւ܂B
			[arg]
			s	: ւf[^B
		**/
		void swap(IStack_Buffer<T>* s){
			_container_swap(_List,_UseCount,s->_List,s->_UseCount);
			scpl::swap(_GetPos,s->_GetPos);
		}

		/**
			L̃o֐̐ IStack NXQƂĂB
		**/
		virtual ulong capacity()const{return _List.count();}

	protected:
		Buffer<T>	_List;

	};
	/**
		Œ蒷X^bN̒ۃNXłB

		̃NX̃o֐̐́A IStack_Buffer NX
		QƂĂB
	**/
	BUFTMP class IStack_Fixed : public IStack<T>{
	protected:
		virtual ptr _data()const{return const_cast<ptr>(_List.get());}
	public:
		IStack_Fixed(){_GetPos = _List;}
		virtual ~IStack_Fixed(){}
		virtual ulong capacity()const{return C;}
		void swap(IStack_Fixed<T,C>* s){
			_container_swap_fixed(_List,_UseCount,s->_List,s->_UseCount);
			scpl::swap(_GetPos,s->_GetPos);
		}
	protected:
		FBuffer<T,C>	_List;
	};


	/**
		ϒNXX^bNReiNXłB
		̃NX̊{@\ STL Cu stack ɑ̂łA
		֐Ȃǂ͓ł͂܂B
	**/
	TMP class CStack : public IStack_Buffer<T>{
		typedef CStack<T> self;

	public:
		/**
			́A邢͎w肵̈mۂč쐬܂B
			[arg]
			c	: mۂ̈B
			[exc]
			std::bad_alloc	: w肵̈mۂłȂB
		**/
		CStack(ulong c=0):IStack_Buffer<T>(c){}
		/**
			w肵f[^zRs[X^bN쐬܂B
			[arg]
			p	: Rs[̃f[^zB
			c	: f[^̐B
			[exc]
			std::bad_alloc	: Rs[ɕKvȗ̈mۂłȂB
		**/
		CStack(cptr p,ulong c):IStack_Buffer<T>(c){copy(p,c);}
		/**
			w肵X^bN̕쐬܂B
			[arg]
			s	: X^bNB
			[exc]
			std::bad_alloc	: ɕKvȗ̈mۂłȂB
		**/
		explicit CStack(const self& s):IStack_Buffer<T>(s.count()){copy(s.begin(),s.count());}

		/**
			fXgN^B
			f[^Sč폜܂B
		**/
		virtual ~CStack(){clear();}

		/**
			f[^Sč폜܂B
		**/
		virtual void clear(){_container_clear(_List,_UseCount);}

		/**
			f[^LĂ邩Ԃ܂B
			[return]
			f[^LĂꍇ true AłȂꍇ false Ԃ܂B
		**/
		operator bool()const{return !empty();}
		/**
			f[^LĂȂԂ܂B
			[return]
			f[^LĂȂꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool operator!()const{return empty();}

		/**
			w肵X^bNƈv邩Ԃ܂B
			[arg]
			s	: rX^bNB
			[return]
			vꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool operator==(const CStack<T>& s)const{return equals(s._data(),s.count());}
		bool operator==(const DStack<T>& s)const{return equals(s._data(),s.count());}
		NTMP bool operator==(const CFStack<T,N>& s)const{return equals(s._data(),s.count());}
		NTMP bool operator==(const DFStack<T,N>& s)const{return equals(s._data(),s.count());}
		/**
			w肵X^bNƕsvԂ܂B
			[arg]
			s	: rX^bNB
			[return]
			sv̏ꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool operator!=(const CStack<T>& s)const{return !equals(s._data(),s.count());}
		bool operator!=(const DStack<T>& s)const{return !equals(s._data(),s.count());}
		NTMP bool operator!=(const CFStack<T,N>& s)const{return !equals(s._data(),s.count());}
		NTMP bool operator!=(const DFStack<T,N>& s)const{return !equals(s._data(),s.count());}

		/**
			w肵X^bN܂B
			[arg]
			s	: X^bNB
			[return]
			g̃CX^XԂ܂B
			[exc]
			std::bad_alloc	: ɕKvȗ̈mۂłȂB
		**/
		self& operator=(const CStack<T>& s){copy(s._data(),s.count());return *this;}
		self& operator=(const DStack<T>& s){copy(s._data(),s.count());return *this;}
		NTMP self& operator=(const CFStack<T,N>& s){copy(s._data(),s.count());return *this;}
		NTMP self& operator=(const DFStack<T,N>& s){copy(s._data(),s.count());return *this;}

		/**
			w肵X^bNƓeւ܂B
			[arg]
			s	: ւX^bNB
		**/
		void swap(const self& s){swap(&s);}

		/**
			L̃o֐̐ IStack NXQƂĂB
		**/
		virtual void push(cind data){
			if(count() == capacity()) _List.rResize(1);
			_GetPos = _List.begin()+_UseCount;
			::new(_GetPos) T(data);
			++_UseCount;
		}
		virtual void pop(){
			if(empty()) THROW_DO_NOT_HAVE_DATA();
			_GetPos->~T();
			--_GetPos;
			--_UseCount;
		}
		virtual void copy(cptr data,ulong c){
			clear();
			_container_copy(data,c,_List,_UseCount);
			_GetPos = _List.begin() + c - 1;
		}

	};

	/**
		ϒf[^X^bNReiNXłB
		̃NX̊{@\ STL Cu stack ɑ̂łA
		֐Ȃǂ͓ł͂܂B

		̃NX̓RXgN^EfXgN^𔭐܂B
		̂߁ANXgpf[^Ǘꍇ
		CStack gpĂB

		̃NX̃o֐ CStack Ɠs܂B
		eo֐̐́@CStack ̃o֐QƂĂB
	**/
	TMP class DStack : public IStack_Buffer<T>{
		typedef DStack<T> self;
	public:
		DStack(ulong c=0):IStack_Buffer<T>(c){}
		DStack(cptr p,ulong c):IStack_Buffer<T>(c){copy(p,c);}
		explicit DStack(const self& s):IStack_Buffer<T>(s.count()){copy(s.begin(),s.count());}
		virtual ~DStack(){}
		virtual void push(cind data){
			if(count() == capacity()) _List.rResize(1);
			_GetPos = _List+_UseCount;
			memcpy(_GetPos,&data,sizeof(T));
			++_UseCount;
		}
		virtual void pop(){
			if(empty()) THROW_DO_NOT_HAVE_DATA();
			--_GetPos;
			--_UseCount;
		}
		virtual void copy(cptr data,ulong c){
			clear();
			_container_copy_n(data,c,_List,_UseCount);
			_GetPos = _List.begin() + c - 1;
		}
		virtual void clear(){_UseCount = 0;}
		operator bool()const{return !empty();}
		bool operator!()const{return empty();}
		bool operator==(const CStack<T>& s)const{return equals(s._data(),s.count());}
		bool operator==(const DStack<T>& s)const{return equals(s._data(),s.count());}
		NTMP bool operator==(const CFStack<T,N>& s)const{return equals(s._data(),s.count());}
		NTMP bool operator==(const DFStack<T,N>& s)const{return equals(s._data(),s.count());}
		bool operator!=(const CStack<T>& s)const{return !equals(s._data(),s.count());}
		bool operator!=(const DStack<T>& s)const{return !equals(s._data(),s.count());}
		NTMP bool operator!=(const CFStack<T,N>& s)const{return !equals(s._data(),s.count());}
		NTMP bool operator!=(const DFStack<T,N>& s)const{return !equals(s._data(),s.count());}
		self& operator=(const CStack<T>& s){copy(s._data(),s.count());return *this;}
		self& operator=(const DStack<T>& s){copy(s._data(),s.count());return *this;}
		NTMP self& operator=(const CFStack<T,N>& s){copy(s._data(),s.count());return *this;}
		NTMP self& operator=(const DFStack<T,N>& s){copy(s._data(),s.count());return *this;}
		void swap(const self& s){swap(&s);}
	};

	/**
		Œ蒷NXX^bNReiNXłB
		̃NX̊{@\ STL Cu stack ɑ̂łA
		֐Ȃǂ͓ł͂܂B

		̃NX̃o֐ CStack Ɠs܂B
		eo֐̐́@CStack ̃o֐QƂĂB
		Œ蒷f[^߁A CStack A DStack ɂ Capacity ̈
		삷鏈i adjust ֐A clear ֐ clearCap j݂͑܂B
		[note]
		̃NX͌Œ蒷f[^߁A
		eʂ𒴂f[^̒ǉs std::runtime_error O
		܂B
	**/
	BUFTMP class CFStack : public IStack_Fixed<T,C>{
		typedef CFStack<T,C> self;
	public:
		CFStack():IStack_Fixed<T,C>(){}
		CFStack(cptr p,ulong c):IStack_Fixed<T,C>(c){copy(p,c);}
		explicit CFStack(const self& s):IStack_Fixed<T,C>(s.count()){copy(s.begin(),s.count());}
		virtual ~CFStack(){clear();}
		virtual void push(cind data){
			if(C == count()) THROW_FILLED_CAPACITY();
			_GetPos = _List+_UseCount;
			::new(_GetPos) T(data);
			++_UseCount;
		}
		virtual void pop(){
			if(empty()) THROW_DO_NOT_HAVE_DATA();
			_GetPos->~T();
			--_GetPos;
			--_UseCount;
		}
		virtual void copy(cptr data,ulong c){
			clear();
			_container_copy_fixed(data,c,_List,_UseCount);
			_GetPos = _List.begin() + c - 1;
		}
		virtual void clear(){_container_clear_fixed(_List,_UseCount);}
		operator bool()const{return !empty();}
		bool operator!()const{return empty();}
		bool operator==(const CStack<T>& s)const{return equals(s._data(),s.count());}
		bool operator==(const DStack<T>& s)const{return equals(s._data(),s.count());}
		NTMP bool operator==(const CFStack<T,N>& s)const{return equals(s._data(),s.count());}
		NTMP bool operator==(const DFStack<T,N>& s)const{return equals(s._data(),s.count());}
		bool operator!=(const CStack<T>& s)const{return !equals(s._data(),s.count());}
		bool operator!=(const DStack<T>& s)const{return !equals(s._data(),s.count());}
		NTMP bool operator!=(const CFStack<T,N>& s)const{return !equals(s._data(),s.count());}
		NTMP bool operator!=(const DFStack<T,N>& s)const{return !equals(s._data(),s.count());}
		self& operator=(const CStack<T>& s){copy(s._data(),s.count());return *this;}
		self& operator=(const DStack<T>& s){copy(s._data(),s.count());return *this;}
		self& operator=(const CFStack<T,C>& s){copy(s._data(),s.count());return *this;}
		self& operator=(const DFStack<T,C>& s){copy(s._data(),s.count());return *this;}
		NTMP self& operator=(const CFStack<T,N>& s){copy(s._data(),s.count());return *this;}
		NTMP self& operator=(const DFStack<T,N>& s){copy(s._data(),s.count());return *this;}
		void swap(const self& s){swap(&s);}
	};
	/**
		Œ蒷f[^X^bNReiNXłB
		̃NX̊{@\ STL Cu stack ɑ̂łA
		֐Ȃǂ͓ł͂܂B

		̃NX̓RXgN^EfXgN^𔭐܂B
		̂߁ANXgpf[^Ǘꍇ
		CFStack gpĂB

		̃NX̃o֐ CFStack Ɠs܂B
		eo֐̐́@CFStack ̃o֐QƂĂB
		Œ蒷f[^߁A CStack A DStack ɂ Capacity ̈
		삷鏈i adjust ֐A clear ֐ clearCap j݂͑܂B
		[note]
		̃NX͌Œ蒷f[^߁A
		eʂ𒴂f[^̒ǉs std::runtime_error O
		܂B
	**/
	BUFTMP class DFStack : public IStack_Fixed<T,C>{
		typedef DFStack<T,C> self;
	public:
		DFStack():IStack_Fixed<T,C>(){}
		DFStack(cptr p,ulong c):IStack_Fixed<T,C>(c){copy(p,c);}
		explicit DFStack(const self& s):IStack_Fixed<T,C>(s.count()){copy(s.begin(),s.count());}
		virtual ~DFStack(){}
		virtual void push(cind data){
			if(C == count()) THROW_FILLED_CAPACITY();
			_GetPos = _List+_UseCount;
			memcpy(_GetPos,&data,sizeof(T));
			++_UseCount;
		}
		virtual void pop(){
			if(empty()) THROW_DO_NOT_HAVE_DATA();
			--_GetPos;
			--_UseCount;
		}
		virtual void copy(cptr data,ulong c){
			clear();
			_container_copy_fixed_n(data,c,_List,_UseCount);
			_GetPos = _List.begin() + c - 1;
		}
		virtual void clear(){_UseCount=0;}
		operator bool()const{return !empty();}
		bool operator!()const{return empty();}
		bool operator==(const CStack<T>& s)const{return equals(s._data(),s.count());}
		bool operator==(const DStack<T>& s)const{return equals(s._data(),s.count());}
		NTMP bool operator==(const CFStack<T,N>& s)const{return equals(s._data(),s.count());}
		NTMP bool operator==(const DFStack<T,N>& s)const{return equals(s._data(),s.count());}
		bool operator!=(const CStack<T>& s)const{return !equals(s._data(),s.count());}
		bool operator!=(const DStack<T>& s)const{return !equals(s._data(),s.count());}
		NTMP bool operator!=(const CFStack<T,N>& s)const{return !equals(s._data(),s.count());}
		NTMP bool operator!=(const DFStack<T,N>& s)const{return !equals(s._data(),s.count());}
		self& operator=(const CStack<T>& s){copy(s._data(),s.count());return *this;}
		self& operator=(const DStack<T>& s){copy(s._data(),s.count());return *this;}
		self& operator=(const CFStack<T,C>& s){copy(s._data(),s.count());return *this;}
		self& operator=(const DFStack<T,C>& s){copy(s._data(),s.count());return *this;}
		NTMP self& operator=(const CFStack<T,N>& s){copy(s._data(),s.count());return *this;}
		NTMP self& operator=(const DFStack<T,N>& s){copy(s._data(),s.count());return *this;}
		void swap(const self& s){swap(&s);}
	};

} // namespace scpl
#endif