// 
// Pair.h
// 
// Copyright(C) 2007 Mitsunagi

#ifndef _Pair_INCLUDED_
#define _Pair_INCLUDED_

namespace scpl{

	/**
		̒lNXłB
		 Map nNX̃L[ƒlɎgĂ܂B
	**/
	template<class L,class R>
	class Pair{
		typedef L&			ind_l;
		typedef const L&	cind_l;
		typedef R&			ind_r;
		typedef const R&	cind_r;

		typedef Pair<L,R>	self;

	public:
		/**
			ftHgRXgN^B
			̒lƂ̒lgp܂B
		**/
		Pair():_L(),_R(){}
		/**
			̒lw肵č쐬܂B
			[arg]
			l	: L ̒lB
			r	: R ̒lB
		**/
		Pair(cind_l l,cind_r r):_L(l),_R(r){}
		/**
			Rs[RXgN^B
			[arg]
			s	: Rs[̃yAB
		**/
		Pair(const self& s):_L(s._L),_R(s._R){}

		/**
			yA܂B
			[arg]
			s	: ̃yAB
			[return]
			g̃CX^XԂ܂B
		**/
		self& operator=(const self& s){setL(s._L);setR(s._R);return *this;}

		/**
			w肵yAƈv邩Ԃ܂B
			[arg]
			s	: ryA
			[return]
			vꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool operator==(const self& s)const{return equals(s);}
		/**
			w肵yAƕsvԂ܂B
			[arg]
			s	: ryA
			[return]
			sv̏ꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool operator!=(const self& s)const{return !equals(s);}

		/**
			L ̒lԂ܂B
			[return]
			L ̒lB
		**/
		ind_l getL(){return _L;}
		cind_l getL()const{return _L;}

		/**
			R ̒lԂ܂B
			[return]
			R ̒lB
		**/
		ind_r getR(){return _R;}
		cind_r getR()const{return _R;}

		/**
			L ̒lݒ肵܂B
			[arg]
			l	: L ɐݒ肷lB
		**/
		void setL(cind_l l){_L = l;}
		/**
			R ̒lݒ肵܂B
			[arg]
			r	: R ɐݒ肷lB
		**/
		void setR(cind_r r){_R = r;}

		/**
			w肵yAƈv邩Ԃ܂B
			[arg]
			s	: ryA
			[return]
			vꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool equals(const self& s)const{return (_L == s._L)&&(_R == s._R);}

	private:
		L	_L;
		R	_R;

	};

} // namespace scpl
#endif // _Pair_INCLUDED_