// 
// FBuffer.h
// 
// Copyright(C) 2006-2007 Ó
#ifndef _FBuffer_INCLUDED_
#define _FBuffer_INCLUDED_
#include "utility.h"
#include "exception.h"

namespace scpl{

	/**
		̃NX̓ev[gŎw肵TCY
		PʂƂĔzmۂ܂B
		̃NXł̓RXgN^EfXgN^͔܂B
	**/
	BUFTMP class FBuffer{

		typedef FBuffer<T,C>	self;
		typedef T*				ptr;
		typedef const T*		cptr;

	public:

		/**
			obt@쐬܂B
			[arg]
			zeroClear	: mۂf[^[NA邩ǂB
		**/
		FBuffer(bool zeroClear=false){if(zeroClear) clear();}
		/**
			w肵f[^ŕA܂B
			[arg]
			size		: ̃f[^B
			count		: ̃f[^̍ڐB
			zeroClear	: ㏑ĂȂ̈[NA邩ǂB
			[note]
			count L𒴂ꍇ͏L̂ݕ܂B
		**/
		FBuffer(T* p,ulong count,bool zeroClear=false){copy(p,count,zeroClear);}
		template<ulong count>
		FBuffer(T(&p)[count],bool zeroClear=false){copy(p,count,zeroClear);}

		/**
			f[^𕡐܂B
			[arg]
			s	: ̃f[^B
		**/
		explicit FBuffer(const self& s){copy(s.begin(),C);}

		virtual ~FBuffer(){}

		/**
			f[^Ԃ܂B
			[return]
			LĂf[^ւ̃|C^B
		**/
		operator ptr(){return (ptr)(_Buffer);}
		operator cptr()const{return (cptr)(_Buffer);}

		/**
			f[^v邩ǂԂ܂B
			[arg]
			s	: ׂf[^B
			[return]
			vꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool operator==(const self& s)const{return equals(s);}
		/**
			f[^svǂԂ܂B
			s	: ׂf[^B
			[return]
			sv̏ꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool operator!=(const self& s)const{return !equals(s);}

		/**
			f[^Rs[܂B
			[arg]
			t	: Rs[̃f[^B
			[return]
			g̃CX^XԂ܂B
		**/
		self& operator=(const self& t){copy(t.begin(),t.count());return *this;}

		/**
			w肵f[^畡܂B
			[arg]
			data		: zB
			count		: z̍ڐB
			zeroClear	: ㏑ĂȂ̈[NA邩ǂB
		**/
		void copy(cptr data,ulong count,bool zeroClear=false){
			if(data&&count){
				if(count > C) count = C;
				memcpy(_Buffer,data,sizeof(T)*count);
			}
			else count = 0;
			memset(_Buffer + (count*sizeof(T)),0,(C - count)*sizeof(T));
		}

		/**
			w肵f[^畡܂B
			[arg]
			s			: ̃f[^B
			zeroClear	: ㏑ĂȂ̈[NA邩ǂB
		**/
		void copy(const self& s){copy(s.begin(),s.count());}

		/**
			f[^|C^Ԃ܂B
			[return]
			LĂf[^ւ̃|C^B
		**/
		ptr get(){return (ptr)(_Buffer);}
		cptr get()const{return (cptr)(_Buffer);}

		/**
			f[^Ԃ܂B
			[return]
			LĂf[^̍ڐB
		**/
		ulong count()const{return C;}

		/**
			f[^TCYԂ܂B
			[return]
			LĂf[^̃oCgTCYB
		**/
		ulong size()const{return sizeof(T)*C;}

		/**
			p̍ŏ̈ʒu|C^Ԃ܂B
			[return]
			z̍ŏ̈ʒu|C^B
		**/
		ptr begin(){return reinterpret_cast<ptr>(_Buffer);}
		cptr begin()const{return reinterpret_cast<cptr>(_Buffer);}
		/**
			p̍Ō̈ʒu|C^Ԃ܂B
			[return]
			z̍Ō̈ʒu|C^B
			̈ʒüOLĂI[łB
		**/
		ptr end(){return reinterpret_cast<ptr>(_Buffer)+C;}
		cptr end()const{return reinterpret_cast<cptr>(_Buffer)+C;}
		/**
			tp̍ŏ̈ʒu|C^Ԃ܂B
			[return]
			tz̍ŏ̈ʒu|C^B
		**/
		ptr rbegin(){return reinterpret_cast<ptr>(_Buffer)+C-1;}
		cptr rbegin()const{return reinterpret_cast<cptr>(_Buffer)+C-1;}
		/**
			tp̍Ō̈ʒu|C^Ԃ܂B
			[return]
			tz̍Ō̈ʒu|C^B
			̈ʒüオLĂI[łB
		**/
		ptr rend(){return reinterpret_cast<ptr>(_Buffer)-1;}
		cptr rend()const{return reinterpret_cast<cptr>(_Buffer)-1;}

		/**
			f[^ 0 ŏ܂B
		**/
		void clear(){memset(_Buffer,0,C*sizeof(T));}

		/**
			f[^ւ܂B
			[arg]
			s	: ւf[^B
		**/
		void swap(self& s){
			byte buf[C*sizeof(T)];
			memcpy(buf,_Buffer,C*sizeof(T));
			memcpy(_Buffer,s._Buffer,C*sizeof(T));
			memcpy(s._Buffer,buf,C*sizeof(T));
		}

		/**
			f[^v邩ǂԂ܂B
			[arg]
			s	: ׂf[^B
			[return]
			vꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool equals(const self& s)const{
			if(this != &s){
				cptr a=begin(),b=s.begin(),n=end();
				for(;a<n;++a,++b){
					if(*a != *b) return false;
				}
			}
			return true;
		}

		/**
			obt@̃|C^CfbNXlԂ܂B
			[arg]
			ptr	: ̃NX̏LĂ邢ꂩ̃f[^w|C^B
			[return]
			LĂf[^̐擪̈ʒuB
			[note]
			̊֐ NULL y ͈͂̃`FbNsĂ܂B
			̂߁ALĂȂꍇA
			n|C^͈͊Ȍꍇ̌ʂ͖`łB
		**/
		ulong toPos(cptr p)const{return static_cast<ulong>(p - (ptr)(_Buffer));}

	private:
		byte _Buffer[C*sizeof(T)];

	};

} // namespace scpl
#endif