// 
// Buffer.h
// 
// Copyright(C) 2006-2007 Ó
#ifndef _Buffer_INCLUDED_
#define _Buffer_INCLUDED_
#include "utility.h"
#include "exception.h"
#include <malloc.h>

namespace scpl{

	/**
		̃NX̓ev[gŎw肵TCY
		PʂƂĊmہAJs܂B

		mہAJɂ malloc n֐gp܂B
	**/
	template<class T>
	class Buffer{

		typedef Buffer<T>	self;
		typedef T*			ptr;
		typedef const T*	cptr;

	public:

		/**
			̈mۂ܂B
			[arg]
			size		: mۂ鐔B 0 ̏ꍇ͊mۂȂB
			zeroClear	: mۂf[^[NA邩ǂB
			[exc]
			std::bad_alloc	: w肵̈mۂłȂB
		**/
		Buffer(ulong count=0,bool zeroClear=false):_Buffer(NULL),_Count(count){
			if(count){
				_Buffer = newcheck((T*)malloc(sizeof(T)*count));
				if(zeroClear) memset(_Buffer,0,sizeof(T)*count);
			}
		}
		/**
			w肵f[^̕܂B
			[arg]
			size	: ̃f[^B
			count	: ̃f[^̍ڐB
			[exc]
			std::bad_alloc	: w肵̈mۂłȂB
		**/
		Buffer(T* p,ulong count):_Buffer(NULL),_Count(NULL){copy(p,count);}
		template<ulong count>
		Buffer(T(&p)[count]):_Buffer(NULL),_Count(NULL){copy(p,count);}

		/**
			f[^𕡐܂B
			[arg]
			s	: ̃f[^B
			[exc]
			std::bad_alloc	: w肵̈mۂłȂB
		**/
		explicit Buffer(const self& s):_Buffer(NULL),_Count(0){
			if(s){
				_Buffer = newcheck((T*)malloc(sizeof(T)*s._Count));
				memcpy(_Buffer,s._Buffer,s._Count*sizeof(T));
				_Count = s._Count;
			}
		}

		/**
			fXgN^B
			f[^܂B
		**/
		virtual ~Buffer(){
			if(_Buffer) free(_Buffer);
		}

		/**
			f[^Ԃ܂B
			[return]
			LĂf[^ւ̃|C^B
		**/
		operator ptr()const{return _Buffer;}
		/**
			f[^݂ȂԂ܂B
			[return]
			f[^LĂȂꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool operator!()const{return _Count==0;}

		/**
			f[^v邩ǂԂ܂B
			[arg]
			s	: ׂCX^XB
			[return]
			f[^LĂȂꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool operator==(const self& s)const{return equals(s);}
		/**
			f[^svǂԂ܂B
			s	: ׂCX^XB
			[return]
			f[^LĂȂꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool operator!=(const self& s)const{return !equals(s);}

		/**
			f[^Rs[܂B
			[arg]
			t	: Rs[̃f[^B
			[return]
			g̃CX^XԂ܂B
			[exc]
			std::bad_alloc	: w肵̈mۂłȂB
		**/
		self& operator=(const self& t){copy(t);return *this;}

		/**
			f[^𑊑ΐŃTCY܂B
			[arg]
			size		: TCY鑊ΐB
			zeroClear	: mۂf[^[NA邩ǂB
			[exc]
			std::bad_alloc	: w肵̈mۂłȂB
			[note]
			΃TCY̌ʂ̒lɂȂꍇ́A
			0 ƂĈ܂B
		**/
		void rResize(long count,bool zeroClear=false){
			if(count != 0){
				count += _Count;
				if(0 <= count) aResize(count,zeroClear);
				else clear();
			}
		}
		/**
			f[^ΐŃTCY܂B
			[arg]
			size		: TCYΐB
			zeroClear	: mۂf[^[NA邩ǂB
			[exc]
			std::bad_alloc	: w肵̈mۂłȂB
		**/
		void aResize(ulong count,bool zeroClear=false){
			if(count == _Count) return;
			if(_Buffer){
				if(count!=0){
					T* t = newcheck(static_cast<T*>(realloc(_Buffer,sizeof(T)*count)));
					_Buffer = t;
					if(zeroClear&&(count>_Count)) memset(t+_Count,0,sizeof(T)*(count-_Count));
					_Count = count;
				}
				else{
					free(_Buffer);
					_Buffer = NULL;
					_Count = 0;
				}
			}
			else{
				_Buffer = newcheck(static_cast<T*>(malloc(sizeof(T)*count)));
				_Count = count;
				if(zeroClear) memset(_Buffer,0,sizeof(T)*count);
			}
		}
		/**
			f[^J܂B
		**/
		void clear(){
			if(_Buffer){
				free(_Buffer);
				_Buffer = NULL;
				_Count = 0;
			}
		}

		/**
			w肵f[^畡܂Bnꍇ̓NA܂B
			[arg]
			data	: zB
			count	: z̍ڐB
			[exc]
			std::bad_alloc	: w肵̈mۂłȂB
		**/
		void copy(ptr data,ulong count){
			if(!data||!count){
				clear();
				return;
			}
			aResize(count);
			memcpy(_Buffer,data,sizeof(T)*count);
			_Count = count;
		}

		/**
			w肵f[^畡܂Bnꍇ̓NA܂B
			[arg]
			s	: ̃f[^B
			[exc]
			std::bad_alloc	: w肵̈mۂłȂB
		**/
		void copy(const self& s){
			if(s){
				aResize(s._Count);
				memcpy(_Buffer,s._Buffer,sizeof(T)*_Count);
			}
			else clear();
		}

		/**
			f[^|C^Ԃ܂B
			[return]
			LĂf[^ւ̃|C^B
		**/
		ptr get()const{return _Buffer;}

		/**
			f[^Ԃ܂B
			[return]
			LĂf[^̍ڐB
		**/
		ulong count()const{return _Count;}

		/**
			f[^TCYԂ܂B
			[return]
			LĂf[^̃oCgTCYB
		**/
		ulong size()const{return sizeof(T)*_Count;}

		/**
			p̍ŏ̈ʒu|C^Ԃ܂B
			[return]
			z̍ŏ̈ʒu|C^B
			f[^݂ȂƂ NULL Ԃ܂B
		**/
		ptr begin()const{return _Buffer;}
		/**
			p̍Ō̈ʒu|C^Ԃ܂B
			[return]
			z̍Ō̈ʒu|C^B
			̈ʒüOLĂI[łB
			f[^݂ȂƂ NULL Ԃ܂B
		**/
		ptr end()const{return _Buffer?(_Buffer+_Count):NULL;}
		/**
			tp̍ŏ̈ʒu|C^Ԃ܂B
			[return]
			tz̍ŏ̈ʒu|C^B
			f[^݂ȂƂ NULL Ԃ܂B
		**/
		ptr rbegin()const{return _Buffer?(_Buffer+_Count-1):NULL;}
		/**
			tp̍Ō̈ʒu|C^Ԃ܂B
			[return]
			tz̍Ō̈ʒu|C^B
			̈ʒüオLĂI[łB
			f[^݂ȂƂ NULL Ԃ܂B
		**/
		ptr rend()const{return _Buffer?(_Buffer-1):NULL;}

		/**
			f[^i NULL jԂ܂B
			[return]
			LĂf[^ NULL ̏ꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool empty()const{return !_Buffer;}

		/**
			f[^ւ܂B
			[arg]
			s	: ւf[^B
		**/
		void swap(self& s){
			scpl::swap(_Buffer,s._Buffer);
			scpl::swap(_Count,s._Count);
		}

		/**
			f[^v邩ǂԂ܂B
			[arg]
			s	: ׂf[^B
			[return]
			vꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool equals(const self& s)const{
			if(_Count!=s._Count) return false;
			if((this == &s)||(_Count==0)) return true;
			cptr a=_Buffer,b=s._Buffer,n=_Buffer+_Count;
			for(;a<n;++a,++b){
				if(*a != *b) return false;
			}
			return true;
		}

		/**
			obt@̃|C^CfbNXlԂ܂B
			[arg]
			ptr	: ̃NX̏LĂ邢ꂩ̃f[^w|C^B
			[return]
			LĂf[^̐擪̈ʒuB
			[note]
			̊֐ NULL y ͈͂̃`FbNsĂ܂B
			̂߁ALĂȂꍇA
			n|C^͈͊Ȍꍇ̌ʂ͖`łB
		**/
		ulong toPos(cptr p)const{return static_cast<ulong>(p - _Buffer);}

	private:
		T* _Buffer;
		ulong _Count;

	};

} // namespace scpl
#endif