// 
// Bind.h
// 
// Copyright(C) 2007 Ó
#ifndef _Bind_INCLUDED_
#define _Bind_INCLUDED_

#include "arglist.h"

/**
	֐oCh邽߂̊NXQłB
	NX̌̐ƕ
	oCh֐̈̐Ɩ߂l̗Lw肵܂B
	֐oChNX쐬ꍇ
	"BindGen.h"̊֐gpĂB
**/

namespace scpl{

	class Bind{
	public:
		virtual ~Bind(){}
		virtual void call()=0;
	};
	template <class ResultType>
	class RBind{
	public:
		virtual ~RBind(){}
		virtual ResultType call()=0;
	};
	template <class Class>
	class CBind{
	public:
		CBind(Class* c):_c(c){}
		virtual ~CBind(){}
		void changeClass(Class* c){_c = c;}
		Class* CBind<Class>::getClass()const{return _c;}
	private:
		Class* _c;
	};

	class Bind0vg:public Bind{
	public:
		typedef void (*FuncType)();
		Bind0vg(FuncType f):_f(f){}
		virtual void call(){_f();}
	private:
		FuncType _f;
	};
	template <class Class>
	class Bind0vc:public Bind,public CBind<Class>{
	public:
		typedef void (Class::*FuncType)();
		Bind0vc(FuncType f,Class* c):CBind<Class>(c),_f(f){}
		virtual void call(){(CBind<Class>::getClass()->*_f)();}
	private:
		FuncType _f;
	};

	template <class ResultType>
	class Bind0rg:public RBind<ResultType>{
	public:
		typedef ResultType (*FuncType)();
		Bind0rg(FuncType f):_f(f){}
		virtual ResultType call(){return _f();}
	private:
		FuncType _f;
	};
	template <class Class,class ResultType>
	class Bind0rc:public RBind<ResultType>,public CBind<Class>{
	public:
		typedef ResultType (Class::*FuncType)();
		Bind0rc(FuncType f,Class* c):CBind<Class>(c),_f(f){}
		virtual ResultType call(){return (CBind<Class>::getClass()->*_f)();}
	private:
		FuncType _f;
	};

/*
	L͈t̃oChNX`̂Ɏw肵Ă}NQB
*/

#define ARG1C void changeA1(A1 a1){_a1 = a1;} A1 getA1(){return _a1;}
#define ARG2C ARG1C void changeA2(A2 a2){_a2 = a2;} A2 getA2(){return _a2;}
#define ARG3C ARG2C void changeA3(A3 a3){_a3 = a3;} A3 getA3(){return _a3;}
#define ARG4C ARG3C void changeA4(A4 a4){_a4 = a4;} A4 getA4(){return _a4;}
#define ARG5C ARG4C void changeA5(A5 a5){_a5 = a5;} A5 getA5(){return _a5;}
#define ARG6C ARG5C void changeA6(A6 a6){_a6 = a6;} A6 getA6(){return _a6;}

#define ARG1M A1 _a1;
#define ARG2M ARG1M A2 _a2;
#define ARG3M ARG2M A3 _a3;
#define ARG4M ARG3M A4 _a4;
#define ARG5M ARG4M A5 _a5;
#define ARG6M ARG5M A6 _a6;

#define BINDCALL_G1 _f(Bind1<ARG1L1>::getA1())
#define BINDCALL_G2 _f(Bind2<ARG2L1>::getA1(),Bind2<ARG2L1>::getA2())
#define BINDCALL_G3 _f(Bind3<ARG3L1>::getA1(),Bind3<ARG3L1>::getA2(),Bind3<ARG3L1>::getA3())
#define BINDCALL_G4 _f(Bind4<ARG4L1>::getA1(),Bind4<ARG4L1>::getA2(),Bind4<ARG4L1>::getA3(),Bind4<ARG4L1>::getA4())
#define BINDCALL_G5 _f(Bind5<ARG5L1>::getA1(),Bind5<ARG5L1>::getA2(),Bind5<ARG5L1>::getA3(),Bind5<ARG5L1>::getA4(),Bind5<ARG5L1>::getA5())
#define BINDCALL_G6 _f(Bind6<ARG6L1>::getA1(),Bind6<ARG6L1>::getA2(),Bind6<ARG6L1>::getA3(),Bind6<ARG6L1>::getA4(),Bind6<ARG6L1>::getA5(),Bind6<ARG6L1>::getA6())
#define BINDCALL_C1 (CBind<Class>::getClass()->*_f)(Bind1<ARG1L1>::getA1())
#define BINDCALL_C2 (CBind<Class>::getClass()->*_f)(Bind2<ARG2L1>::getA1(),Bind2<ARG2L1>::getA2())
#define BINDCALL_C3 (CBind<Class>::getClass()->*_f)(Bind3<ARG3L1>::getA1(),Bind3<ARG3L1>::getA2(),Bind3<ARG3L1>::getA3())
#define BINDCALL_C4 (CBind<Class>::getClass()->*_f)(Bind4<ARG4L1>::getA1(),Bind4<ARG4L1>::getA2(),Bind4<ARG4L1>::getA3(),Bind4<ARG4L1>::getA4())
#define BINDCALL_C5 (CBind<Class>::getClass()->*_f)(Bind5<ARG5L1>::getA1(),Bind5<ARG5L1>::getA2(),Bind5<ARG5L1>::getA3(),Bind5<ARG5L1>::getA4(),Bind5<ARG5L1>::getA5())
#define BINDCALL_C6 (CBind<Class>::getClass()->*_f)(Bind6<ARG6L1>::getA1(),Bind6<ARG6L1>::getA2(),Bind6<ARG6L1>::getA3(),Bind6<ARG6L1>::getA4(),Bind6<ARG6L1>::getA5(),Bind6<ARG6L1>::getA6())

#define BIND_DEF(N,TL,AL1,AL2,AL3,AL4,AC,AM)\
	template <TL> class Bind##N{\
	public:\
		Bind##N(AL2):AL4{}\
		virtual ~Bind##N(){}\
		AC\
	private:\
		AM\
	};\
	template <TL> class Bind##N##vg:public Bind,public Bind##N<AL1>{\
	public:\
		typedef void (*FuncType)(AL1);\
		Bind##N##vg(FuncType f,AL2):Bind##N<AL1>(AL3),_f(f){}\
		virtual void call(){BINDCALL_G##N;}\
	private:\
		FuncType _f;\
	};\
	template <class Class,TL>\
	class Bind##N##vc:public Bind,public CBind<Class>,public Bind##N<AL1>{\
	public:\
		typedef void (Class::*FuncType)(AL1);\
		Bind##N##vc(FuncType f,Class* c,AL2):CBind<Class>(c),Bind##N<AL1>(AL3),_f(f){}\
		virtual void call(){BINDCALL_C##N;}\
	private:\
		FuncType _f;\
	};\
	template <class ResultType,TL>\
	class Bind##N##rg:public RBind<ResultType>,public Bind##N<AL1>{\
	public:\
		typedef ResultType (*FuncType)(AL1);\
		Bind##N##rg(FuncType f,AL2):Bind##N<AL1>(AL3),_f(f){}\
		virtual ResultType call(){return BINDCALL_G##N;}\
	private:\
		FuncType _f;\
	};\
	template <class Class,class ResultType,TL>\
	class Bind##N##rc:public RBind<ResultType>,public CBind<Class>,public Bind##N<AL1>{\
	public:\
		typedef ResultType (Class::*FuncType)(AL1);\
		Bind##N##rc(FuncType f,Class* c,AL2):CBind<Class>(c),Bind##N<AL1>(AL3),_f(f){}\
		virtual ResultType call(){return BINDCALL_C##N;}\
	private:\
		FuncType _f;\
	}

	BIND_DEF(1,TMP1L,ARG1L1,ARG1L2,ARG1L3,ARG1L4,ARG1C,ARG1M);
	BIND_DEF(2,TMP2L,ARG2L1,ARG2L2,ARG2L3,ARG2L4,ARG2C,ARG2M);
	BIND_DEF(3,TMP3L,ARG3L1,ARG3L2,ARG3L3,ARG3L4,ARG3C,ARG3M);
	BIND_DEF(4,TMP4L,ARG4L1,ARG4L2,ARG4L3,ARG4L4,ARG4C,ARG4M);
	BIND_DEF(5,TMP5L,ARG5L1,ARG5L2,ARG5L3,ARG5L4,ARG5C,ARG5M);
	BIND_DEF(6,TMP6L,ARG6L1,ARG6L2,ARG6L3,ARG6L4,ARG6C,ARG6M);

// Œ`ׂẴNX`p}N̒`
#undef ARG1C
#undef ARG2C
#undef ARG3C
#undef ARG4C
#undef ARG5C
#undef ARG6C
#undef ARG1M
#undef ARG2M
#undef ARG3M
#undef ARG4M
#undef ARG5M
#undef ARG6M
#undef B_C
#undef BINDCALL_G1
#undef BINDCALL_G2
#undef BINDCALL_G3
#undef BINDCALL_G4
#undef BINDCALL_G5
#undef BINDCALL_G6
#undef BINDCALL_C1
#undef BINDCALL_C2
#undef BINDCALL_C3
#undef BINDCALL_C4
#undef BINDCALL_C5
#undef BINDCALL_C6
#undef BIND_DEF

} // namespace scpl
#include "BindGen.h"
#endif
