#include "stdafx.h"
#include "test_funcs.h"
#include <scpl/CriticalSection.h>
#include <scpl/Thread.h>
#include <scpl/auto_ptr.h>

using namespace scpl;

static ulong counter = 0;
static CriticalSection mcs;

void inc(){
	mcs.enter();
	++counter;
	Sleep(100);
	mcs.leave();
}

void sub(void*){
	inc();
	inc();
	inc();
	inc();
	inc();
}

void test_CS(){
	auto_ptr<Thread> ath(beginThread(sub));
	DWORD tick = GetTickCount();

	Thread& th = *ath;
	SUT_CHECK(th);
	inc();
	inc();
	inc();
	inc();
	inc();
	inc();
	SUT_CHECK_EQUALS(Int,counter,11);
	SUT_CHECK_EQAB(Int,1100,GetTickCount()-tick);
	SUT_CHECK(!th);
}