#include "stdafx.h"
#include "test_funcs.h"
#include <scpl/Bind.h>
#include <scpl/auto_ptr.h>

using namespace scpl;

static int	cnt = 0;

static void call0v(){cnt = 10;}
static void call1v(int i1){cnt = i1;}
static void call2v(int i1,int i2){cnt = i1 - i2;}
static void call3v(int i1,int i2,int i3){cnt = i1 - i2 * i3;}
static void call4v(int i1,int i2,int i3,int i4){cnt = i1 - i2 * i3 / i4;}
static void call5v(int i1,int i2,int i3,int i4,int i5){cnt = i1 - i2 * i3 / i4 * i5;}
static void call6v(int i1,int i2,int i3,int i4,int i5,int i6){cnt = i1 - i2 * i3 / i4 * (i5 - i6);}
static int call0r(){return 9;}
static int call1r(int i1){return i1;}
static int call2r(int i1,int i2){return i1 - i2;}
static int call3r(int i1,int i2,int i3){return i1 - i2 * i3;}
static int call4r(int i1,int i2,int i3,int i4){return i1 - i2 * i3 / i4;}
static int call5r(int i1,int i2,int i3,int i4,int i5){return i1 - i2 * i3 / i4 * i5;}
static int call6r(int i1,int i2,int i3,int i4,int i5,int i6){return i1 - i2 * i3 / i4 * (i5 - i6);}

class BindTest{
public:
	BindTest():ret(0){}

	void call0v(){ret = 8;}
	void call1v(int i1){ret = i1;}
	void call2v(int i1,int i2){ret = i1 + i2;}
	void call3v(int i1,int i2,int i3){ret = i1 + i2 - i3;}
	void call4v(int i1,int i2,int i3,int i4){ret = i1 + i2 - i3 * i4;}
	void call5v(int i1,int i2,int i3,int i4,int i5){ret = i1 + i2 - i3 * i4 / i5;}
	void call6v(int i1,int i2,int i3,int i4,int i5,int i6){ret = i1 + i2 - i3 * i4 / i5 - i6;}
	int call0r(){return 7;}
	int call1r(int i1){return i1;}
	int call2r(int i1,int i2){return i1 + i2;}
	int call3r(int i1,int i2,int i3){return i1 + i2 - i3;}
	int call4r(int i1,int i2,int i3,int i4){return i1 + i2 - i3 * i4;}
	int call5r(int i1,int i2,int i3,int i4,int i5){return i1 + i2 - i3 * i4 / i5;}
	int call6r(int i1,int i2,int i3,int i4,int i5,int i6){return i1 + i2 - i3 * i4 / i5 - i6;}
	
	int ret;
};


void test_Bind(){
	auto_ptr<BindTest> bt(new BindTest());

	auto_ptr<Bind0vg> b0vg(createBind0vg(call0v));
	auto_ptr<Bind1vg<int> > b1vg(createBind1vg(call1v,20));
	auto_ptr<Bind2vg<int,int> > b2vg(createBind2vg(call2v,10,9));
	auto_ptr<Bind3vg<int,int,int> > b3vg(createBind3vg(call3v,2,2,9));
	auto_ptr<Bind4vg<int,int,int,int> > b4vg(createBind4vg(call4v,4,4,5,4));
	auto_ptr<Bind5vg<int,int,int,int,int> > b5vg(createBind5vg(call5v,6,3,1,3,3));
	auto_ptr<Bind6vg<int,int,int,int,int,int> > b6vg(createBind6vg(call6v,1,3,5,3,4,4));

	auto_ptr<Bind0rg<int>> b0rg(createBind0rg(call0r));
	auto_ptr<Bind1rg<int,int> > b1rg(createBind1rg(call1r,20));
	auto_ptr<Bind2rg<int,int,int> > b2rg(createBind2rg(call2r,10,9));
	auto_ptr<Bind3rg<int,int,int,int> > b3rg(createBind3rg(call3r,2,2,9));
	auto_ptr<Bind4rg<int,int,int,int,int> > b4rg(createBind4rg(call4r,4,4,5,4));
	auto_ptr<Bind5rg<int,int,int,int,int,int> > b5rg(createBind5rg(call5r,6,3,1,3,3));
	auto_ptr<Bind6rg<int,int,int,int,int,int,int> > b6rg(createBind6rg(call6r,1,3,5,3,4,4));

	auto_ptr<Bind0vc<BindTest> > b0vc(createBind0vc(&BindTest::call0v,~bt));
	auto_ptr<Bind1vc<BindTest,int> > b1vc(createBind1vc(&BindTest::call1v,~bt,20));
	auto_ptr<Bind2vc<BindTest,int,int> > b2vc(createBind2vc(&BindTest::call2v,~bt,10,9));
	auto_ptr<Bind3vc<BindTest,int,int,int> > b3vc(createBind3vc(&BindTest::call3v,~bt,2,2,9));
	auto_ptr<Bind4vc<BindTest,int,int,int,int> > b4vc(createBind4vc(&BindTest::call4v,~bt,4,4,5,4));
	auto_ptr<Bind5vc<BindTest,int,int,int,int,int> > b5vc(createBind5vc(&BindTest::call5v,~bt,6,3,1,3,3));
	auto_ptr<Bind6vc<BindTest,int,int,int,int,int,int> > b6vc(createBind6vc(&BindTest::call6v,~bt,1,3,5,3,3,4));

	auto_ptr<Bind0rc<BindTest,int> > b0rc(createBind0rc(&BindTest::call0r,~bt));
	auto_ptr<Bind1rc<BindTest,int,int> > b1rc(createBind1rc(&BindTest::call1r,~bt,20));
	auto_ptr<Bind2rc<BindTest,int,int,int> > b2rc(createBind2rc(&BindTest::call2r,~bt,10,9));
	auto_ptr<Bind3rc<BindTest,int,int,int,int> > b3rc(createBind3rc(&BindTest::call3r,~bt,2,2,9));
	auto_ptr<Bind4rc<BindTest,int,int,int,int,int> > b4rc(createBind4rc(&BindTest::call4r,~bt,4,4,5,4));
	auto_ptr<Bind5rc<BindTest,int,int,int,int,int,int> > b5rc(createBind5rc(&BindTest::call5r,~bt,6,3,1,3,3));
	auto_ptr<Bind6rc<BindTest,int,int,int,int,int,int,int> > b6rc(createBind6rc(&BindTest::call6r,~bt,1,3,5,3,3,4));

	b0vg->call();SUT_ASSERT_EQUALS(Int,cnt,10);
	b1vg->call();SUT_ASSERT_EQUALS(Int,cnt,20);
	b2vg->call();SUT_ASSERT_EQUALS(Int,cnt,1);
	b3vg->call();SUT_ASSERT_EQUALS(Int,cnt,-16);
	b4vg->call();SUT_ASSERT_EQUALS(Int,cnt,-1);
	b5vg->call();SUT_ASSERT_EQUALS(Int,cnt,3);
	b6vg->call();SUT_ASSERT_EQUALS(Int,cnt,1);

	SUT_ASSERT_EQUALS(Int,b0rg->call(),9);
	SUT_ASSERT_EQUALS(Int,b1rg->call(),20);
	SUT_ASSERT_EQUALS(Int,b2rg->call(),1);
	SUT_ASSERT_EQUALS(Int,b3rg->call(),-16);
	SUT_ASSERT_EQUALS(Int,b4rg->call(),-1);
	SUT_ASSERT_EQUALS(Int,b5rg->call(),3);
	SUT_ASSERT_EQUALS(Int,b6rg->call(),1);

	b0vc->call();SUT_ASSERT_EQUALS(Int,bt->ret,8);
	b1vc->call();SUT_ASSERT_EQUALS(Int,bt->ret,20);
	b2vc->call();SUT_ASSERT_EQUALS(Int,bt->ret,19);
	b3vc->call();SUT_ASSERT_EQUALS(Int,bt->ret,-5);
	b4vc->call();SUT_ASSERT_EQUALS(Int,bt->ret,-12);
	b5vc->call();SUT_ASSERT_EQUALS(Int,bt->ret,8);
	b6vc->call();SUT_ASSERT_EQUALS(Int,bt->ret,-5);

	SUT_ASSERT_EQUALS(Int,b0rc->call(),7);
	SUT_ASSERT_EQUALS(Int,b1rc->call(),20);
	SUT_ASSERT_EQUALS(Int,b2rc->call(),19);
	SUT_ASSERT_EQUALS(Int,b3rc->call(),-5);
	SUT_ASSERT_EQUALS(Int,b4rc->call(),-12);
	SUT_ASSERT_EQUALS(Int,b5rc->call(),8);
	SUT_ASSERT_EQUALS(Int,b6rc->call(),-5);

}
