// 
// Container.h
// 
// Copyright(C) 2007 Mitsunagi

#ifndef _Container_INCLUDED_
#define _Container_INCLUDED_
#include "Buffer.h"
#include "FBuffer.h"
#include <new>

/**
	Rei̊NXłB
	̃NX͊eReiNX̌pƂȂ܂B
	ʏ킱̃wb_̊֐NX͒ڎgp܂B
**/

namespace scpl{

#define TDEF()\
		typedef T&			ind;\
		typedef const T&	cind;\
		typedef T*			ptr;\
		typedef const T*	cptr

	TMP class IContainer{
	public:
		TDEF();

		virtual ~IContainer(){}

		virtual bool empty()const=0;
		virtual ulong count()const=0;
		virtual ulong capacity()const=0;

		virtual void copy(cptr data,ulong c)=0;

		virtual bool equals(cptr p,ulong c)const=0;

	};

	TMP class IContainer_accessable : public IContainer<T>{
	public:

		virtual ~IContainer_accessable(){}

		virtual ptr begin()=0;
		virtual ptr end()=0;
		virtual ptr rbegin()=0;
		virtual ptr rend()=0;
		virtual cptr begin()const=0;
		virtual cptr end()const=0;
		virtual cptr rbegin()const=0;
		virtual cptr rend()const=0;

	};

	TMP bool _conatiner_equals(const T* p,ulong c,const T* mp,ulong mc){
		if(p != mp){
			if(c != mc) return false;
			const T *it=mp,*end=mp+mc;
			for(;it<end;++it,++p){
				if(*it != *p) return false;
			}
		}
		return true;
	}
	TMP bool _conatiner_equals_n(const T* p,ulong c,const T* mp,ulong mc){
		if(p != mp){
			if(c != mc) return false;
			return memcmp(p,mp,c*sizeof(T)) == 0;
		}
		return true;
	}

	TMP long _container_insert(const T* data,ulong c,ulong index,Buffer<T>& buffer,ulong& useCount){
		if(useCount+c > buffer.count()) buffer.aResize(useCount+c);
		T* t = uinsert(buffer.begin(),buffer.count(),index,c);
		const T* d = data;
		for(T* e=t+c;t<e;++t,++d) ::new(t) T(*d);
		useCount += c;
		return index;
	}
	BUFTMP long _container_insert_fixed(const T* data,ulong c,ulong index,FBuffer<T,C>& buffer,ulong& useCount){
		if(useCount+c > C) THROW_FILLED_CAPACITY();
		T* t = uinsert(buffer.get(),C,index,c);
		const T* d = data;
		for(T* e=t+c;t<e;++t,++d) ::new(t) T(*d);
		useCount += c;
		return index;
	}
	TMP long _container_insert_n(const T* data,ulong c,ulong index,Buffer<T>& buffer,ulong& useCount){
		if(useCount+c > buffer.count()) buffer.aResize(useCount+c);
		T* t = uinsert(buffer.begin(),buffer.count(),index,c);
		memcpy(t,data,c*sizeof(T));
		useCount += c;
		return index;
	}
	BUFTMP long _container_insert_fixed_n(const T* data,ulong c,ulong index,FBuffer<T,C>& buffer,ulong& useCount){
		if(useCount+c > C) THROW_FILLED_CAPACITY();
		T* t = uinsert(buffer.get(),C,index,c);
		memcpy(t,data,c*sizeof(T));
		useCount += c;
		return index;
	}

	TMP void _container_copy(const T* data,ulong c,Buffer<T>& buffer,ulong& useCount){
		if(c > buffer.count()) buffer.aResize(c);
		T* t = buffer.begin();
		const T* d = data;
		for(T* e=buffer.begin()+c;t<e;++t,++d) ::new(t) T(*d);
		useCount = c;
	}
	BUFTMP void _container_copy_fixed(const T* data,ulong c,FBuffer<T,C>& buffer,ulong& useCount){
		if(c > C) THROW_FILLED_CAPACITY();
		T* t = buffer;
		const T* d = data;
		for(T* e=buffer+c;t<e;++t,++d) ::new(t) T(*d);
		useCount = c;
	}
	TMP void _container_copy_n(const T* data,ulong c,Buffer<T>& buffer,ulong& useCount){
		if(c > buffer.count()) buffer.aResize(c);
		memcpy(buffer.begin(),data,c*sizeof(T));
		useCount = c;
	}
	BUFTMP void _container_copy_fixed_n(const T* data,ulong c,FBuffer<T,C>& buffer,ulong& useCount){
		if(c > C) THROW_FILLED_CAPACITY();
		memcpy(buffer,data,c*sizeof(T));
		useCount = c;
	}


	TMP void _container_erage(const T* l,const T* r,Buffer<T>& buffer,ulong& useCount){
		if(useCount == 0) THROW_DO_NOT_HAVE_DATA();
		if(l >= r) THROW_MUST_BE_L_AVOBE_R();
		if((r > buffer.begin()+useCount)||(l < buffer.begin())) THROW_OUT_OF_RANGE();
		for(T* t = const_cast<T*>(l);t<r;++t) t->~T();
		ulong s = static_cast<ulong>(r-l);
		uremove(buffer.begin(),useCount,static_cast<ulong>(l-buffer.begin()),s);
		useCount -= s;
	}
	BUFTMP void _container_erage_fixed(const T* l,const T* r,FBuffer<T,C>& buffer,ulong& useCount){
		if(useCount == 0) THROW_DO_NOT_HAVE_DATA();
		if(l >= r) THROW_MUST_BE_L_AVOBE_R();
		if((r > buffer.begin()+useCount)||(l < buffer.begin())) THROW_OUT_OF_RANGE();
		for(T* t = const_cast<T*>(l);t<r;++t) t->~T();
		ulong s = static_cast<ulong>(r-l);
		uremove(buffer.get(),useCount,static_cast<ulong>(l-buffer),s);
		useCount -= s;
	}
	TMP void _container_erage_n(const T* l,const T* r,Buffer<T>& buffer,ulong& useCount){
		if(useCount == 0) THROW_DO_NOT_HAVE_DATA();
		if(l >= r) THROW_MUST_BE_L_AVOBE_R();
		if((r > buffer.begin()+useCount)||(l < buffer.begin())) THROW_OUT_OF_RANGE();
		ulong s = static_cast<ulong>(r-l);
		uremove(buffer.begin(),useCount,static_cast<ulong>(l-buffer.begin()),s);
		useCount -= s;
	}
	BUFTMP void _container_erage_fixed_n(const T* l,const T* r,FBuffer<T,C>& buffer,ulong& useCount){
		if(useCount == 0) THROW_DO_NOT_HAVE_DATA();
		if(l >= r) THROW_MUST_BE_L_AVOBE_R();
		if((r > buffer.begin()+useCount)||(l < buffer.begin())) THROW_OUT_OF_RANGE();
		ulong s = static_cast<ulong>(r-l);
		uremove(buffer.get(),useCount,static_cast<ulong>(l-buffer),s);
		useCount -= s;
	}

	TMP void _container_clear(Buffer<T>& buffer,ulong& useCount){
		if(useCount){
			for(T *it=buffer.begin(),*e=buffer.begin()+useCount;it<e;++it) it->~T();
			useCount = 0;
		}
	}
	BUFTMP void _container_clear_fixed(FBuffer<T,C>& buffer,ulong& useCount){
		if(useCount){
			for(T *it=buffer,*e=buffer+useCount;it<e;++it) it->~T();
			useCount = 0;
		}
	}

	TMP void _container_swap(Buffer<T>& lb,ulong& luc,Buffer<T>& rb,ulong& ruc){
		lb.swap(rb);
		scpl::swap(luc,ruc);
	}
	BUFTMP void _container_swap_fixed(FBuffer<T,C>& lb,ulong& luc,FBuffer<T,C>& rb,ulong& ruc){
		lb.swap(rb);
		scpl::swap(luc,ruc);
	}

} // namespace scpl
#endif // _Container_INCLUDED_