#include "stdafx.h"
#include "test_funcs.h"
#include <scpl/Stack.h>
#include "CountStruct.h"

using namespace scpl;

typedef CStack<CountStruct>		CSCS;
typedef DStack<double>			DDS;
typedef CFStack<CountStruct,3>	CSCFS;
typedef DFStack<long,3>			LDFS;

TMP inline void check(const IStack<T>* lq,ulong cnt,ulong cap){
	if(cnt == 0) SUT_ASSERT(lq->empty());
	else SUT_ASSERT(!lq->empty());
	SUT_ASSERT_EQUALS(Int,lq->count(),cnt);
	SUT_ASSERT_EQUALS(Int,lq->capacity(),cap);
}

TMP inline void checkPop(IStack<T>* lq,const T& e,bool ok){
	try{
		T t = lq->get();
		SUT_ASSERT_EQUALS(Int,t,e);
		lq->pop();
		if(!ok) SUT_ASSERT(false);
	}catch(std::runtime_error){if(ok) SUT_ASSERT(false);}
}
template<> inline void checkPop(IStack<CountStruct>* lq,const CountStruct& e,bool ok){
	try{
		CountStruct t(lq->get());
		SUT_ASSERT_EQUALS(Int,t.i,e.i);
		lq->pop();
		if(!ok) SUT_ASSERT(false);
	}catch(std::runtime_error){if(ok) SUT_ASSERT(false);}
}
template<> inline void checkPop(IStack<double>* lq,const double& e,bool ok){
	try{
		double t = lq->get();
		SUT_ASSERT_EQUALS(Dbl,t,e);
		lq->pop();
		if(!ok) SUT_ASSERT(false);
	}catch(std::runtime_error){if(ok) SUT_ASSERT(false);}
}
TMP inline void checkPush(IStack<T>* lq,const T& e,bool ok){
	try{
		lq->push(e);
		if(!ok) SUT_ASSERT(false);
	}catch(std::runtime_error){if(ok) SUT_ASSERT(false);}
}

#define flow_(F) try{F;}catch(scpl::sut::sut_assert s){printf("(In Line:%5i)\n",__LINE__);throw s;}

void test_CStack(){
	{
		CountStruct cs[5];
		CSCS a;
		CSCS b(3);

		flow_(check(&a,0,0));
		flow_(check(&b,0,3));

		flow_(checkPush(&a,cs[0],true));
		flow_(check(&a,1,1));
		flow_(checkPush(&b,cs[0],true));
		flow_(check(&b,1,3));
		flow_(checkPush(&b,cs[1],true));
		flow_(checkPush(&b,cs[2],true));
		flow_(check(&b,3,3));
		flow_(checkPush(&b,cs[3],true));
		flow_(check(&b,4,4));
		SUT_CHECK_EQUALS(Int,CountStruct::getCount(),10);
		SUT_ASSERT(a != b);

		a.adjust(3);
		flow_(check(&a,1,4));
		flow_(checkPush(&a,cs[1],true));
		flow_(checkPush(&a,cs[2],true));
		flow_(check(&a,3,4));
		flow_(checkPush(&a,cs[3],true));
		flow_(check(&b,4,4));
		SUT_CHECK_EQUALS(Int,CountStruct::getCount(),13);

		flow_(checkPop(&a,cs[3],true));
		flow_(checkPop(&a,cs[2],true));
		flow_(checkPop(&a,cs[1],true));
		flow_(checkPop(&a,cs[0],true));
		flow_(checkPop(&a,cs[0],false));
		
		SUT_CHECK_EQUALS(Int,CountStruct::getCount(),9);

		SUT_ASSERT(a != b);
		a = b;
		SUT_CHECK_EQUALS(Int,CountStruct::getCount(),13);

		flow_(checkPop(&a,cs[3],true));
		flow_(checkPop(&a,cs[2],true));
		flow_(checkPop(&a,cs[1],true));
		flow_(checkPop(&a,cs[0],true));
		flow_(checkPop(&a,cs[0],false));
		
		SUT_CHECK_EQUALS(Int,CountStruct::getCount(),9);

		flow_(check(&a,0,4));
		a.adjust(8);
		flow_(check(&a,0,8));

		SUT_CHECK(a != b);
		a = b;
		SUT_CHECK(a == b);

	}
	SUT_CHECK_EQUALS(Int,CountStruct::getCount(),0);
}
void test_DStack(){
	{
		double cs[5]={9.254,1.234,8.4,0.09983,88.8};
		DDS a;
		DDS b(3);

		flow_(check(&a,0,0));
		flow_(check(&b,0,3));

		flow_(checkPush(&a,cs[0],true));
		flow_(check(&a,1,1));
		flow_(checkPush(&b,cs[0],true));
		flow_(check(&b,1,3));
		flow_(checkPush(&b,cs[1],true));
		flow_(checkPush(&b,cs[2],true));
		flow_(check(&b,3,3));
		flow_(checkPush(&b,cs[3],true));
		flow_(check(&b,4,4));

		a.adjust(3);
		flow_(check(&a,1,4));
		flow_(checkPush(&a,cs[1],true));
		flow_(checkPush(&a,cs[2],true));
		flow_(check(&a,3,4));
		flow_(checkPush(&a,cs[3],true));
		flow_(check(&b,4,4));

		flow_(checkPop(&a,cs[3],true));
		flow_(checkPop(&a,cs[2],true));
		flow_(checkPop(&a,cs[1],true));
		flow_(checkPop(&a,cs[0],true));
		flow_(checkPop(&a,cs[0],false));
		
		a = b;

		flow_(checkPop(&a,cs[3],true));
		flow_(checkPop(&a,cs[2],true));
		flow_(checkPop(&a,cs[1],true));
		flow_(checkPop(&a,cs[0],true));
		flow_(checkPop(&a,cs[0],false));
		
		flow_(check(&a,0,4));
		a.adjust(8);
		flow_(check(&a,0,8));

		SUT_CHECK(a != b);
		a = b;
		SUT_CHECK(a == b);

	}
	{
		CountStruct cs;
		DStack<CountStruct> q(3);
		flow_(checkPush(&q,cs,true));
		flow_(checkPush(&q,cs,true));
		flow_(checkPush(&q,cs,true));
		flow_(checkPush(&q,cs,true));
	}
	SUT_CHECK_EQUALS(Int,CountStruct::getCount(),0);
	CountStruct::reset();
}
void test_CFStack(){
	{
		CountStruct cs[5];
		CSCFS a;
		CSCFS b;

		flow_(check(&a,0,3));
		flow_(check(&b,0,3));

		flow_(checkPush(&a,cs[0],true));
		flow_(check(&a,1,3));
		flow_(checkPush(&b,cs[0],true));
		flow_(check(&b,1,3));
		flow_(checkPush(&b,cs[1],true));
		flow_(checkPush(&b,cs[2],true));
		flow_(check(&b,3,3));
		flow_(checkPush(&b,cs[3],false));
		flow_(check(&b,3,3));
		SUT_CHECK_EQUALS(Int,CountStruct::getCount(),9);

		flow_(checkPush(&a,cs[1],true));
		flow_(checkPush(&a,cs[2],true));
		flow_(check(&a,3,3));
		flow_(checkPush(&a,cs[3],false));
		flow_(check(&b,3,3));
		SUT_CHECK_EQUALS(Int,CountStruct::getCount(),11);

		flow_(checkPop(&a,cs[2],true));
		flow_(checkPop(&a,cs[1],true));
		flow_(checkPop(&a,cs[0],true));
		flow_(checkPop(&a,cs[0],false));
		
		SUT_CHECK_EQUALS(Int,CountStruct::getCount(),8);

		SUT_ASSERT(a != b);
		a = b;
		SUT_CHECK_EQUALS(Int,CountStruct::getCount(),11);
		SUT_ASSERT(a == b);

		flow_(checkPop(&a,cs[2],true));
		flow_(checkPop(&a,cs[1],true));
		flow_(checkPop(&a,cs[0],true));
		flow_(checkPop(&a,cs[0],false));
		
		SUT_CHECK_EQUALS(Int,CountStruct::getCount(),8);

		flow_(check(&a,0,3));

		SUT_CHECK(a != b);
		a = b;
		SUT_CHECK(a == b);

	}
	SUT_CHECK_EQUALS(Int,CountStruct::getCount(),0);
}
void test_DFStack(){
	{
		long cs[5]={234,4856,23,4568,6432};
		LDFS a;
		LDFS b;

		flow_(check(&a,0,3));
		flow_(check(&b,0,3));

		flow_(checkPush(&a,cs[0],true));
		flow_(check(&a,1,3));
		flow_(checkPush(&b,cs[0],true));
		flow_(check(&b,1,3));
		flow_(checkPush(&b,cs[1],true));
		flow_(checkPush(&b,cs[2],true));
		flow_(check(&b,3,3));
		flow_(checkPush(&b,cs[3],false));
		flow_(check(&b,3,3));

		flow_(checkPush(&a,cs[1],true));
		flow_(checkPush(&a,cs[2],true));
		flow_(check(&a,3,3));
		flow_(checkPush(&a,cs[3],false));
		flow_(check(&b,3,3));

		flow_(checkPop(&a,cs[2],true));
		flow_(checkPop(&a,cs[1],true));
		flow_(checkPop(&a,cs[0],true));
		flow_(checkPop(&a,cs[0],false));

		a = b;

		flow_(checkPop(&a,cs[2],true));
		flow_(checkPop(&a,cs[1],true));
		flow_(checkPop(&a,cs[0],true));
		flow_(checkPop(&a,cs[0],false));

		flow_(check(&a,0,3));

		SUT_CHECK(a != b);
		a = b;
		SUT_CHECK(a == b);

	}
	{
		CountStruct cs;
		DFStack<CountStruct,3> q;
		flow_(checkPush(&q,cs,true));
		flow_(checkPush(&q,cs,true));
		flow_(checkPush(&q,cs,true));
		flow_(checkPush(&q,cs,false));
	}
	SUT_CHECK_EQUALS(Int,CountStruct::getCount(),0);
	CountStruct::reset();
}
