#include "stdafx.h"
#include "test_funcs.h"
#include <scpl/Map.h>
#include "CountStruct.h"

using namespace scpl;

typedef CMap<char,long> CLMap;
typedef DMap<char,long> DLMap;
typedef CFMap<char,long,10> CFLMap;
typedef DFMap<char,long,10> DFLMap;

MAPTMP inline void check(const IMap<Key,Val>* m,ulong cnt,ulong cap){
	if(cnt == 0) SUT_ASSERT(m->empty());
	else SUT_ASSERT(!m->empty());
	SUT_ASSERT_EQUALS(Int,m->count(),cnt);
	SUT_ASSERT_EQUALS(Int,m->capacity(),cap);
}

MAPTMP inline void check_val(const IMap<Key,Val>* m,char k,long v,bool ok){
	try{
		SUT_ASSERT_EQUALS(Int,m->at(k),v);
		if(!ok) SUT_ASSERT(false);
	}
	catch(std::invalid_argument){if(ok) SUT_ASSERT(false);}
}

#define flow_(F) try{F;}catch(scpl::sut::sut_assert s){printf("(In Line:%5i)\n",__LINE__);throw s;}

void test_CMap(){
	CLMap a;

	flow_(check(&a,0,0));

	a.adjust(1);
	flow_(check(&a,0,1));

	a['9'] = 9;
	flow_(check(&a,1,1));
	a['8'] = 8;
	a['7'] = 7;
	a['6'] = 6;
	a['5'] = 5;
	flow_(check(&a,5,5));

	a.set('4',4);
	a.set('3',3);
	a.set('2',2);
	a.set('1',1);
	flow_(check(&a,9,9));
	a.adjust(1);
	flow_(check(&a,9,10));
	a.set('0');
	flow_(check(&a,10,10));
	a['0'] = 0;
	flow_(check(&a,10,10));

	flow_(check_val(&a,'0',0,true));
	flow_(check_val(&a,'1',1,true));
	flow_(check_val(&a,'2',2,true));
	flow_(check_val(&a,'3',3,true));
	flow_(check_val(&a,'4',4,true));
	flow_(check_val(&a,'5',5,true));
	flow_(check_val(&a,'6',6,true));
	flow_(check_val(&a,'7',7,true));
	flow_(check_val(&a,'8',8,true));
	flow_(check_val(&a,'9',9,true));
	flow_(check(&a,10,10));

	CLMap b(a);

	SUT_ASSERT(a == b);

	flow_(check(&b,10,10));
	b.clear();
	flow_(check(&b,0,10));
	b.adjust(0);
	flow_(check(&b,0,0));
	b.swap(a);
	flow_(check(&a,0,0));
	flow_(check(&b,10,10));

	b.remove('5');
	b.remove('8');

	flow_(check_val(&b,'0',0,true));
	flow_(check_val(&b,'1',1,true));
	flow_(check_val(&b,'2',2,true));
	flow_(check_val(&b,'3',3,true));
	flow_(check_val(&b,'4',4,true));
	flow_(check_val(&b,'5',5,false));
	flow_(check_val(&b,'6',6,true));
	flow_(check_val(&b,'7',7,true));
	flow_(check_val(&b,'8',8,false));
	flow_(check_val(&b,'9',9,true));

	{
		CMap<int,CountStruct> CSMap(2);
		CSMap[0] = CountStruct();
		CSMap.set(9);
		SUT_ASSERT_EQUALS(Int,CountStruct::getCount(),2);
	}
	SUT_ASSERT_EQUALS(Int,CountStruct::getCount(),0);
}
void test_DMap(){
	CLMap a;

	flow_(check(&a,0,0));

	a.adjust(1);
	flow_(check(&a,0,1));

	a['9'] = 9;
	flow_(check(&a,1,1));
	a['8'] = 8;
	a['7'] = 7;
	a['6'] = 6;
	a['5'] = 5;
	flow_(check(&a,5,5));

	a.set('4',4);
	a.set('3',3);
	a.set('2',2);
	a.set('1',1);
	flow_(check(&a,9,9));
	a.adjust(1);
	flow_(check(&a,9,10));
	a.set('0');
	flow_(check(&a,10,10));
	a['0'] = 0;
	flow_(check(&a,10,10));

	flow_(check_val(&a,'0',0,true));
	flow_(check_val(&a,'1',1,true));
	flow_(check_val(&a,'2',2,true));
	flow_(check_val(&a,'3',3,true));
	flow_(check_val(&a,'4',4,true));
	flow_(check_val(&a,'5',5,true));
	flow_(check_val(&a,'6',6,true));
	flow_(check_val(&a,'7',7,true));
	flow_(check_val(&a,'8',8,true));
	flow_(check_val(&a,'9',9,true));
	flow_(check(&a,10,10));

	CLMap b(a);

	SUT_ASSERT(a == b);

	flow_(check(&b,10,10));
	b.clear();
	flow_(check(&b,0,10));
	b.adjust(0);
	flow_(check(&b,0,0));
	b.swap(a);
	flow_(check(&a,0,0));
	flow_(check(&b,10,10));

	b.remove('5');
	b.remove('8');

	flow_(check_val(&b,'0',0,true));
	flow_(check_val(&b,'1',1,true));
	flow_(check_val(&b,'2',2,true));
	flow_(check_val(&b,'3',3,true));
	flow_(check_val(&b,'4',4,true));
	flow_(check_val(&b,'5',5,false));
	flow_(check_val(&b,'6',6,true));
	flow_(check_val(&b,'7',7,true));
	flow_(check_val(&b,'8',8,false));
	flow_(check_val(&b,'9',9,true));

	{
		DMap<int,CountStruct> CSMap;
		CSMap[0] = CountStruct();
		CSMap.set(9);
	}
	SUT_ASSERT_EQUALS(Int,CountStruct::getCount(),0);
	CountStruct::reset();
}
void test_CFMap(){
	CFLMap a;

	flow_(check(&a,0,10));

	a['9'] = 9;
	flow_(check(&a,1,10));
	a['8'] = 8;
	a['7'] = 7;
	a['6'] = 6;
	a['5'] = 5;
	flow_(check(&a,5,10));

	a.set('4',4);
	a.set('3',3);
	a.set('2',2);
	a.set('1',1);
	flow_(check(&a,9,10));
	a.set('0');
	flow_(check(&a,10,10));
	a['0'] = 0;
	flow_(check(&a,10,10));
	try{a['a'] = 10;SUT_ASSERT(false);}catch(std::runtime_error){}

	flow_(check_val(&a,'0',0,true));
	flow_(check_val(&a,'1',1,true));
	flow_(check_val(&a,'2',2,true));
	flow_(check_val(&a,'3',3,true));
	flow_(check_val(&a,'4',4,true));
	flow_(check_val(&a,'5',5,true));
	flow_(check_val(&a,'6',6,true));
	flow_(check_val(&a,'7',7,true));
	flow_(check_val(&a,'8',8,true));
	flow_(check_val(&a,'9',9,true));
	flow_(check(&a,10,10));

	CFLMap b(a);

	SUT_ASSERT(a == b);

	flow_(check(&b,10,10));
	b.clear();
	flow_(check(&b,0,10));
	b.swap(a);
	flow_(check(&a,0,10));
	flow_(check(&b,10,10));

	b.remove('5');
	b.remove('8');

	flow_(check_val(&b,'0',0,true));
	flow_(check_val(&b,'1',1,true));
	flow_(check_val(&b,'2',2,true));
	flow_(check_val(&b,'3',3,true));
	flow_(check_val(&b,'4',4,true));
	flow_(check_val(&b,'5',5,false));
	flow_(check_val(&b,'6',6,true));
	flow_(check_val(&b,'7',7,true));
	flow_(check_val(&b,'8',8,false));
	flow_(check_val(&b,'9',9,true));

	{
		CFMap<int,CountStruct,2> CSMap;
		CSMap[0] = CountStruct();
		CSMap.set(9);
		SUT_ASSERT_EQUALS(Int,CountStruct::getCount(),2);
	}
	SUT_ASSERT_EQUALS(Int,CountStruct::getCount(),0);
}
void test_DFMap(){
	DFLMap a;

	flow_(check(&a,0,10));

	a['9'] = 9;
	flow_(check(&a,1,10));
	a['8'] = 8;
	a['7'] = 7;
	a['6'] = 6;
	a['5'] = 5;
	flow_(check(&a,5,10));

	a.set('4',4);
	a.set('3',3);
	a.set('2',2);
	a.set('1',1);
	flow_(check(&a,9,10));
	a.set('0');
	flow_(check(&a,10,10));
	a['0'] = 0;
	flow_(check(&a,10,10));
	try{a['a'] = 10;SUT_ASSERT(false);}catch(std::runtime_error){}

	flow_(check_val(&a,'0',0,true));
	flow_(check_val(&a,'1',1,true));
	flow_(check_val(&a,'2',2,true));
	flow_(check_val(&a,'3',3,true));
	flow_(check_val(&a,'4',4,true));
	flow_(check_val(&a,'5',5,true));
	flow_(check_val(&a,'6',6,true));
	flow_(check_val(&a,'7',7,true));
	flow_(check_val(&a,'8',8,true));
	flow_(check_val(&a,'9',9,true));
	flow_(check(&a,10,10));

	DFLMap b(a);

	SUT_ASSERT(a == b);

	flow_(check(&b,10,10));
	b.clear();
	flow_(check(&b,0,10));
	b.swap(a);
	flow_(check(&a,0,10));
	flow_(check(&b,10,10));

	b.remove('5');
	b.remove('8');

	flow_(check_val(&b,'0',0,true));
	flow_(check_val(&b,'1',1,true));
	flow_(check_val(&b,'2',2,true));
	flow_(check_val(&b,'3',3,true));
	flow_(check_val(&b,'4',4,true));
	flow_(check_val(&b,'5',5,false));
	flow_(check_val(&b,'6',6,true));
	flow_(check_val(&b,'7',7,true));
	flow_(check_val(&b,'8',8,false));
	flow_(check_val(&b,'9',9,true));

	{
		DFMap<int,CountStruct,2> CSMap;
		CSMap[0] = CountStruct();
		CSMap.set(9);
	}
	SUT_ASSERT_EQUALS(Int,CountStruct::getCount(),0);
	CountStruct::reset();
}
