#include "stdafx.h"
#include "test_funcs.h"
#include <scpl/Buffer.h>

using namespace scpl;

static int p[10] = {1,3,5,4,2,6,7,9,8,0};

inline void tb_1(){
	Buffer<int> ib,ib2;
	SUT_ASSERT(ib.empty());
	SUT_ASSERT_EQUALS(Int,ib.count(),0);
	SUT_ASSERT_EQUALS(Ptr,(const int*)ib,NULL);
	SUT_ASSERT_EQUALS(Ptr,ib.begin(),NULL);
	SUT_ASSERT_EQUALS(Ptr,ib.end(),NULL);
	SUT_ASSERT_EQUALS(Ptr,ib.rbegin(),NULL);
	SUT_ASSERT_EQUALS(Ptr,ib.rend(),NULL);
	SUT_ASSERT(ib.equals(ib2));

	ib.rResize(1);
	SUT_ASSERT(!ib.empty());
	SUT_ASSERT_EQUALS(Int,ib.count(),1);
	SUT_ASSERT_EQUALS(Ptr,(const int*)ib,ib.get());
	SUT_ASSERT_EQUALS(Ptr,ib.begin(),ib.get());
	SUT_ASSERT_EQUALS(Ptr,ib.end(),ib.get()+1);
	SUT_ASSERT_EQUALS(Ptr,ib.rbegin(),ib.get());
	SUT_ASSERT_EQUALS(Ptr,ib.rend(),ib.get()-1);
	SUT_ASSERT(!ib.equals(ib2));

	ib.clear();
	SUT_ASSERT(ib.empty());
	SUT_ASSERT_EQUALS(Int,ib.count(),0);
	SUT_ASSERT_EQUALS(Ptr,(const int*)ib,NULL);
	SUT_ASSERT_EQUALS(Ptr,ib.begin(),NULL);
	SUT_ASSERT_EQUALS(Ptr,ib.end(),NULL);
	SUT_ASSERT_EQUALS(Ptr,ib.rbegin(),NULL);
	SUT_ASSERT_EQUALS(Ptr,ib.rend(),NULL);
	SUT_ASSERT(ib.equals(ib2));
}
inline void tb_2(){
	Buffer<int> ib(p,10);
	Buffer<int> ib2(p,10);
	SUT_ASSERT(!ib.empty());
	SUT_ASSERT_EQUALS(Int,ib.count(),10);
	SUT_ASSERT_EQUALS(Ptr,(const int*)ib,ib.get());
	SUT_ASSERT_EQUALS(Ptr,ib.begin(),ib.get());
	SUT_ASSERT_EQUALS(Ptr,ib.end(),ib.get()+10);
	SUT_ASSERT_EQUALS(Ptr,ib.rbegin(),ib.get()+9);
	SUT_ASSERT_EQUALS(Ptr,ib.rend(),ib.get()-1);
	SUT_ASSERT(ib.equals(ib2));

	ib.rResize(10);
	SUT_ASSERT_EQUALS(Int,ib.count(),20);
	SUT_ASSERT(!ib.equals(ib2));
	ib.rResize(-5);
	SUT_ASSERT_EQUALS(Int,ib.count(),15);
	SUT_ASSERT(!ib.equals(ib2));
	ib.rResize(2);
	SUT_ASSERT_EQUALS(Int,ib.count(),17);
	SUT_ASSERT(!ib.equals(ib2));

	ib.aResize(10);
	SUT_ASSERT_EQUALS(Int,ib.count(),10);
	SUT_ASSERT_EQUALS(Ptr,(const int*)ib,ib.get());
	SUT_ASSERT_EQUALS(Ptr,ib.begin(),ib.get());
	SUT_ASSERT_EQUALS(Ptr,ib.end(),ib.get()+10);
	SUT_ASSERT_EQUALS(Ptr,ib.rbegin(),ib.get()+9);
	SUT_ASSERT_EQUALS(Ptr,ib.rend(),ib.get()-1);
	SUT_ASSERT(ib.equals(ib2));

	ib.rResize(-2);
	SUT_ASSERT_EQUALS(Int,ib.count(),8);
	SUT_ASSERT(!ib.equals(ib2));
	ib.rResize(2);
	SUT_ASSERT_EQUALS(Int,ib.count(),10);
	SUT_ASSERT(!ib.equals(ib2));
	SUT_ASSERT(ib != ib2);

	ib = ib2;

	SUT_ASSERT(ib == ib2);

	SUT_ASSERT_EQUALS(Int,ib.size(),sizeof(p));
}
inline void tb_3(){
	Buffer<int> ib(p);
	Buffer<int> ib2;

	ib.swap(ib2);
	SUT_ASSERT(ib.empty());
	SUT_ASSERT_EQUALS(Int,ib.count(),0);
	SUT_ASSERT(ib != ib2);

	ib = ib2;
	SUT_ASSERT(!ib.empty());
	SUT_ASSERT_EQUALS(Int,ib.count(),10);
	SUT_ASSERT(ib == ib2);

	SUT_ASSERT_EQUALS(Int,ib.toPos(ib.get()),0);
	SUT_ASSERT_EQUALS(Int,ib.toPos(ib.get()+4),4);
	SUT_ASSERT_EQUALS(Int,ib2.toPos(ib2.get()+2),2);
	SUT_ASSERT_EQUALS(Int,ib2.toPos(ib2.get()+1),1);
}
inline void tb_4(){
	Buffer<int> ib;
	ib.aResize(10,true);
	memcpy(ib.get(),p,sizeof(p));
	int* i = ib.get();
	SUT_ASSERT_EQUALS(Int,i[0],1);
	SUT_ASSERT_EQUALS(Int,i[1],3);
	SUT_ASSERT_EQUALS(Int,i[2],5);
	SUT_ASSERT_EQUALS(Int,i[3],4);
	SUT_ASSERT_EQUALS(Int,i[4],2);
	SUT_ASSERT_EQUALS(Int,i[5],6);
	SUT_ASSERT_EQUALS(Int,i[6],7);
	SUT_ASSERT_EQUALS(Int,i[7],9);
	SUT_ASSERT_EQUALS(Int,i[8],8);
	SUT_ASSERT_EQUALS(Int,i[9],0);
}

void test_Buffer(){
	tb_1();
	tb_2();
	tb_3();
	tb_4();
}