// 
// Argument.cpp
// 
// Copyright(C) 2006-2007 Ó
#include "stdafx.h"
#include "../scpl/Argument.h"
#include "../scpl/auto_ptr.h"

#ifdef __BORLANDC__
#define _strdup strdup
#endif
namespace scpl{

	namespace argument{

		bool createArgumentA(ArgVA** in,cstr txt,cstr divide,bool isQuote){
			ulong len;
			AString s;
			char c;
			bool isArg = false;
			bool isSQuoteIn = false;
			bool isDQuoteIn = false;
			ArgVA* v;

			if(!in||!txt) return false;
			if(!divide) divide = " \t\n";
			else if(strchr(divide,'"')||strchr(divide,'\'')) return false;
			v = newcheck(new ArgVA());
			auto_ptr<ArgVA> _v(v);
			len = static_cast<ulong>(strlen(txt));

			for(ulong i=0;i<=len;++i){
				c = *(txt + i);
				if(isArg){
					if(isQuote&&(isSQuoteIn||isDQuoteIn)){
						if((isSQuoteIn&&(c=='\''))||(isDQuoteIn&&(c=='"'))){
							isSQuoteIn = isDQuoteIn = isArg = false;
							v->lastIn(s);
							s.clear(false);
						}
						else s.lastInChar(c);
					}
					else if(strchr(divide,c)){
						isArg = false;
						v->lastIn(s);
						s.clear(false);
					}
					else s.lastInChar(c);
				}
				else if(strchr(divide,c)) continue;
				else if(isQuote&&(c=='\'')) isSQuoteIn = isArg = true;
				else if(isQuote&&(c=='"'))  isDQuoteIn = isArg = true;
				else{
					isArg = true;
					s.lastInChar(c);
				}
			}
			if(isArg) v->lastIn(s);
			*in = _v();
			return true;
		}
		bool createArgumentW(ArgVW** in,cwstr txt,cwstr divide,bool isQuote){
			ulong len;
			WString s;
			wchar_t c;
			bool isArg = false;
			bool isSQuoteIn = false;
			bool isDQuoteIn = false;
			ArgVW* v;

			if(!in||!txt) return false;
			if(!divide) divide = L" \t\n";
			else if(wcschr(divide,'"')||wcschr(divide,'\'')) return false;
			v = newcheck(new ArgVW());
			auto_ptr<ArgVW> _v(v);
			len = static_cast<ulong>(wcslen(txt));

			for(ulong i=0;i<=len;++i){
				c = *(txt + i);
				if(isArg){
					if(isQuote&&(isSQuoteIn||isDQuoteIn)){
						if((isSQuoteIn&&(c==L'\''))||(isDQuoteIn&&(c==L'"'))){
							isSQuoteIn = isDQuoteIn = isArg = false;
							v->lastIn(s);
							s.clear(false);
						}
						else s.lastInChar(c);
					}
					else if(wcschr(divide,c)){
						isArg = false;
						v->lastIn(s);
						s.clear(false);
					}
					else s.lastInChar(c);
				}
				else if(wcschr(divide,c)) continue;
				else if(isQuote&&(c==L'\'')) isSQuoteIn = isArg = true;
				else if(isQuote&&(c==L'"'))  isDQuoteIn = isArg = true;
				else{
					isArg = true;
					s.lastInChar(c);
				}
			}
			if(isArg) v->lastIn(s);
			*in = _v();
			return true;
		}

		inline void setArgTypeA(ARGTYPE type,ArgVA* v){
			char dir[MAX_PATH];
			switch(type){
				case NONE:
					v->firstOut();
				break;
				case CONSOLE:
					GetCurrentDirectoryA(MAX_PATH,dir);
					v->atFirst().firstInStr(PathAddBackslashA(dir));
				break;
				case EXENAME:
					strcpy(dir,v->atFirst());
					PathRenameExtensionA(dir,".exe");
					v->atFirst() = dir;
				break;
				case EXEPATH:
					strcpy(dir,v->atFirst());
					PathRenameExtensionA(dir,".exe");
					v->atFirst() = dir;
					GetCurrentDirectoryA(MAX_PATH,dir);
					PathAppendA(dir,v->atFirst());
					v->atFirst() = dir;
				break;
				case DIR:
					GetCurrentDirectoryA(MAX_PATH,dir);
					PathAddBackslashA(dir);
					v->atFirst() =dir;
				break;
				case EXEDIR:
					GetCurrentDirectoryA(MAX_PATH,dir);
					PathAppendA(dir,v->atFirst());
					*PathFindFileNameA(dir) = NULL;
					v->atFirst() = dir;
				break;
			}
		}
		inline void setArgTypeW(ARGTYPE type,ArgVW* v){
			wchar_t dir[MAX_PATH];
			switch(type){
				case NONE:
					v->firstOut();
				break;
				case CONSOLE:
					GetCurrentDirectoryW(MAX_PATH,dir);
					v->atFirst().firstInStr(PathAddBackslashW(dir));
				break;
				case EXENAME:
					wcscpy(dir,v->atFirst());
					PathRenameExtensionW(dir,L".exe");
					v->atFirst() = dir;
				break;
				case EXEPATH:
					wcscpy(dir,v->atFirst());
					PathRenameExtensionW(dir,L".exe");
					v->atFirst() = dir;
					GetCurrentDirectoryW(MAX_PATH,dir);
					PathAppendW(dir,v->atFirst());
					v->atFirst() = dir;
				break;
				case DIR:
					GetCurrentDirectoryW(MAX_PATH,dir);
					PathAddBackslashW(dir);
					v->atFirst() = dir;
				break;
				case EXEDIR:
					GetCurrentDirectoryW(MAX_PATH,dir);
					PathAppendW(dir,v->atFirst());
					*PathFindFileNameW(dir) = NULL;
					v->atFirst() = dir;
				break;
			}
		}

		bool createArgumentFromCommandLineA(ArgVA** in,ARGTYPE type){
			if(!in) return false;
			ArgVA* v;
			if(!createArgumentA(&v,GetCommandLineA())) return false;
			setArgTypeA(type,v);
			*in = v;
			return true;
		}
		bool createArgumentFromCommandLineW(ArgVW** in,ARGTYPE type){
			if(!in) return false;
			ArgVW* v;
			if(!createArgumentW(&v,GetCommandLineW())) return false;
			setArgTypeW(type,v);
			*in = v;
			return true;
		}

		bool commandLineToArgvA(int* argc,str** argv,ARGTYPE type){
			int count,i;
			str* list = NULL;
			if(!argc||!argv) return false;
			ArgVA* v;
			if(!createArgumentA(&v,GetCommandLineA())) return false;
			setArgTypeA(type,v);
			auto_ptr<ArgVA> _v(v);
			count = v->count();
			if(count){
				list = newcheck(new str[count]);
				memset(list,0,count*sizeof(str));
				for(i=count-1;0<=i;--i){
					list[i] = _strdup(v->at(i));
					if(!list[i]) goto fail;
				}
			}
			*argc = count;
			*argv = list;
			return true;
		fail:
			for(++i;i<count;++i) free(list[i]);
			delete[] list;
			return false;
		}
		bool commandLineToArgvW(int* argc,wstr** argv,ARGTYPE type){
			int count,i;
			wstr* list = NULL;
			if(!argc||!argv) return false;
			ArgVW* v;
			if(!createArgumentW(&v,GetCommandLineW())) return false;
			setArgTypeW(type,v);
			auto_ptr<ArgVW> _v(v);
			count = v->count();
			if(count){
				list = newcheck(new wstr[count]);
				memset(list,0,count*sizeof(wstr));
				for(i=count-1;0<=i;--i){
					list[i] = _wcsdup(v->at(i));
					if(!list[i]) goto fail;
				}
			}
			*argc = count;
			*argv = list;
			return true;
		fail:
			for(++i;i<count;++i) free(list[i]);
			delete[] list;
			return false;
		}

		void releaseArgvA(int argc,str* argv){
			for(int i=0;i<argc;++i) delete[] argv[i];
			delete[] argv;
		}
		void releaseArgvW(int argc,wstr* argv){
			for(int i=0;i<argc;++i) delete[] argv[i];
			delete[] argv;
		}
	}

}
