// 
// auto_ptr.h
// 
// Copyright(C) 2006-2007 Ó
#ifndef _auto_ptr_INCLUDED_
#define _auto_ptr_INCLUDED_

#include "utility.h"

namespace scpl{

/**
	[U[`̉s}N֐B
	̊֐Ă΂Ƃ́A\ȂƂ݂̂Ȃ̂ŁA
	|C^̃`FbN͕svłB
	܂A|C^̕ϐ_PtrłB
**/
#define auto_delete(type) template<> void scpl::auto_ptr<type>::delptr()

	/**
		|C^ǗNXłB
		̃NX́ARXgN^Ƀ|C^i[A
		fXgN^Ƀ|C^NXłB
		setDeletable ֐gpăfXgN^
		Ȃ悤邱Ƃł܂B
		܂AL̓ɂAIɉȂ悤ɂł܂B
		[pre]
		// p ̓|C^^̕ϐA ptr ̓|C^NXB
		p = ptr();
		// ͈ȉ̏ƓłB
		ptr.setDeletable(false);
		p = ptr;
		[/pre]
		܂A邱ƂɂA|C^u邱Ƃł܂B
		̂Ƃ̒u|C^ setDeletable ֐Ŏw肵
		s܂B

		W̉ł delete y delete[] g܂A
		auto_delete }N֐gp΁Ǎ^̉
		sƂł܂B
		zۗLAǗꍇ auto_ary NXgpĂB
	**/
	TMP class auto_ptr{
		void delptr(){delete _Ptr;}

	public:
		typedef T*			ptr;
		typedef T&			ind;
		typedef const T*	cptr;
		typedef const T&	cind;
		typedef auto_ptr<T>	self;

		/**
			NULL܂B
		**/
		auto_ptr():_Deletable(false),_Ptr(NULL){}
		/**
			|C^܂B
			[arg]
			p	: |C^B
		**/
		explicit auto_ptr(ptr p):_Deletable(true),_Ptr(p){}
		/**
			Rs[܂B
			Rs[ɉꍇ̂݉ړ܂B
			[arg]
			s	: Rs[̃|C^NXB
		**/
		explicit auto_ptr(const self& s):_Ptr(s._Ptr),_Deletable(s._Deletable){
			if(_Deletable) s._Deletable = false;
		}

		/**
			fXgN^B
			ꍇ̂݃|C^܂B
		**/
		~auto_ptr(){if(_Deletable&&_Ptr) delptr();}

		/**
			|C^ԂAȂ悤ɐݒ肵܂B
			[return]
			LĂ|C^B
		**/
		ptr operator()(){_Deletable = false;return _Ptr;}
		/**
			|C^݂邩Ԃ܂B
			[return]
			LĂ|C^݂Ȃ true AłȂꍇ false Ԃ܂B
		**/
		operator bool()const{return _Ptr;}
		/**
			|C^ NULL Ԃ܂B
			[return]
			LĂ|C^ NULL Ȃ true AłȂꍇ false Ԃ܂B
		**/
		bool operator!()const{return _Ptr==NULL;}

		/**
			|C^ꍇŉEӂɍ폜ꍇAӂ֍폜ړ܂B
			[arg]
			s	: 폜ړ|C^B
			[return]
			g̃CX^XԂ܂B
		**/
		self& operator<<=(self& s){moveDeletable(s);return *this;}

		/**
			|C^v邩Ԃ܂B
			[arg]
			p	: r|C^B
			[return]
			vꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool operator==(cptr p)const{return _Ptr == p;}
		bool operator==(const self& p)const{return _Ptr == p._Ptr;}
		/**
			|C^svԂ܂B
			[arg]
			p	: r|C^B
			[return]
			sv̏ꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool operator!=(cptr p)const{return _Ptr != p;}
		bool operator!=(const self& p)const{return _Ptr != p._Ptr;}

		/**
			w肵|C^܂B
			[arg]
			p	: |C^B
			[return]
			g̃CX^XԂ܂B
		**/
		self& operator=(ptr p){set(p);return *this;}
		/**
			w肵|C^܂B
			[arg]
			p				: |C^B
		**/
		void set(ptr p){
			if(_Ptr != p){
				if(_Deletable&&_Ptr) delptr();
				_Ptr = p;
				_Deletable = true;
			}
		}

		/**
			w肵|C^NX܂B
			[arg]
			s	: |C^B
			[return]
			g̃CX^XԂ܂B
		**/
		self& operator=(const self& s){set(s);return *this;}
		/**
			w肵|C^NX܂B
			[arg]
			s	: |C^B
		**/
		void set(const self& s){
			if(_Ptr != s._Ptr){
				if(_Deletable&&_Ptr) delptr();
				_Ptr = s._Ptr;
				_Deletable = false;
			}
		}

		/**
			̂QƂ܂B
			[return]
			LĂ|C^̊ԐڎQƂԂ܂B
		**/
		ind operator*()const{return *_Ptr;}
		/**
			oQƂ܂B
			[return]
			LĂ|C^B
		**/
		ptr operator->()const{return _Ptr;}

		/**
			̂Ԃ܂B
			[return]
			LĂ|C^̊ԐڎQƂԂ܂B
		**/
		ind getIndirect()const{return *_Ptr;}
		/**
			|C^Ԃ܂B
			[return]
			LĂ|C^B
		**/
		ptr get()const{return _Ptr;}
		ptr operator~()const{return _Ptr;}

		/**
			|C^ NULL Ԃ܂B
			[return]
			|C^ NULL ̏ꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool empty()const{return !_Ptr;}

		/**
			ւ܂B
			[arg]
			p	: ւ|C^NXB
		**/
		void swap(self& s){scpl::swap(_Ptr,s._Ptr);scpl::swap(_Deletable,s._Deletable);}

		/**
			w肷|C^ꍇłɍ폜ꍇA폜ړ܂B
			[arg]
			s	: 폜ړ|C^B
		**/
		void moveDeletable(self& s){
			if((_Ptr == s._Ptr)&&s._Deletable){
				s._Deletable = false;
				_Deletable = true;
			}
		}

		/**
			f[^NA܂B
			NULL ̂ƓłB
		**/
		void clear(){if(_Deletable&&_Ptr) delptr();_Ptr = NULL;}

		/**
			̃|C^邩ǂݒ肵܂B
			[arg]
			deletable	: 邩ǂB
		**/
		void setDeletable(bool deletable){_Deletable = deletable;}

	protected:
		bool _Deletable;
		T* _Ptr;

	};

} // namespace scpl
#endif