// 
// algorithm.h
// 
// Copyright(C) 2006-2007 Ó
#ifndef _algorithm_INCLUDED_
#define _algorithm_INCLUDED_
#include "scpl.h"
#include "Function.h"

/**
	IȃASYLqt@CłB
**/

namespace scpl{

	namespace alg{

		/**
			f[^݂邩ǂԂ܂B
			[arg]
			data  : ׂ郊Xg
			count : Xg̍ڐ
			[return]
			݂ꍇ true AłȂꍇ false B
		**/
		TMP bool isOverlap(const T* data,ulong count){
			const T *i,*n = data+count-1;
			const T *j,*m = data+count;
			for(i=data;i<n;++i){
				for(j=i+1;j<m;++j){
					if(*i == *j) return true;
				}
			}
			return false;
		}
		/**
			f[^݂邩ǂԂ܂B
			[arg]
			data : ׂzB
			[return]
			݂ꍇ true AłȂꍇ false B
		**/
		BUFTMP bool isOverlap(const T(&data)[C]){
			const T *i,*n = data+C-1;
			const T *j,*m = data+C;
			for(i=data;i<n;++i){
				for(j=i+1;j<m;++j){
					if(*i == *j) return true;
				}
			}
			return false;
		}
		/**
			w肵ɂēf[^݂邩ǂԂ܂B
			[arg]
			data  : ׂ郊XgB
			count : Xg̍ڐB
			fif   : ֐B
			[return]
			݂ꍇ true AłȂꍇ false B
		**/
		IFFUNCTMP bool isOverlapF(const T* data,ulong count,IFFunc fif){
			const T *i,*n = data+count-1;
			const T *j,*m = data+count;
			for(i=data;i<n;++i){
				for(j=i+1;j<m;++j){
					if(fif(*i,*j)) return true;
				}
			}
			return false;
		}
		/**
			w肵ɂēf[^݂邩ǂԂ܂B
			[arg]
			data  : ׂzB
			fif   : ֐B
			[return]
			݂ꍇ true AłȂꍇ false B
		**/
		IFFUNCBUFTMP bool isOverlapF(const T(&data)[C],IFFunc fif){
			const T *i,*n = data+C-1;
			const T *j,*m = data+C;
			for(i=data;i<n;++i){
				for(j=i+1;j<m;++j){
					if(fif(*i,*j)) return true;
				}
			}
			return false;
		}

		/**
			f[^݂邩ǂԂ܂B
			[arg]
			data  : ׂ郊XgB
			count : Xg̍ڐB
			r1    : ݂ƂɕԂ铯f[^ɂȂ data ̃|C^󂯎ϐB
			r2    : ݂ƂɕԂ铯f[^ɂȂ data ̃|C^󂯎ϐB
			[return]
			݂ꍇ 0 ԂA
			r1  r2 Ɉvf[^ւ̃|C^ݒ肵܂B
			݂Ȃꍇ ̒l ԂA
			r1  r2  NULL ݒ肵܂B
			r1  r2  NULL ̏ꍇ ̒l Ԃ܂B
		**/
		TMP int isOverlapEx(const T* data,ulong count,const T** r1,const T** r2){
			if(!r1||!r2) return -1;
			const T *i,*n = data+count-1;
			const T *j,*m = data+count;
			for(i=data;i<n;++i){
				for(j=i+1;j<m;++j){
					if(*i == *j){
						*r1 = i;
						*r2 = j;
						return 0;
					}
				}
			}
			*r1 = NULL;
			*r2 = NULL;
			return 1;
		}
		/**
			f[^݂邩ǂԂ܂B
			[arg]
			data  : ׂzB
			r1    : f[^ɂȂ data ̃|C^󂯎ϐB
			r2    : f[^ɂȂ data ̃|C^󂯎ϐB
			[return]
			݂ꍇ 0 ԂA
			r1  r2 Ɉvf[^ւ̃|C^ݒ肵܂B
			݂Ȃꍇ ̒l ԂA
			r1  r2  NULL ݒ肵܂B
			r1  r2  NULL ̏ꍇ ̒l Ԃ܂B
		**/
		BUFTMP int isOverlapEx(const T(&data)[C],const T** r1,const T** r2){
			if(!r1||!r2) return -1;
			const T *i,*n = data+C-1;
			const T *j,*m = data+C;
			for(i=data;i<n;++i){
				for(j=i+1;j<m;++j){
					if(*i == *j){
						*r1 = i;
						*r2 = j;
						return 0;
					}
				}
			}
			*r1 = NULL;
			*r2 = NULL;
			return 1;
		}

		/**
			f[^݂邩ǂԂ܂B
			[arg]
			data  : ׂ郊XgB
			count : Xg̍ڐB
			fif   : ֐B
			r1    : ݂ƂɕԂ铯f[^ɂȂ data ̃|C^󂯎ϐB
			r2    : ݂ƂɕԂ铯f[^ɂȂ data ̃|C^󂯎ϐB
			[return]
			݂ꍇ 0 ԂA
			r1  r2 Ɉvf[^ւ̃|C^ݒ肵܂B
			݂Ȃꍇ ̒l ԂA
			r1  r2  NULL ݒ肵܂B
			r1  r2  NULL ̏ꍇ ̒l Ԃ܂B
		**/
		IFFUNCTMP int isOverlapExF(const T* data,ulong count,IFFunc fif,const T** r1,const T** r2){
			if(!r1||!r2) return -1;
			const T *i,*n = data+count-1;
			const T *j,*m = data+count;
			for(i=data;i<n;++i){
				for(j=i+1;j<m;++j){
					if(fif(*i,*j)){
						*r1 = i;
						*r2 = j;
						return 0;
					}
				}
			}
			*r1 = NULL;
			*r2 = NULL;
			return 1;
		}
		/**
			f[^݂邩ǂԂ܂B
			[arg]
			data  : ׂzB
			fif   : ֐B
			r1    : ݂ƂɕԂ铯f[^ɂȂ data ̃|C^󂯎ϐB
			r2    : ݂ƂɕԂ铯f[^ɂȂ data ̃|C^󂯎ϐB
			[return]
			݂ꍇ 0 ԂA
			r1  r2 Ɉvf[^ւ̃|C^ݒ肵܂B
			݂Ȃꍇ ̒l ԂA
			r1  r2  NULL ݒ肵܂B
			r1  r2  NULL ̏ꍇ ̒l Ԃ܂B
		**/
		IFFUNCBUFTMP int isOverlapExF(const T(&data)[C],IFFunc fif,const T** r1,const T** r2){
			if(!r1||!r2) return -1;
			const T *i,*n = data+C-1;
			const T *j,*m = data+C;
			for(i=data;i<n;++i){
				for(j=i+1;j<m;++j){
					if(fif(*i,*j)){
						*r1 = i;
						*r2 = j;
						return 0;
					}
				}
			}
			*r1 = NULL;
			*r2 = NULL;
			return 1;
		}

	} // namespace alg

} // namespace scpl
#endif