// 
// List.h
// 
// Copyright(C) 2006-2007 Ó
#ifndef _List_INCLUDED_
#define _List_INCLUDED_
#include "Container.h"
#include "find.h"

namespace scpl{

	TMP class CList;
	TMP class DList;
	BUFTMP class CFList;
	BUFTMP class DFList;

	/**
		XgsꒊۃNXłB
		̃NX̊{@\ STL Cu vector A list ɑ̂łA
		֐Ȃǂ͓ł͂܂B
	**/
	TMP class IList : public IContainer_accessable<T>{
	public:
		IList():_UseCount(0){}

		virtual ~IList(){}

		/**
			f[^LĂȂǂԂ܂B
			[return]
			f[^LĂȂꍇ true AłȂꍇ false Ԃ܂B
		**/
		virtual bool empty()const{return _UseCount == 0;}
		/**
			LĂf[^̐Ԃ܂B
			[return]
			LĂf[^̐B
		**/
		virtual ulong count()const{return _UseCount;}

		/**
			w肵ʒuɂf[^Ԃ܂B
			[arg]
			index	: 擾f[^̈ʒuB
			[return]
			w肵ʒũf[^B
			[exc]
			std::runtime_error	: f[^LĂȂB
			[note]
			̊֐͔͈̓`FbNsĂ܂B
			͈͊Ow肵ꍇ͖̓`łB
		**/
		ind at(ulong index){
			if(count() == 0) THROW_DO_NOT_HAVE_DATA();
			return begin()[index];
		}
		cind at(ulong index)const{
			if(count() == 0) THROW_DO_NOT_HAVE_DATA();
			return begin()[index];
		}

		/**
			擪ɂf[^Ԃ܂B
			[return]
			擪̃f[^B
			[exc]
			std::runtime_error	: f[^LĂȂB
		**/
		ind atFirst(){return at(0);}
		cind atFirst()const{return at(0);}

		/**
			I[ɂf[^Ԃ܂B
			[return]
			I[̃f[^B
			[exc]
			std::runtime_error	: f[^LĂȂB
		**/
		ind atLast(){return at(count()-1);}
		cind atLast()const{return at(count()-1);}

		/**
			w肵f[^w肵ʒuɑ}܂B
			[arg]
			data	: }f[^B
			index	: }ʒuB
			[return]
			}ꂽʒuB
			[exc]
			std::bad_alloc	: }邽߂̗̈mۂłȂB
			[note]
			̊֐͔͈̓`FbNsĂ܂B
			͈͊Ow肵ꍇ͖̓`łB
		**/
		long insert(cind data,ulong index){return insert(&data,1,index);}
		/**
			w肵f[^w肵ʒuɑ}܂B
			[arg]
			data	: }f[^B
			c		: f[^̐B
			index	: }ʒuB
			[return]
			}ꂽʒuB
			[exc]
			std::bad_alloc	: }邽߂̗̈mۂłȂB
			[note]
			̊֐͔͈̓`FbNsĂ܂B
			͈͊Ow肵ꍇ͖̓`łB
		**/
		virtual long insert(cptr data,ulong c,ulong index)=0;

		/**
			w肵f[^擪ɑ}܂B
			[arg]
			data	: }f[^B
			[return]
			}ꂽʒuB 0 łB
			[exc]
			std::bad_alloc	: }邽߂̗̈mۂłȂB
		**/
		long firstIn(cind data){return insert(&data,1,0);}
		/**
			w肵f[^擪ɑ}܂B
			[arg]
			data	: }f[^B
			c		: f[^̐B
			[return]
			}ꂽʒuB 0 łB
			[exc]
			std::bad_alloc	: }邽߂̗̈mۂłȂB
		**/
		long firstIn(cptr data,ulong c){return insert(data,c,0);}

		/**
			w肵f[^I[ɒǉ܂B
			[arg]
			data	: ǉf[^B
			[return]
			ǉꂽʒuB
			[exc]
			std::bad_alloc	: ǉ邽߂̗̈mۂłȂB
		**/
		long lastIn(cind data){return insert(&data,1,count());}
		/**
			w肵f[^I[ɒǉ܂B
			[arg]
			data	: ǉf[^B
			c		: f[^̐B
			[return]
			ǉꂽʒuB
			[exc]
			std::bad_alloc	: ǉ邽߂̗̈mۂłȂB
		**/
		long lastIn(cptr data,ulong c){return insert(data,c,count());}

		/**
			w肵ʒuɂf[^폜܂B
			[arg]
			index	: 폜f[^ւ̈ʒuB
			[exc]
			std::runtime_error		: f[^݂ȂB
			std::out_of_range		: 폜of[^͈̔͊OB
		**/
		void remove(ulong index){erageRange(begin()+index,_begin()+index+1);}
		/**
			w肵͈͂ɂf[^폜܂B
			[arg]
			l	: 폜f[^ւ̎n[ʒuB̏ꏊ͔͈͂Ɋ܂݂܂B
			r	: 폜f[^ւ̏I[ʒuB̏ꏊ͔͈͂Ɋ܂܂܂B
			[exc]
			std::runtime_error		: f[^݂ȂB
			std::invalid_argument	: n[ʒuƏI[ʒutA邢͓ꏊwĂB
			std::out_of_range		: 폜of[^͈̔͊OB
		**/
		void removeRange(ulong l,ulong r){erageRange(begin()+l,begin()+r);}

		/**
			w肵f[^̃|C^̃f[^폜܂B
			[arg]
			p	: 폜f[^̃|C^̃f[^B
			[exc]
			std::runtime_error		: f[^݂ȂB
			std::out_of_range		: 폜of[^͈̔͊OB
		**/
		void erage(cptr p){erageRange(p,p+1);}
		/**
			w肵f[^̃|C^̃f[^͈̔͂폜܂B
			[arg]
			l	: 폜f[^̃|C^̃f[^n[ʒuB̏ꏊ͔͈͂Ɋ܂݂܂B
			r	: 폜f[^̃|C^̃f[^I[ʒuB̏ꏊ͔͈͂Ɋ܂܂܂B
			[exc]
			std::runtime_error		: f[^݂ȂB
			std::invalid_argument	: n[ʒuƏI[ʒutA邢͓ꏊwĂB
			std::out_of_range		: 폜of[^͈̔͊OB
		**/
		virtual void erageRange(const T* l,const T* r)=0;

		/**
			擪̃f[^폜܂B
			[exc]
			std::runtime_error		: f[^݂ȂB
		**/
		void firstOut(){erageRange(begin(),begin()+1);}
		/**
			I[̃f[^폜܂B
			[exc]
			std::runtime_error		: f[^݂ȂB
		**/
		void lastOut(){erageRange(rbegin(),end());}

		/**
			f[^܂B
			[arg]
			data	: f[^B
			start	: JnʒuB̈ʒu͈͌͂ɓ܂B
			[return]
			ꍇ͂̈ʒuԂAȂꍇ -1 Ԃ܂B
		**/
		long find(cind data,ulong start=0)const{return diFind(begin()+start,end(),data);}
		/**
			f[^tŌ܂B
			[arg]
			data	: f[^B
			[return]
			ꍇ͂̈ʒuԂAȂꍇ -1 Ԃ܂B
		**/
		long rfind(cind data)const{return diFindR(end(),begin(),data);}
		/**
			f[^tŌ܂B
			[arg]
			data	: f[^B
			start	: JnʒuB̈ʒu͈͌͂ɓ܂B
			[return]
			ꍇ͂̈ʒuԂAȂꍇ -1 Ԃ܂B
		**/
		long rfind(cind data,ulong start)const{return diFindR(end(),begin()+start,data);}

		/**
			w肵f[^zƈv邩Ԃ܂B
			[arg]
			p	: rf[^zB
			c	: f[^̐B
			[return]
			vꍇ true AłȂꍇ false Ԃ܂B
		**/
		virtual bool equals(cptr p,ulong c)const{return _conatiner_equals(p,c,begin(),count());}

	protected:
		ulong	_UseCount;

	};

	/**
		ϒXg̒ۃNXłB
	**/
	TMP class IList_Buffer : public IList<T>{
	protected:
		void _swap(IList_Buffer<T>* s){_container_swap(_List,_UseCount,s->_List,s->_UseCount);}

	public:
		IList_Buffer(ulong c=0):_List(c){}

		virtual ~IList_Buffer(){}

		/**
			i[\̐Ԃ܂B
			[return]
			i[\B
		**/
		virtual ulong capacity()const{return _List.count();}

		/**
			p̍ŏ̈ʒu|C^Ԃ܂B
			[return]
			z̍ŏ̈ʒu|C^B
			f[^݂ȂƂ NULL Ԃ܂B
		**/
		virtual ptr begin(){return empty()?NULL:_List.begin();}
		virtual cptr begin()const{return empty()?NULL:_List.begin();}
		/**
			p̍Ō̈ʒu|C^Ԃ܂B
			[return]
			z̍Ō̈ʒu|C^B
			̈ʒüOLĂI[łB
			f[^݂ȂƂ NULL Ԃ܂B
		**/
		virtual ptr end(){return empty()?NULL:(_List.begin()+count());}
		virtual cptr end()const{return empty()?NULL:(_List.begin()+count());}
		/**
			tp̍ŏ̈ʒu|C^Ԃ܂B
			[return]
			tz̍ŏ̈ʒu|C^B
			f[^݂ȂƂ NULL Ԃ܂B
		**/
		virtual ptr rbegin(){return empty()?NULL:(_List.begin()+count()-1);}
		virtual cptr rbegin()const{return empty()?NULL:(_List.begin()+count()-1);}
		/**
			tp̍Ō̈ʒu|C^Ԃ܂B
			[return]
			tz̍Ō̈ʒu|C^B
			̈ʒüオLĂI[łB
			f[^݂ȂƂ NULL Ԃ܂B
		**/
		virtual ptr rend(){return empty()?NULL:(_List.begin()-1);}
		virtual cptr rend()const{return empty()?NULL:(_List.begin()-1);}

		/**
			cmۉ\̈ݒ肵܂B
			[arg]
			cap	: ݒ肷cmۉ\̈̐B
			[exc]
			std::bad_alloc	: w肵̈mۂłȂB
		**/
		void adjust(ulong c=0){_List.aResize(count()+c);}

	protected:
		Buffer<T>	_List;

	};

	/**
		Œ蒷Xg̒ۃNXłB

		̃NX̃o֐̐́A IList_Buffer NX
		QƂĂB
	**/
	BUFTMP class IList_Fixed : public IList<T>{
	protected:
		void _swap(IList_Fixed<T,C>* s){_container_swap_fixed(_List,_UseCount,s->_List,s->_UseCount);}
	public:
		virtual ~IList_Fixed(){}
		virtual ptr begin(){return empty()?NULL:_List.begin();}
		virtual cptr begin()const{return empty()?NULL:_List.begin();}
		virtual ptr end(){return empty()?NULL:(_List.begin()+count());}
		virtual cptr end()const{return empty()?NULL:(_List.begin()+count());}
		virtual ptr rbegin(){return empty()?NULL:(_List.begin()+count()-1);}
		virtual cptr rbegin()const{return empty()?NULL:(_List.begin()+count()-1);}
		virtual ptr rend(){return empty()?NULL:(_List.begin()-1);}
		virtual cptr rend()const{return empty()?NULL:(_List.begin()-1);}
		virtual ulong capacity()const{return C;}
	protected:
		FBuffer<T,C>	_List;
	};

	/**
		NX̃RXgN^EfXgN^ɑΉA
		ϒNXzReiNXłB
		̃NX̊{@\ STL Cu vector A list ɑ̂łA
		֐Ȃǂ͓ł͂܂B
	**/
	TMP class CList : public IList_Buffer<T>{
		typedef CList<T> self;

	public:
		/**
			́A邢͎w肵̈mۂč쐬܂B
			[arg]
			c	: mۂ̈B
			[exc]
			std::bad_alloc	: w肵̈mۂłȂB
		**/
		CList(ulong c=0):IList_Buffer<T>(c){}
		/**
			w肵f[^zRs[Xg쐬܂B
			[arg]
			p	: Rs[̃f[^zB
			c	: f[^̐B
			[exc]
			std::bad_alloc	: Rs[ɕKvȗ̈mۂłȂB
		**/
		CList(cptr p,ulong c):IList_Buffer<T>(c){copy(p,c);}
		/**
			w肵Xg̕쐬܂B
			[arg]
			s	: 郊XgB
			[exc]
			std::bad_alloc	: ɕKvȗ̈mۂłȂB
		**/
		explicit CList(const self& s):IList_Buffer<T>(s.count()){copy(s.begin(),s.count());}

		/**
			fXgN^B
			f[^Sč폜܂B
		**/
		virtual ~CList(){clear();}

		/**
			w肵f[^zRs[܂B
			[arg]
			p	: Rs[̃f[^zB
			c	: f[^̐B
			[exc]
			std::bad_alloc	: Rs[ɕKvȗ̈mۂłȂB
		**/
		virtual void copy(cptr data,ulong c){clear();_container_copy(data,c,_List,_UseCount);}
		/**
			f[^Sč폜܂B
		**/
		virtual void clear(){_container_clear(_List,_UseCount);}

		/**
			f[^LĂ邩Ԃ܂B
			[return]
			f[^LĂꍇ true AłȂꍇ false Ԃ܂B
		**/
		operator bool()const{return !empty();}
		/**
			f[^LĂȂԂ܂B
			[return]
			f[^LĂȂꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool operator!()const{return empty();}

		/**
			w肵ʒuɂf[^Ԃ܂B
			[arg]
			index	: 擾f[^̈ʒu
			[return]
			w肵ʒũf[^B
			[exc]
			std::runtime_error	: f[^LĂȂB
			[note]
			̊֐͔͈̓`FbNsĂ܂B
			͈͊Ow肵ꍇ͖̓`łB
		**/
		ind operator[](ulong index){return at(index);}
		cind operator[](ulong index)const{return at(index);}

		/**
			w肵Xgƈv邩Ԃ܂B
			[arg]
			s	: r郊XgB
			[return]
			vꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool operator==(const CList<T>& s)const{return equals(s.begin(),s.count());}
		bool operator==(const DList<T>& s)const{return equals(s.begin(),s.count());}
		NTMP bool operator==(const CFList<T,N>& s)const{return equals(s.begin(),s.count());}
		NTMP bool operator==(const DFList<T,N>& s)const{return equals(s.begin(),s.count());}
		/**
			w肵XgƕsvԂ܂B
			[arg]
			s	: r郊XgB
			[return]
			sv̏ꍇ true AłȂꍇ false Ԃ܂B
		**/
		bool operator!=(const CList<T>& s)const{return !equals(s.begin(),s.count());}
		bool operator!=(const DList<T>& s)const{return !equals(s.begin(),s.count());}
		NTMP bool operator!=(const CFList<T,N>& s)const{return !equals(s.begin(),s.count());}
		NTMP bool operator!=(const DFList<T,N>& s)const{return !equals(s.begin(),s.count());}

		/**
			w肵Xg܂B
			[arg]
			s	: 郊XgB
			[return]
			g̃CX^XԂ܂B
			[exc]
			std::bad_alloc	: ɕKvȗ̈mۂłȂB
		**/
		self& operator=(const CList<T>& s){copy(s.begin(),s.count());return *this;}
		self& operator=(const DList<T>& s){copy(s.begin(),s.count());return *this;}
		NTMP self& operator=(const CFList<T,N>& s){copy(s.begin(),s.count());return *this;}
		NTMP self& operator=(const DFList<T,N>& s){copy(s.begin(),s.count());return *this;}

		/**
			w肵Xgw肵ʒuɑ}܂B
			[arg]
			s		: }郊XgB
			index	: }ʒuB
			[return]
			}ʒuB
			[exc]
			std::bad_alloc	: }̂ɕKvȗ̈mۂłȂB
			[note]
			̊֐͔͈̓`FbNsĂ܂B
			͈͊Ow肵ꍇ͖̓`łB
		**/
		long insertList(const CList<T>& s,ulong index){return insert(s.begin(),s.count(),index);}
		long insertList(const DList<T>& s,ulong index){return insert(s.begin(),s.count(),index);}
		NTMP long insertList(const CFList<T,N>& s,ulong index){return insert(s.begin(),s.count(),index);}
		NTMP long insertList(const DFList<T,N>& s,ulong index){return insert(s.begin(),s.count(),index);}
		/**
			w肵Xg擪ɑ}܂B
			[arg]
			s	: }郊XgB
			[return]
			}ʒuB 0 łB
			[exc]
			std::bad_alloc	: }̂ɕKvȗ̈mۂłȂB
		**/
		long firstInList(const CList<T>& s){return insert(s.begin(),s.count(),0);}
		long firstInList(const DList<T>& s){return insert(s.begin(),s.count(),0);}
		NTMP long firstInList(const CFList<T,N>& s){return insert(s.begin(),s.count(),0);}
		NTMP long firstInList(const DFList<T,N>& s){return insert(s.begin(),s.count(),0);}
		/**
			w肵XgI[ɒǉ܂B
			[arg]
			s	: ǉ郊XgB
			[return]
			ǉʒuB
			[exc]
			std::bad_alloc	: ǉ̂ɕKvȗ̈mۂłȂB
		**/
		long lastInList(const CList<T>& s){return insert(s.begin(),s.count(),count());}
		long lastInList(const DList<T>& s){return insert(s.begin(),s.count(),count());}
		NTMP long lastInList(const CFList<T,N>& s){return insert(s.begin(),s.count(),count());}
		NTMP long lastInList(const DFList<T,N>& s){return insert(s.begin(),s.count(),count());}

		/**
			w肵XgƓeւ܂B
			[arg]
			s	: ւ郊XgB
		**/
		void swap(const self& s){_swap(&s);}

		/**
			L̃o֐̐ IList NXQƂĂB
		**/
		virtual long insert(cptr data,ulong c,ulong index){return _container_insert(data,c,index,_List,_UseCount);}
		virtual void erageRange(cptr l,cptr r){_container_erage(l,r,_List,_UseCount);}
	};

	/**
		ϒf[^zReiNXłB
		̃NX̊{@\ STL Cu vector A list ɑ̂łA
		֐Ȃǂ͓ł͂܂B

		̃NX̓RXgN^EfXgN^𔭐܂B
		̂߁ANXgpf[^Ǘꍇ
		CList gpĂB

		̃NX̃o֐ CList Ɠs܂B
		eo֐̐ CList ̃o֐QƂĂB
	**/
	TMP class DList : public IList_Buffer<T>{
		typedef DList<T> self;
	public:
		DList(ulong c=0):IList_Buffer<T>(c){}
		DList(cptr p,ulong c):IList_Buffer<T>(c){copy(p,c);}
		explicit DList(const self& s):IList_Buffer<T>(s.count()){copy(s.begin(),s.count());}
		virtual ~DList(){}
		virtual long insert(cptr data,ulong c,ulong index){return _container_insert_n(data,c,index,_List,_UseCount);}
		virtual void erageRange(cptr l,cptr r){_container_erage_n(l,r,_List,_UseCount);}
		virtual void copy(cptr data,ulong c){clear();_container_copy_n(data,c,_List,_UseCount);}
		virtual void clear(){_UseCount = 0;}
		virtual bool equals(cptr p,ulong c)const{return _conatiner_equals_n(p,c,begin(),count());}
		operator bool()const{return !empty();}
		bool operator!()const{return empty();}
		ind operator[](ulong index){return at(index);}
		cind operator[](ulong index)const{return at(index);}
		bool operator==(const CList<T>& s)const{return equals(s.begin(),s.count());}
		bool operator==(const DList<T>& s)const{return equals(s.begin(),s.count());}
		NTMP bool operator==(const CFList<T,N>& s)const{return equals(s.begin(),s.count());}
		NTMP bool operator==(const DFList<T,N>& s)const{return equals(s.begin(),s.count());}
		bool operator!=(const CList<T>& s)const{return !equals(s.begin(),s.count());}
		bool operator!=(const DList<T>& s)const{return !equals(s.begin(),s.count());}
		NTMP bool operator!=(const CFList<T,N>& s)const{return !equals(s.begin(),s.count());}
		NTMP bool operator!=(const DFList<T,N>& s)const{return !equals(s.begin(),s.count());}
		self& operator=(const CList<T>& s){copy(s.begin(),s.count());return *this;}
		self& operator=(const DList<T>& s){copy(s.begin(),s.count());return *this;}
		NTMP self& operator=(const CFList<T,N>& s){copy(s.begin(),s.count());return *this;}
		NTMP self& operator=(const DFList<T,N>& s){copy(s.begin(),s.count());return *this;}
		long insertList(const CList<T>& s,ulong index){return insert(s.begin(),s.count(),index);}
		long insertList(const DList<T>& s,ulong index){return insert(s.begin(),s.count(),index);}
		NTMP long insertList(const CFList<T,N>& s,ulong index){return insert(s.begin(),s.count(),index);}
		NTMP long insertList(const DFList<T,N>& s,ulong index){return insert(s.begin(),s.count(),index);}
		long firstInList(const CList<T>& s){return insert(s.begin(),s.count(),0);}
		long firstInList(const DList<T>& s){return insert(s.begin(),s.count(),0);}
		NTMP long firstInList(const CFList<T,N>& s){return insert(s.begin(),s.count(),0);}
		NTMP long firstInList(const DFList<T,N>& s){return insert(s.begin(),s.count(),0);}
		long lastInList(const CList<T>& s){return insert(s.begin(),s.count(),count());}
		long lastInList(const DList<T>& s){return insert(s.begin(),s.count(),count());}
		NTMP long lastInList(const CFList<T,N>& s){return insert(s.begin(),s.count(),count());}
		NTMP long lastInList(const DFList<T,N>& s){return insert(s.begin(),s.count(),count());}
		void swap(const self& s){_swap(&s);}
	};

	/**
		NX̃RXgN^EfXgN^ɑΉA
		ϒNXzReiNXłB
		̃NX̊{@\ STL Cu vector A list ɑ̂łA
		֐Ȃǂ͓ł͂܂B

		̃NX̃o֐ CList Ɠs܂B
		eo֐̐ CList ̃o֐QƂĂB
		Œ蒷f[^߁A CList A DList ɂ Capacity ̈
		삷鏈i adjust ֐A clear ֐ clearCap j݂͑܂B
		[note]
		̃NX͌Œ蒷f[^߁A
		eʂ𒴂f[^̒ǉs std::runtime_error O
		܂B
	**/
	BUFTMP class CFList : public IList_Fixed<T,C>{
		typedef CFList<T,C> self;
	public:
		CFList():IList_Fixed<T,C>(){}
		CFList(cptr p,ulong c):IList_Fixed<T,C>(c){copy(p,c);}
		explicit CFList(const self& s):IList_Fixed<T,C>(s.count()){copy(s.begin(),s.count());}
		virtual ~CFList(){clear();}
		virtual long insert(cptr data,ulong c,ulong index){return _container_insert_fixed(data,c,index,_List,_UseCount);}
		virtual void erageRange(cptr l,cptr r){_container_erage_fixed(l,r,_List,_UseCount);}
		virtual void copy(cptr data,ulong c){clear();_container_copy_fixed(data,c,_List,_UseCount);}
		virtual void clear(){_container_clear_fixed(_List,_UseCount);}
		operator bool()const{return !empty();}
		bool operator!()const{return empty();}
		ind operator[](ulong index){return at(index);}
		cind operator[](ulong index)const{return at(index);}
		bool operator==(const CList<T>& s)const{return equals(s.begin(),s.count());}
		bool operator==(const DList<T>& s)const{return equals(s.begin(),s.count());}
		NTMP bool operator==(const CFList<T,N>& s)const{return equals(s.begin(),s.count());}
		NTMP bool operator==(const DFList<T,N>& s)const{return equals(s.begin(),s.count());}
		bool operator!=(const CList<T>& s)const{return !equals(s.begin(),s.count());}
		bool operator!=(const DList<T>& s)const{return !equals(s.begin(),s.count());}
		NTMP bool operator!=(const CFList<T,N>& s)const{return !equals(s.begin(),s.count());}
		NTMP bool operator!=(const DFList<T,N>& s)const{return !equals(s.begin(),s.count());}
		self& operator=(const CList<T>& s){copy(s.begin(),s.count());return *this;}
		self& operator=(const DList<T>& s){copy(s.begin(),s.count());return *this;}
		self& operator=(const CFList<T,C>& s){copy(s.begin(),s.count());return *this;}
		self& operator=(const DFList<T,C>& s){copy(s.begin(),s.count());return *this;}
		NTMP self& operator=(const CFList<T,N>& s){copy(s.begin(),s.count());return *this;}
		NTMP self& operator=(const DFList<T,N>& s){copy(s.begin(),s.count());return *this;}
		long insertList(const CList<T>& s,ulong index){return insert(s.begin(),s.count(),index);}
		long insertList(const DList<T>& s,ulong index){return insert(s.begin(),s.count(),index);}
		NTMP long insertList(const CFList<T,N>& s,ulong index){return insert(s.begin(),s.count(),index);}
		NTMP long insertList(const DFList<T,N>& s,ulong index){return insert(s.begin(),s.count(),index);}
		long firstInList(const CList<T>& s){return insert(s.begin(),s.count(),0);}
		long firstInList(const DList<T>& s){return insert(s.begin(),s.count(),0);}
		NTMP long firstInList(const CFList<T,N>& s){return insert(s.begin(),s.count(),0);}
		NTMP long firstInList(const DFList<T,N>& s){return insert(s.begin(),s.count(),0);}
		long lastInList(const CList<T>& s){return insert(s.begin(),s.count(),count());}
		long lastInList(const DList<T>& s){return insert(s.begin(),s.count(),count());}
		NTMP long lastInList(const CFList<T,N>& s){return insert(s.begin(),s.count(),count());}
		NTMP long lastInList(const DFList<T,N>& s){return insert(s.begin(),s.count(),count());}
		void swap(const self& s){_swap(&s);}
	};
	/**
		ϒf[^zReiNXłB
		̃NX̊{@\ STL Cu vector A list ɑ̂łA
		֐Ȃǂ͓ł͂܂B

		̃NX̓RXgN^EfXgN^𔭐܂B
		̂߁ANXgpf[^Ǘꍇ
		CFList gpĂB

		̃NX̃o֐ CFList Ɠs܂B
		eo֐̐ CFList ̃o֐QƂĂB
		Œ蒷f[^߁A CList A DList ɂ Capacity ̈
		삷鏈i adjust ֐A clear ֐ clearCap j݂͑܂B
		[note]
		̃NX͌Œ蒷f[^߁A
		eʂ𒴂f[^̒ǉs std::runtime_error O
		܂B
	**/
	BUFTMP class DFList : public IList_Fixed<T,C>{
		typedef DFList<T,C> self;
	public:
		DFList():IList_Fixed<T,C>(){}
		DFList(cptr p,ulong c):IList_Fixed<T,C>(c){copy(p,c);}
		explicit DFList(const self& s):IList_Fixed<T,C>(s.count()){copy(s.begin(),s.count());}
		virtual ~DFList(){}
		virtual long insert(cptr data,ulong c,ulong index){return _container_insert_fixed_n(data,c,index,_List,_UseCount);}
		virtual void erageRange(cptr l,cptr r){_container_erage_fixed_n(l,r,_List,_UseCount);}
		virtual void copy(cptr data,ulong c){clear();_container_copy_fixed_n(data,c,_List,_UseCount);}
		virtual void clear(){_UseCount=0;}
		virtual bool equals(cptr p,ulong c)const{return _conatiner_equals_n(p,c,begin(),count());}
		operator bool()const{return !empty();}
		bool operator!()const{return empty();}
		ind operator[](ulong index){return at(index);}
		cind operator[](ulong index)const{return at(index);}
		bool operator==(const CList<T>& s)const{return equals(s.begin(),s.count());}
		bool operator==(const DList<T>& s)const{return equals(s.begin(),s.count());}
		NTMP bool operator==(const CFList<T,N>& s)const{return equals(s.begin(),s.count());}
		NTMP bool operator==(const DFList<T,N>& s)const{return equals(s.begin(),s.count());}
		bool operator!=(const CList<T>& s)const{return !equals(s.begin(),s.count());}
		bool operator!=(const DList<T>& s)const{return !equals(s.begin(),s.count());}
		NTMP bool operator!=(const CFList<T,N>& s)const{return !equals(s.begin(),s.count());}
		NTMP bool operator!=(const DFList<T,N>& s)const{return !equals(s.begin(),s.count());}
		self& operator=(const CList<T>& s){copy(s.begin(),s.count());return *this;}
		self& operator=(const DList<T>& s){copy(s.begin(),s.count());return *this;}
		self& operator=(const CFList<T,C>& s){copy(s.begin(),s.count());return *this;}
		self& operator=(const DFList<T,C>& s){copy(s.begin(),s.count());return *this;}
		NTMP self& operator=(const CFList<T,N>& s){copy(s.begin(),s.count());return *this;}
		NTMP self& operator=(const DFList<T,N>& s){copy(s.begin(),s.count());return *this;}
		long insertList(const CList<T>& s,ulong index){return insert(s.begin(),s.count(),index);}
		long insertList(const DList<T>& s,ulong index){return insert(s.begin(),s.count(),index);}
		NTMP long insertList(const CFList<T,N>& s,ulong index){return insert(s.begin(),s.count(),index);}
		NTMP long insertList(const DFList<T,N>& s,ulong index){return insert(s.begin(),s.count(),index);}
		long firstInList(const CList<T>& s){return insert(s.begin(),s.count(),0);}
		long firstInList(const DList<T>& s){return insert(s.begin(),s.count(),0);}
		NTMP long firstInList(const CFList<T,N>& s){return insert(s.begin(),s.count(),0);}
		NTMP long firstInList(const DFList<T,N>& s){return insert(s.begin(),s.count(),0);}
		long lastInList(const CList<T>& s){return insert(s.begin(),s.count(),count());}
		long lastInList(const DList<T>& s){return insert(s.begin(),s.count(),count());}
		NTMP long lastInList(const CFList<T,N>& s){return insert(s.begin(),s.count(),count());}
		NTMP long lastInList(const DFList<T,N>& s){return insert(s.begin(),s.count(),count());}
		void swap(const self& s){_swap(&s);}
	};


} // namespace scpl
#endif