// 
// CallBack.h
// 
// Copyright(C) 2007 Ó
#ifndef _CallBack_INCLUDED_
#define _CallBack_INCLUDED_

#include "arglist.h"

/**
	R[obN֐pbNNXQłB
	NX̌̐ƕ
	R[obN֐̈̐Ɩ߂l̗Lw肵܂B
	̃NXgpꍇ"CallBackGen.h"̊֐gpĂB
**/

namespace scpl{

	class CallBack{
	public:
		virtual cvptr getFunc()const=0;
		virtual cvptr getClass()const=0;
		virtual bool equal(cvptr f)const=0;
		virtual bool equal(cvptr f,cvptr c)const=0;
		virtual bool equalCB(const CallBack* cb)const{return (cb->getFunc() == getFunc())&&(cb->getClass() == getClass());}
		virtual bool operator==(const CallBack& cb)const{return equal(cb.getFunc(),cb.getClass());}
		virtual bool operator==(cvptr f)const{return equal(f);}
		virtual bool operator!=(const CallBack& cb)const{return !equal(cb.getFunc(),cb.getClass());}
		virtual bool operator!=(cvptr f)const{return !equal(f);}
	};
	class CallBack0v : public CallBack{
	public:
		virtual ~CallBack0v(){}
		virtual void call()=0;
	};

	template <class ResultType>
	class CallBack0r : public CallBack{
	public:
		virtual ~CallBack0r(){}
		virtual ResultType call()=0;
	};

	class CallBack0vg:public CallBack0v{
	public:
		typedef void (*FuncType)();
		CallBack0vg(FuncType f):_f(f){}
		virtual void call(){_f();}
		virtual bool equal(cvptr f)const{return _f == f;}
		virtual bool equal(cvptr f,cvptr c)const{return (c == NULL)&&(_f == f);}
		virtual cvptr getFunc()const{return _f;}
		virtual cvptr getClass()const{return NULL;}
	private:
		FuncType _f;
	};
	template <class Class>
	class CallBack0vc:public CallBack0v{
	public:
		typedef void (Class::*FuncType)();
		CallBack0vc(FuncType f,Class* c):_f(f),_c(c){}
		virtual void call(){(_c->*_f)();}
		virtual bool equal(cvptr f)const{return false;}
		virtual bool equal(cvptr f,cvptr c)const{return (_c == c)&&(_f == *(FuncType*)f);}
		virtual cvptr getFunc()const{return &_f;}
		virtual cvptr getClass()const{return _c;}
	private:
		Class* _c;
		FuncType _f;
	};

	template <class ResuleType>
	class CallBack0rg:public CallBack0r<ResuleType>{
	public:
		typedef ResuleType (*FuncType)();
		CallBack0rg(FuncType f):_f(f){}
		virtual ResuleType call(){return _f();}
		virtual bool equal(cvptr f)const{return _f == f;}
		virtual bool equal(cvptr f,cvptr c)const{return (c == NULL)&&(_f == f);}
		virtual cvptr getFunc()const{return _f;}
		virtual cvptr getClass()const{return NULL;}
	private:
		FuncType _f;
	};
	template <class Class,class ResuleType>
	class CallBack0rc:public CallBack0r<ResuleType>{
	public:
		typedef ResuleType (Class::*FuncType)();
		CallBack0rc(FuncType f,Class* c):_f(f),_c(c){}
		virtual ResuleType call(){return (_c->*_f)();}
		virtual bool equal(cvptr f)const{return false;}
		virtual bool equal(cvptr f,cvptr c)const{return (_c == c)&&(_f == *(FuncType*)f);}
		virtual cvptr getFunc()const{return &_f;}
		virtual cvptr getClass()const{return _c;}
	private:
		Class* _c;
		FuncType _f;
	};

/*
	L͈t̃oChNX`̂Ɏw肵Ă}NQB
*/

#define CALLBACK_DEF(N,TL,AL1,AL2,AL3)\
	template <TL> class CallBack##N##v : public CallBack{\
	public:\
		virtual ~CallBack##N##v(){}\
		virtual void call(AL2)=0;\
	};\
	template <class ResultType,TL>\
	class CallBack##N##r : public CallBack{\
	public:\
		virtual ~CallBack##N##r(){}\
		virtual ResultType call(AL2)=0;\
	};\
	template <TL> class CallBack##N##vg:public CallBack##N##v<AL1>{\
	public:\
		typedef void (*FuncType)(AL1);\
		CallBack##N##vg(FuncType f):_f(f){}\
		virtual void call(AL2){_f(AL3);}\
		virtual bool equal(cvptr f)const{return _f == f;}\
		virtual bool equal(cvptr f,cvptr c)const{return (c == NULL)&&(_f == f);}\
		virtual cvptr getFunc()const{return _f;}\
		virtual cvptr getClass()const{return NULL;}\
	private:\
		FuncType _f;\
	};\
	template <class Class,TL>\
	class CallBack##N##vc:public CallBack##N##v<AL1>{\
	public:\
		typedef void (Class::*FuncType)(AL1);\
		CallBack##N##vc(FuncType f,Class* c):_f(f),_c(c){}\
		virtual void call(AL2){(_c->*_f)(AL3);}\
		virtual bool equal(cvptr f)const{return false;}\
		virtual bool equal(cvptr f,cvptr c)const{return (_c == c)&&(_f == *(FuncType*)f);}\
		virtual cvptr getFunc()const{return &_f;}\
		virtual cvptr getClass()const{return _c;}\
	private:\
		Class* _c;\
		FuncType _f;\
	};\
	template <class ResuleType,TL>\
	class CallBack##N##rg:public CallBack##N##r<ResuleType,AL1>{\
	public:\
		typedef ResuleType (*FuncType)(AL1);\
		CallBack##N##rg(FuncType f):_f(f){}\
		virtual ResuleType call(AL2){return _f(AL3);}\
		virtual bool equal(cvptr f)const{return _f == f;}\
		virtual bool equal(cvptr f,cvptr c)const{return (c == NULL)&&(_f == f);}\
		virtual cvptr getFunc()const{return _f;}\
		virtual cvptr getClass()const{return NULL;}\
	private:\
		FuncType _f;\
	};\
	template <class Class,class ResuleType,TL>\
	class CallBack##N##rc:public CallBack##N##r<ResuleType,AL1>{\
	public:\
		typedef ResuleType (Class::*FuncType)(AL1);\
		CallBack##N##rc(FuncType f,Class* c):_f(f),_c(c){}\
		virtual ResuleType call(AL2){return (_c->*_f)(AL3);}\
		virtual bool equal(cvptr f)const{return false;}\
		virtual bool equal(cvptr f,cvptr c)const{return (_c == c)&&(_f == *(FuncType*)f);}\
		virtual cvptr getFunc()const{return &_f;}\
		virtual cvptr getClass()const{return _c;}\
	private:\
		Class* _c;\
		FuncType _f;\
	}

	CALLBACK_DEF(1,TMP1L,ARG1L1,ARG1L2,ARG1L3);
	CALLBACK_DEF(2,TMP2L,ARG2L1,ARG2L2,ARG2L3);
	CALLBACK_DEF(3,TMP3L,ARG3L1,ARG3L2,ARG3L3);
	CALLBACK_DEF(4,TMP4L,ARG4L1,ARG4L2,ARG4L3);
	CALLBACK_DEF(5,TMP5L,ARG5L1,ARG5L2,ARG5L3);
	CALLBACK_DEF(6,TMP6L,ARG6L1,ARG6L2,ARG6L3);

#undef CALLBACK_DEF

} // namespace scpl
#include "CallBackGen.h"
#endif
