#include "stdafx.h"
#include "..\scpl/Range.h"

using namespace scpl;

typedef Range<byte> BR;

void test_Range(){
	{
		BR a;
		BR b(10,12);
		BR c(100,200,150);
		BR d(0,200,200);

		SUT_ASSERT_EQUALS(Int,a.getMin(),0);
		SUT_ASSERT_EQUALS(Int,a.getVal(),0);
		SUT_ASSERT_EQUALS(Int,a.getMax(),100);

		SUT_ASSERT_EQUALS(Int,b.getMin(),10);
		SUT_ASSERT_EQUALS(Int,b.getVal(),10);
		SUT_ASSERT_EQUALS(Int,b.getMax(),12);

		SUT_ASSERT_EQUALS(Int,c.getMin(),100);
		SUT_ASSERT_EQUALS(Int,c.getVal(),150);
		SUT_ASSERT_EQUALS(Int,c.getMax(),200);

		SUT_ASSERT_EQUALS(Int,d.getMin(),0);
		SUT_ASSERT_EQUALS(Int,d.getVal(),200);
		SUT_ASSERT_EQUALS(Int,d.getMax(),200);

		SUT_ASSERT_EQUALS(Int,a.getProgress(),0);
		SUT_ASSERT_EQUALS(Int,a.getRProgress(),100);
		SUT_ASSERT_EQUALS(Int,a.getProgressParInt(),0);
		SUT_ASSERT_EQUALS(Dbl,a.getProgressParDouble(),0.0);
		SUT_ASSERT_EQUALS(Dbl,a.getProgressParFloat(),0.0f);
		SUT_ASSERT_EQUALS(Int,a.getRProgressParInt(),100);
		SUT_ASSERT_EQUALS(Dbl,a.getRProgressParDouble(),1.0);
		SUT_ASSERT_EQUALS(Dbl,a.getRProgressParFloat(),1.0f);

		SUT_ASSERT_EQUALS(Int,b.getProgress(),0);
		SUT_ASSERT_EQUALS(Int,b.getRProgress(),2);
		SUT_ASSERT_EQUALS(Int,b.getProgressParInt(),0);
		SUT_ASSERT_EQUALS(Dbl,b.getProgressParDouble(),0.0);
		SUT_ASSERT_EQUALS(Dbl,b.getProgressParFloat(),0.0f);
		SUT_ASSERT_EQUALS(Int,b.getRProgressParInt(),100);
		SUT_ASSERT_EQUALS(Dbl,b.getRProgressParDouble(),1.0);
		SUT_ASSERT_EQUALS(Dbl,b.getRProgressParFloat(),1.0f);

		SUT_ASSERT_EQUALS(Int,c.getProgress(),50);
		SUT_ASSERT_EQUALS(Int,c.getRProgress(),50);
		SUT_ASSERT_EQUALS(Int,c.getProgressParInt(),50);
		SUT_ASSERT_EQUALS(Dbl,c.getProgressParDouble(),0.5);
		SUT_ASSERT_EQUALS(Dbl,c.getProgressParFloat(),0.5f);
		SUT_ASSERT_EQUALS(Int,c.getRProgressParInt(),50);
		SUT_ASSERT_EQUALS(Dbl,c.getRProgressParDouble(),0.5);
		SUT_ASSERT_EQUALS(Dbl,c.getRProgressParFloat(),0.5f);

		SUT_ASSERT_EQUALS(Int,d.getProgress(),200);
		SUT_ASSERT_EQUALS(Int,d.getRProgress(),0);
		SUT_ASSERT_EQUALS(Int,d.getProgressParInt(),100);
		SUT_ASSERT_EQUALS(Dbl,d.getProgressParDouble(),1.0);
		SUT_ASSERT_EQUALS(Dbl,d.getProgressParFloat(),1.0f);
		SUT_ASSERT_EQUALS(Int,d.getRProgressParInt(),0);
		SUT_ASSERT_EQUALS(Dbl,d.getRProgressParDouble(),0.0);
		SUT_ASSERT_EQUALS(Dbl,d.getRProgressParFloat(),0.0f);

		SUT_ASSERT(Int,a.isMin());
		SUT_ASSERT(Int,!a.isMax());
		SUT_ASSERT(Int,!a.isFixed());

		SUT_ASSERT(Int,b.isMin());
		SUT_ASSERT(Int,!b.isMax());
		SUT_ASSERT(Int,!b.isFixed());

		SUT_ASSERT(Int,!c.isMin());
		SUT_ASSERT(Int,!c.isMax());
		SUT_ASSERT(Int,!c.isFixed());

		SUT_ASSERT(Int,!d.isMin());
		SUT_ASSERT(Int,d.isMax());
		SUT_ASSERT(Int,!d.isFixed());

		++a;++b;++c;++d;

		SUT_ASSERT_EQUALS(Int,a.getVal(),1);
		SUT_ASSERT_EQUALS(Int,b.getVal(),11);
		SUT_ASSERT_EQUALS(Int,c.getVal(),151);
		SUT_ASSERT_EQUALS(Int,d.getVal(),200);

		SUT_ASSERT_EQUALS(Int,b.getProgress(),1);
		SUT_ASSERT_EQUALS(Int,b.getRProgress(),1);
		SUT_ASSERT_EQUALS(Int,b.getProgressParInt(),50);
		SUT_ASSERT_EQUALS(Dbl,b.getProgressParDouble(),0.5);
		SUT_ASSERT_EQUALS(Dbl,b.getProgressParFloat(),0.5f);
		SUT_ASSERT_EQUALS(Int,b.getRProgressParInt(),50);
		SUT_ASSERT_EQUALS(Dbl,b.getRProgressParDouble(),0.5);
		SUT_ASSERT_EQUALS(Dbl,b.getRProgressParFloat(),0.5f);

		a-=2;b-=2;c-=2;d-=2;

		SUT_ASSERT_EQUALS(Int,a.getVal(),0);
		SUT_ASSERT_EQUALS(Int,b.getVal(),10);
		SUT_ASSERT_EQUALS(Int,c.getVal(),149);
		SUT_ASSERT_EQUALS(Int,d.getVal(),198);

		SUT_ASSERT(Int,a.setVal(90));
		SUT_ASSERT(Int,b.setMin(8));
		SUT_ASSERT(Int,c.setMax(199));
		SUT_ASSERT(Int,!a.setVal(101));
		SUT_ASSERT(Int,!b.setMin(12));
		SUT_ASSERT(Int,!c.setMax(100));
		try{d.set(10,10);SUT_ASSERT(Int,false);}
		catch(InvalidParamExc){}
		try{d.set(120,220);}
		catch(InvalidParamExc){SUT_ASSERT(Int,false);}
		try{d.set(10,10,11);SUT_ASSERT(Int,false);}
		catch(InvalidParamExc){}
		try{d.set(10,10,10);}
		catch(InvalidParamExc){SUT_ASSERT(Int,false);}
		
		SUT_ASSERT(Int,d.isFixed());
		SUT_ASSERT_EQUALS(Int,d,10);
	}
	

}
